<?php

namespace _JchOptimizeVendor\GuzzleHttp\Psr7;

use _JchOptimizeVendor\Psr\Http\Message\StreamInterface;

/**
 * Stream decorator that begins dropping data once the size of the underlying
 * stream becomes too full.
 *
 * @final
 */
class DroppingStream implements StreamInterface
{
    use StreamDecoratorTrait;
    private $maxLength;

    /**
     * @param StreamInterface $stream    underlying stream to decorate
     * @param int             $maxLength maximum size before dropping data
     */
    public function __construct(StreamInterface $stream, $maxLength)
    {
        $this->stream = $stream;
        $this->maxLength = $maxLength;
    }

    public function write($string)
    {
        $diff = $this->maxLength - $this->stream->getSize();
        // Begin returning 0 when the underlying stream is too large.
        if ($diff <= 0) {
            return 0;
        }
        // Write the stream or a subset of the stream if needed.
        if (\strlen($string) < $diff) {
            return $this->stream->write($string);
        }

        return $this->stream->write(\substr($string, 0, $diff));
    }
}
