<?php

/**
 * Part of the Joomla Framework Renderer Package.
 *
 * @copyright  Copyright (C) 2005 - 2021 Open Source Matters, Inc. All rights reserved.
 * @license    http://www.gnu.org/licenses/lgpl-2.1.txt GNU Lesser General Public License Version 2.1 or Later
 */

namespace _JchOptimizeVendor\Joomla\Renderer;

/**
 * Interface for a renderer which can have template paths added during runtime.
 *
 * @since  2.0.0
 */
interface AddTemplateFolderInterface
{
    /**
     * Add a folder with alias to the renderer.
     *
     * @param string $directory The folder path
     * @param string $alias     The folder alias
     *
     * @return $this
     *
     * @since   2.0.0
     */
    public function addFolder(string $directory, string $alias = '');
}
