<?php

// phpcs:disable Generic.NamingConventions.ConstructorName.OldStyle, WebimpressCodingStandard.NamingConventions.AbstractClass.Prefix

namespace _JchOptimizeVendor\Laminas\Paginator;

use _JchOptimizeVendor\Laminas\Paginator\Adapter\AdapterInterface;
use _JchOptimizeVendor\Laminas\ServiceManager\ServiceManager;
use _JchOptimizeVendor\Laminas\Stdlib\ArrayUtils;

abstract class Factory
{
    /**
     * Adapter plugin manager.
     *
     * @var AdapterPluginManager
     */
    protected static $adapters;

    /**
     * Create paginator with items and adapter.
     *
     * @param mixed $items
     * @param mixed $adapter
     *
     * @return Paginator
     */
    public static function factory($items, $adapter = null)
    {
        if (null === $adapter) {
            return static::createAdapterFromItems($items);
        }

        return static::getAdapterFromManager($items, $adapter);
    }

    /**
     * Change the adapter plugin manager.
     */
    public static function setAdapterPluginManager(AdapterPluginManager $adapters)
    {
        static::$adapters = $adapters;
    }

    /**
     * Get the adapter plugin manager.
     *
     * @return AdapterPluginManager
     */
    public static function getAdapterPluginManager()
    {
        if (null === static::$adapters) {
            static::$adapters = new AdapterPluginManager(new ServiceManager());
        }

        return static::$adapters;
    }

    /**
     * Create adapter from items if necessary, and return paginator.
     *
     * @param iterable $items
     *
     * @return Paginator
     */
    protected static function createAdapterFromItems($items)
    {
        if ($items instanceof \Traversable) {
            $items = ArrayUtils::iteratorToArray($items);
        }
        if (!\is_array($items)) {
            throw new Exception\InvalidArgumentException('The factory needs an associative array or a Traversable object as an argument when '."it's used with one parameter");
        }
        if (!isset($items['adapter']) && !isset($items['items'])) {
            throw new Exception\InvalidArgumentException('The factory needs an associative array or a Traversable object with keys "adapter" and "items"');
        }
        $adapter = $items['adapter'];
        $items = $items['items'];

        return static::getAdapterFromManager($items, $adapter);
    }

    /**
     * Get adapter from manager if necessary, and return paginator.
     *
     * @param mixed $items
     * @param mixed $adapter
     *
     * @return Paginator
     */
    protected static function getAdapterFromManager($items, $adapter)
    {
        if ($adapter instanceof AdapterInterface || $adapter instanceof AdapterAggregateInterface) {
            return new Paginator($adapter);
        }
        $adapter = static::getAdapterPluginManager()->get($adapter, $items);

        return new Paginator($adapter);
    }
}
