<?php
/*------------------------------------------------------------------------
# calendar.html.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2016 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;

class HTML_OsAppscheduleCalendar{
	/**
	 * List all the work of employee in calendar
	 * @param unknown_type $employee
	 */
	function employeeCalendar($eIds,$lists = array(),$filterSid = 0){
		global $mainframe,$configClass,$jinput;
		OSBHelper::loadTooltip();
		?>
		<form method="POST" action="<?php echo JRoute::_('index.php?option=com_osservicesbooking&task=calendar_employee')?>" id="ftForm" name="ftForm">
		<?php
			$year = $jinput->getInt('year',date("Y",time()));
			$month =  intval($jinput->getInt('month',date("m",time())));
			self::initEmployeeCalendar($eIds,$year,$month,$lists,$filterSid);
		?>
		</form>
		<?php
	}
	/**
	 * Init Availability calendar for Employee In Backend
	 *
	 * @param unknown_type $pid
	 * @param unknown_type $year
	 * @param unknown_type $month
	 */
	function initEmployeeCalendar($eIds,$year,$month,$lists,$filterSid){
		global $mainframe,$configClass,$jinput;
		$config = new JConfig();
        JToolBarHelper::title(JText::_('OS_ORDERS_CALENDAR'),'list');
        JToolbarHelper::custom('orders_list','list.png','list.png',JText::_('OS_MANAGE_ORDERS'), false);
        JToolbarHelper::custom('cpanel_list','featured.png', 'featured_f2.png',JText::_('OS_DASHBOARD'),false);
		$offset = $config->offset;
		date_default_timezone_set($offset);
		JHTML::_('behavior.modal','a.osmodal');
		$db = JFactory::getDbo();
		include_once(JPATH_COMPONENT_ADMINISTRATOR.DS."classes".DS."ajax.php");
		$today						= OSBHelper::getCurrentDate();
		$current_month 				= intval(date("m",$today));
		$current_year				= intval(date("Y",$today));
		$current_date				= intval(date("d",$today));
		//set up the first date
		$start_date_current_month 	= strtotime($year."-".$month."-01");
		$start_date_in_week			= date("N",$start_date_current_month);
		$number_days_in_month		= cal_days_in_month(CAL_GREGORIAN,$month,$year);
		$monthArr = array( JText::_('OS_JANUARY'), JText::_('OS_FEBRUARY'), JText::_('OS_MARCH'), JText::_('OS_APRIL'), JText::_('OS_MAY'), JText::_('OS_JUNE'), JText::_('OS_JULY'), JText::_('OS_AUGUST'), JText::_('OS_SEPTEMBER'), JText::_('OS_OCTOBER'), JText::_('OS_NOVEMBER'), JText::_('OS_DECEMBER'));
		?>
        <form method="POST" action="index.php?option=com_osservicesbooking&task=calendar_employee" name="adminForm" id="adminForm">
		<div id="cal<?php echo intval($month)?><?php echo $year?>">
			<div class="text-center">
				<?php echo $lists['sid'];?>
				<?php echo $lists['emp'];?>
			</div>
			<table  width="100%" class="apptable">
				<tr>
					<td width="40%" align="right" style="span-weight:bold;span-size:15px;">
						<span onclick="ChangeMonth('pre')" class="applink" style="cursor: pointer;">
						<b><</b>
						</span>
					</td>
					<td width="20%" align="center" style="height:25px;span-weight:bold;">
						<?php
						echo $monthArr[$month-1];
						?>
						&nbsp;
						<?php echo $year;?>
					</td>
					<td width="40%" align="left" style="span-weight:bold;span-size:15px;">
						<span onclick="ChangeMonth('next')" class="applink" style="cursor: pointer;">
						<b>></b>
						</span>
					</td>
				</tr>
				<tr>
					<td width="100%" colspan="3" style="padding:3px;text-align:center;">
						<select name="ossm" class="input-small" id="ossm">
							<?php							
							for($i=0;$i<count($monthArr);$i++){
								if(intval($month) == $i + 1){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i + 1?>" <?php echo $selected?>><?php echo $monthArr[$i]?></option>
								<?php
							}
							?>
						</select>
						<select name="ossy" class="input-small" id="ossy">
							<?php
							for($i=date("Y",$today);$i<=date("Y",$today)+3;$i++){
								if(intval($year) == $i){
									$selected = "selected";
								}else{
									$selected = "";
								}
								?>
								<option value="<?php echo $i?>" <?php echo $selected?>><?php echo $i?></option>
								<?php
							}
							?>
						</select>
						<input type="button" class="button" value="Go" onclick="javascript:ChangeMonth('keep');">
					</td>
				</tr>
			</table>
			<table  width="100%">
				<tr>
					<td  width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_MON')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_TUE')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_WED')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_THU')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_FRI')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_SAT')?>
						</span>
					</td>
					<td width="14%">
						<span class="header_rounded">
							<?php echo JText::_('OS_SUN')?>
						</span>
					</td>
				</tr>
				<tr>
					<?php
					for($i=1;$i<$start_date_in_week;$i++){
						//empty
						?>
						<td>
						
						</td>
						<?php
					}
					$j = $start_date_in_week-1;
					
					$m = "";
					if(intval($month) < 10){
						$m = "0".$month;
					}else{
						$m = $month;
					}
					$month = $m;
					
					for($i=1;$i<=$number_days_in_month;$i++){
						$j++;
						$nolink = 0;
						//check to see if today
						if(($i == $current_date) and ($month == $current_month) and ($year == $current_year)){
							$bgcolor = "pink";
						}else{
							$bgcolor = "#F1F1F1";
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						$tempdate1 = strtotime($year."-".$month."-".$day);
						$tempdate2 = strtotime($current_year."-".$current_month."-".$current_date);
						
						if($tempdate1 < $tempdate2){
							$bgcolor = "#ABAAB2";
							$nolink = 4;
						}
						
						if($i < 10){
							$day = "0".$i;
						}else{
							$day = $i;
						}
						$date = $year."-".$month."-".$day;
						?>
						<td id="td_cal_<?php echo $i?>"  align="center" class="td_date" style="text-align:center;" valign="top">
							<div id="a<?php echo $i;?>" style="border:1px solid #efefef;width:90%;" class="div-rounded">
								<?php
								self::calendarEmployeeItemAjax($i,$eIds,$date,$filterSid);
								?>
							</div>
						</td>
						<?php
						if($j >= 7){
							$j = 0;
							echo "</tr><tr>";
						}
						
					}
					?>
				</tr>
			</table>
			<input type="hidden" name="current_item_value" id="current_item_value" value="" />
			<input type="hidden" name="current_td" id="current_td" value="" />
			<input type="hidden" name="date" id="date" value="" />
			<input type="hidden" name="month" id="month" value="<?php echo $jinput->getInt('month',intval(date("m",HelperOSappscheduleCommon::getRealTime())));?>" />
			<input type="hidden" name="year" id="year" value="<?php echo $jinput->getInt('year',intval(date("Y",HelperOSappscheduleCommon::getRealTime())));?>" />
		</div>
        <input type="hidden" name="option" value="com_osservicesbooking" />
        <input type="hidden" name="task" value="calendar_employee" />
        <input type="hidden" name="boxchecked" value="0" />
        </form>
		<script type="text/javascript">
				function ChangeMonth(act){
					var month = document.getElementById('month');
					var year  = document.getElementById('year');
					month 	  = month.value;
					year	  = year.value;
					if(act == 'next'){
						if(month < 12){
						month = parseInt(month) + 1;
						}else{
							year  = parseInt(year) + 1;
							month = 1;
						}
					}else if(act == 'pre'){
						if(month > 1){
						month = parseInt(month) - 1;
						}else{
							year  = parseInt(year) - 1;
							month = 12;
						}
					}else{
						month = document.getElementById('ossm').value;
						year  = document.getElementById('ossy').value;
					}
					document.getElementById('month').value = month;
					document.getElementById('year').value = year;
					ftForm.submit();
				}
		</script>
		<?php
	}
	public static function calendarEmployeeItemAjax($i,$eIds,$day,$filterSid)
    {
		//if(!count($eIds)){return;}
		//print_r($eIds);die();
		global $mainframe,$configClass;
		$config = new JConfig();
		$offset = $config->offset;
		date_default_timezone_set($offset);
		$db  = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->clear()->select('a.*,c.service_name,b.order_status')
			  ->from('#__app_sch_order_items AS a')	
			  ->innerJoin('#__app_sch_orders AS b ON b.id = a.order_id')
			  ->innerJoin('#__app_sch_services AS c ON c.id = a.sid')
			  //->where('a.eid IN ('.implode(',',$eIds).')')
			  ->where("(b.order_status = 'P' or b.order_status = 'S')")
			  ->where('a.booking_date = '.$db->quote($day))
			  ->order('a.start_time');
		if($filterSid > 0){
			  $query->where('c.id = '.$filterSid);
		}
		//echo($query->__toString());die();
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		$query->clear()->select('id')->from('#__app_sch_employee')->where('id IN ('.implode(',',$eIds).')');
		$db->setQuery($query);
		$colorCodes = ['#FFFF99','#66FFFF','#FFCC00','#CC0000','#FF6600'];
		?>
		<div style="float:left;width:50%;">
			<b>
				<?php
				if($day == date("Y-m-d",OSBHelper::getCurrentDate())){
					echo "<span color='#E3462D'>";
					echo $i;
					echo "</span>";
				}else{
					echo $i;
				}
				?>
			</b>
		</div>
		<div style="clear: both;"></div>
		<div class="div-schedule">
		<?php
		if(count($rows) > 0){
			for($k=0;$k<count($rows);$k++){
				$config = new JConfig();
				$offset = $config->offset;
				date_default_timezone_set($offset);
				$row = $rows[$k];
				$index          = $row->sid % count($colorCodes);
				$bgColor		= ($colorCodes[$index])?$colorCodes[$index]:"#FFFFFF";
				$Textcolor		= "#000000";
				?>
				<div style="background:<?php echo $bgColor; ?>;color:<?php echo $Textcolor; ?>;margin-bottom: 2px;">
					<span class="hasTip" title="<?php echo OSBHelper::generateBookingItem($row,0);?>">
					<?php
					echo $k + 1;
					echo ". ";
					//echo "<a href='".JURI::root()."index.php?option=com_osservicesbooking&task=calendar_dateinfo&date=$day' class='modal'>";
					echo date($configClass['time_format'],$row->start_time);
					echo "-";
					echo date($configClass['time_format'],$row->end_time);
					//echo "</a>";
					echo "  [".$row->service_name."]";
					echo '<span class="label">'.OSBHelper::orderStatus(0,$row->order_status).'</span>';
					echo "<BR />";
					?>
					</span>
				</div>
				<?php
			}
		}else{
			echo JText::_('OS_NO_BOOKING_REQUEST');
		}
		?>
		</div>
		<?php
	}
}
?>