<?php
/**
* @package RSForm! Pro
* @copyright (C) 2007-2019 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

defined('_JEXEC') or die('Restricted access');

require_once JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/field.php';

class RSFormProFieldJoomlacaptcha extends RSFormProField
{
	// backend preview
	public function getPreviewInput()
	{
		return JText::_('RSFP_JOOMLA_BUILT_IN_CAPTCHA_LABEL');
	}

	private function getCaptcha()
	{
		$captcha = $this->getProperty('CAPTCHA');

		if ($captcha == 'joomla_default')
		{
			$captcha = JFactory::getConfig()->get('captcha');
		}

		return $captcha;
	}
	
	// functions used for rendering in front view
	public function getFormInput()
	{
		$formId		 = $this->formId;
		$form 		 = RSFormProHelper::getForm($formId);
		$logged		 = $form->RemoveCaptchaLogged ? JFactory::getUser()->id : false;
		$componentId = $this->componentId;

		if ($logged)
		{
			return '';
		}

		$captcha = $this->getCaptcha();
		if (!empty($captcha))
		{
			$attr = $this->getAttributes();

			$newAttributes = array();
			foreach ($attr as $key => $value)
			{
				// Ignore the class attribute
				if ($key == 'class')
				{
					continue;
				}

				$newAttributes[] = $this->attributeToHtml($key, $value);
			}
			$newAttributes = implode(' ', $newAttributes);

			try
			{
				if ($captcha = JCaptcha::getInstance($captcha, array('namespace' => 'captcha-' . $componentId)))
				{
					$output_tmp = $captcha->display($this->getName(), 'captcha-' . $componentId, $attr['class']);

					// The display function allows only class attribute definition, so we will use this small workaround for the other attributes
					if (strlen(trim($newAttributes)) > 0)
					{
						$output_tmp = str_replace('<div', '<div '.$newAttributes, $output_tmp);
					}

					return $output_tmp;
				}
			}
			catch (Exception $e)
			{
				JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');
			}
		}
	}

	public function processValidation($validationType = 'form', $submissionId = 0)
	{
		// Skip directory editing since it makes no sense
		if ($validationType == 'directory')
		{
			return true;
		}

		$formId 	= $this->formId;
		$form       = RSFormProHelper::getForm($formId);
		$logged		= $form->RemoveCaptchaLogged ? JFactory::getUser()->id : false;

		if (!$logged)
		{
			$captcha 	 = $this->getCaptcha();
			$componentId = $this->componentId;
			$app		 = JFactory::getApplication();
			$post        = $app->input->post->get('form', array(), 'array');
			$codeField 	 = $this->name;
			$task	 	 = strtolower($app->input->get('task', ''));
			$option	     = strtolower($app->input->get('option', ''));
			$isAjax	  	 = $option == 'com_rsform' && $task == 'ajaxvalidate';

			// Ajax requests don't validate Captcha (we'll validate it when the form is actually submitted)
			if ($isAjax)
			{
				return true;
			}

			try
			{
				if ($captcha = JCaptcha::getInstance($captcha, array('namespace' => 'captcha-' . $componentId)))
				{
					if (!$captcha->checkAnswer(isset($post[$codeField]) ? $post[$codeField] : null))
					{
						return false;
					}
				}
			}
			catch (Exception $e)
			{
				$app->enqueueMessage($e->getMessage(), 'error');
				return false;
			}
		}

		return true;
	}
}