<?php
/**
 * @package       RSform!Pro
 * @copyright (C) 2007-2020 www.rsjoomla.com
 * @license       GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die('Restricted access');

JText::script('RSFP_MAILCHIMP_INTEREST_GROUP_DESC');
JText::script('RSFP_MAILCHIMP_TAGS_AVAILABLE_DESC');
?>
<div id="mailchimpdiv">
	<script type="text/javascript">
		function rsfp_changeMcList(what) {
			var value = jQuery(what).val(),
				params = {list_id: null},
				merge_vars = jQuery('#merge_vars'),
				interest_groups = jQuery('#interest_groups'),
				merge_vars_url = 'index.php?option=com_rsform&task=plugin&plugin_task=get_merge_vars',
				interest_groups_url = 'index.php?option=com_rsform&task=plugin&plugin_task=get_interest_groups',
				tags_url = 'index.php?option=com_rsform&task=plugin&plugin_task=get_tags';

			stateLoading();
			params.list_id = value;

			jQuery.ajax({
				type    : "POST",
				url     : merge_vars_url,
				data    : params,
				success : function (response) {
					stateDone();
					merge_vars.find("tr:gt(0)").remove();
					if (response) {
						jQuery.each(response, function () {
							if (this.type == 'address') {
								var that = this;
								jQuery.each(this.address_fields, function(field, f_tag) {
									var extra = '';
									if (typeof f_tag == 'object') {
										extra = f_tag.extra;
										f_tag = f_tag.label;
									}
									merge_vars.append('<tr><td nowrap="nowrap" align="right">(' + that.tag + ') ' + that.name + ' ' + f_tag + (that.required ? ' (*)' : '') +'</td>' +
										'<td><input id="' + that.tag + '_'+ field +'" name="merge_vars[' + that.tag + '][' + field + ']" type="text" data-delimiter=" " data-filter-type="include" data-filter="value,path,localpath,text,global" data-placeholders="display" size="100" maxlength="64" /></td>' +
										'</tr>');

									if (extra != '') {
										merge_vars.append('<tr><td colspan="2"><pre>'+ extra +'</pre></td></tr>');
									}
								});
							} else {
								merge_vars.append('<tr><td>(' + this.tag + ') ' + this.name + (this.required ? ' (*)' : '') +'</td><td><input id="' + this.tag + '" name="merge_vars[' + this.tag + ']" type="text" data-delimiter=" " data-filter-type="include" data-filter="value,path,localpath,text,global" data-placeholders="display" size="100" maxlength="64" /></td></tr>');

								if (typeof this.extra != 'undefined') {
									merge_vars.append('<tr><td colspan="2"><pre>'+ this.extra +'</pre></td></tr>');
								}
							}
						});
					}

					merge_vars.find('[data-placeholders]:not(#EMAIL)').rsplaceholder();
				},
				dataType: 'json'
			});

			jQuery.ajax({
				type    : "POST",
				url     : interest_groups_url,
				data    : params,
				success : function (response) {
					stateDone();
					interest_groups.find("tr").remove();
					if (response) {
						jQuery.each(response, function () {
							interest_groups.append('<tr><td>' + this.title + '</td><td><select name="interest_groups[' + this.title + ']">' +
								<?php foreach ($fields_array as $field) { ?>
								'<option value="<?php echo $field ?>"><?php echo $field ?></option>' +
								<?php } ?>
								'</select></td></tr>');

							var replace = [];
							jQuery.each(this.subgroups, function () {
								var $val = this.id + '|' + this.title;
								replace.push($val);
							});

							interest_groups.append('<tr><td colspan="2">' + Joomla.JText._('RSFP_MAILCHIMP_INTEREST_GROUP_DESC').replace('%s', replace.join("\n")) + '</td></tr>');
						});
					}
				},
				dataType: 'json'
			});

			jQuery.ajax({
				type    : "POST",
				url     : tags_url,
				data    : params,
				success : function (response) {
					stateDone();
					var suggestions = jQuery('#mc_tags_suggestions');
					suggestions.empty();
					if (response) {
						var available_tags = []
						jQuery.each(response, function (index, tag) {
							available_tags.push(tag);
						});

						suggestions.parent().css('display', 'table-row');
						suggestions.append(Joomla.JText._('RSFP_MAILCHIMP_TAGS_AVAILABLE_DESC').replace('%s', available_tags.join("\n")));
					} else {
						suggestions.parent().css('display', 'none');
					}

					// clear the tags when the list is changed
					jQuery('#mc_tags').val('');
				},
				dataType: 'json'
			});
		}

		function rsfp_changeMcEmailType(what) {
			jQuery('#mc_email_type_field').prop('disabled', what.value !== 'user');
		}

		function rsfp_changeMcAction(what) {
			jQuery('#mc_action_field').prop('disabled', what.value != 2);
		}

		function rsfp_toggleTagsOptions(status){
			status = parseInt(status);
			if (status) {
				jQuery('#rsf_tag_option').show();
			} else {
				jQuery('#rsf_tag_option').hide();
			}
		}
	</script>
	<style>
		#merge_vars input,
		#mc_tags {
			margin-bottom : 0;
		}
	</style>
	<table class="admintable">
		<tr>
			<td valign="top" align="left" width="30%">
				<table class="table table-bordered">
					<tr>
						<td colspan="2" class="center"><?php echo JHtml::image('administrator/components/com_rsform/assets/images/mailchimp.png', 'Mailchimp'); ?></td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="alert alert-info"><?php echo JText::_('RSFP_MAILCHIMP_DESC'); ?></div>
						</td>
					</tr>
					<tr>
						<td width="80" align="right" nowrap="nowrap" class="key"><?php echo JText::_('RSFP_MAILCHIMP_USE_INTEGRATION'); ?></td>
						<td><?php echo $lists['published']; ?></td>
					</tr>
					<tr>
						<td width="80" align="right" nowrap="nowrap" class="key">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_ACTION_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_ACTION'); ?></span>
						</td>
						<td nowrap="nowrap"><?php echo $lists['mc_action']; ?><?php echo $lists['mc_action_field']; ?></td>
					</tr>
					<tr>
						<td colspan="2"><?php echo JText::_('RSFP_MAILCHIMP_ACTION_WARNING'); ?></td>
					</tr>
					<tr>
						<td width="80" align="right" nowrap="nowrap" class="key"><?php echo JText::_('RSFP_MAILCHIMP_LIST_ID'); ?></td>
						<td nowrap="nowrap"><?php echo $lists['mc_list_id']; ?></td>
					</tr>
					<tr>
						<td width="80" align="right" nowrap="nowrap" class="key">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_EMAIL_TYPE_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_EMAIL_TYPE'); ?></span>
						</td>
						<td nowrap="nowrap"><?php echo $lists['mc_email_type']; ?><?php echo $lists['mc_email_type_field']; ?></td>
					</tr>
					<tr>
						<td colspan="2"><?php echo JText::_('RSFP_MAILCHIMP_EMAIL_TYPE_WARNING'); ?></td>
					</tr>
				</table>
				
				<h3 class="rsfp-legend"><?php echo JText::_('RSFP_MAILCHIMP_SUBSCRIBE_OPTIONS'); ?></h3>
				<table class="admintable">
					<tr>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_DOUBLE_OPTIN_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_DOUBLE_OPTIN'); ?></span>
						</td>
						<td><?php echo $lists['mc_double_optin']; ?></td>
					</tr>
					<tr>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_TRIGGER_TAGS_AUTOMATION_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_TRIGGER_TAGS_AUTOMATION'); ?></span>
						</td>
						<td><?php echo $lists['mc_trigger_tags_automation']; ?></td>
					</tr>
					<tr>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_UPDATE_EXISTING_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_UPDATE_EXISTING'); ?></span>
						</td>
						<td><?php echo $lists['mc_update_existing']; ?></td>
					</tr>
					<tr id="rsf_tag_option"<?php echo ($row->mc_update_existing ? '' : ' style="display:none"'); ?>>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_APPEND_TAGS_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_APPEND_TAGS'); ?></span>
						</td>
						<td><?php echo $lists['mc_append_tags']; ?></td>
					</tr>
					<tr>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_REPLACE_INTERESTS_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_REPLACE_INTERESTS'); ?></span>
						</td>
						<td><?php echo $lists['mc_replace_interests']; ?></td>
					</tr>
				</table>
				
				<h3 class="rsfp-legend"><?php echo JText::_('RSFP_MAILCHIMP_UNSUBSCRIBE_OPTIONS'); ?></h3>
				<table class="admintable">
					<tr>
						<td width="200" nowrap="nowrap">
							<span class="hasTooltip" title="<?php echo JText::_('RSFP_MAILCHIMP_DELETE_MEMBER_DESC'); ?>"><?php echo JText::_('RSFP_MAILCHIMP_DELETE_MEMBER'); ?></span>
						</td>
						<td><?php echo $lists['mc_delete_member']; ?></td>
					</tr>
				</table>
				
				<h3 class="rsfp-legend"><?php echo JText::_('RSFP_MAILCHIMP_MERGE_VARS'); ?></h3>
				<table class="table table-bordered">
					<tr>
						<td colspan="2"><?php echo JText::_('RSFP_MAILCHIMP_MERGE_VARS_DESC'); ?></td>
					</tr>
					<tbody id="merge_vars">
					<tr>
						<td nowrap="nowrap" align="right">(EMAIL) Email (*)</td>
						<td><input id="EMAIL" data-delimiter=" " data-filter-type="include" data-filter="value,path,localpath,text,global" data-placeholders="display" size="100" maxlength="64" name="merge_vars[EMAIL]" value="<?php echo isset($row->mc_merge_vars['EMAIL']) ? $row->mc_merge_vars['EMAIL'] : null;?>" type="text"></td>
					</tr>
					<?php
					if (is_array($merge_vars))
					{
						foreach ($merge_vars as $merge_var)
						{
							if (is_array($lists['fields'][$merge_var->tag]['field'])) {
								foreach($lists['fields'][$merge_var->tag]['field'] as $field_name => $field) {
									?>
									<tr>
										<td nowrap="nowrap" align="right">(<?php echo $merge_var->tag; ?>) <?php echo $merge_var->name. ' '. JText::_('RSFP_MAILCHIMP_VARS_ARRAY_'.(strtoupper($field_name))) . ($merge_var->required ? ' (*)' : ''); ?></td>
										<td><?php echo $field['field']; ?></td>
									</tr>
									<?php
									if (isset($field['extra'])) {
										?>
										<tr>
											<td colspan="2"><pre><?php echo $field['extra']; ?></pre></td>
										</tr>
										<?php
									}
								}
							} else {
								?>
								<tr>
									<td nowrap="nowrap" align="right">(<?php echo $merge_var->tag; ?>) <?php echo $merge_var->name . ($merge_var->required ? ' (*)' : ''); ?></td>
									<td><?php echo $lists['fields'][$merge_var->tag]['field']; ?></td>
								</tr>
								<?php
								if (isset($lists['fields'][$merge_var->tag]['extra'])) {
									?>
									<tr>
										<td colspan="2"><pre><?php echo $lists['fields'][$merge_var->tag]['extra']; ?></pre></td>
									</tr>
									<?php
								}
							}
						}
					}
					?>
					</tbody>
				</table>
				<h3 class="rsfp-legend"><?php echo JText::_('RSFP_MAILCHIMP_INTERESTS'); ?></h3>
				<table class="table table-bordered">
					<tr>
						<td colspan="2"><?php echo JText::_('RSFP_MAILCHIMP_INTERESTS_DESC'); ?></td>
					</tr>
					<tbody id="interest_groups">
					<?php
					if (is_array($interest_groups))
					{
						foreach ($interest_groups as $interest_group)
						{
							?>
							<tr>
								<td nowrap="nowrap" align="right"><?php echo $interest_group->title; ?></td>
								<td><?php echo $lists['fields_groups'][$interest_group->id]; ?></td>
							</tr>
							<tr>
								<td colspan="2"><?php echo JText::sprintf('RSFP_MAILCHIMP_INTEREST_GROUP_DESC', $lists['field_groups_desc'][$interest_group->id]); ?><?php echo $lists['cached_values'][$interest_group->id]; ?></td>
							</tr>
							<?php
						}
					}
					?>
					</tbody>
				</table>

				<h3 class="rsfp-legend"><?php echo JText::_('RSFP_MAILCHIMP_TAGS'); ?></h3>
				<table class="table table-bordered">
					<tr>
						<td colspan="2"><?php echo JText::_('RSFP_MAILCHIMP_TAGS_DESC'); ?></td>
					</tr>
					<tbody id="interest_groups">

							<tr>
								<td colspan="2" style="text-align: center"><?php echo $lists['mc_tags']; ?></td>
							</tr>
							<tr<?php echo (!strlen($lists['mc_tags_desc']) ? ' style="display:none"' : '');?>>
								<td colspan="2" id="mc_tags_suggestions"><?php echo JText::sprintf('RSFP_MAILCHIMP_TAGS_AVAILABLE_DESC', $lists['mc_tags_desc']); ?></td>
							</tr>

					</tbody>
				</table>
			</td>
			<td valign="top">
				&nbsp;
			</td>
		</tr>
	</table>
</div>