<?php
/**
* @package RSform!Pro
* @copyright (C) 2007-2020 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

defined('_JEXEC') or die('Restricted access');

/**
 * Class TableRSForm_MailChimp
 */
class TableRSForm_MailChimp extends JTable
{
	/**
	 * Primary Key
	 *
	 * @public int
	 */
	public $form_id = null;
	/**
	 * @public string
	 */
	public $mc_list_id = '';
	/**
	 * @public int
	 */
	public $mc_action = 1;
	/**
	 * @public string
	 */
	public $mc_action_field = '';
	/**
	 * @public string
	 */
	public $mc_merge_vars = '';
	/**
	 * @public string
	 */
	public $mc_cached_values = '';
	/**
	 * @public string
	 */
	public $mc_interest_groups = '';
	/**
	 * @public string
	 */
	public $mc_tags = '';
	/**
	 * @public string
	 */
	public $mc_append_tags = 0;
	/**
	 * @public string
	 */
	public $mc_trigger_tags_automation = 1;
	/**
	 * @public string
	 */
	public $mc_email_type = 'html';
	/**
	 * @public string
	 */
	public $mc_email_type_field = '';
	/**
	 * @public int
	 */
	public $mc_double_optin = 1;
	/**
	 * @public int
	 */
	public $mc_update_existing = 0;
	/**
	 * @public int
	 */
	public $mc_replace_interests = 1;
	/**
	 * @public int
	 */
	public $mc_delete_member = 0;

	/**
	 * @public int
	 */
	public $mc_published = 0;

	/**
	 * TableRSForm_MailChimp constructor.
	 *
	 * @param $db
	 */
	public function __construct(& $db)
	{
		parent::__construct('#__rsform_mailchimp', 'form_id', $db);
	}

	public function check()
	{
		if (is_array($this->mc_merge_vars))
		{
			$this->mc_merge_vars = serialize($this->mc_merge_vars);
		}
		if (is_array($this->mc_interest_groups))
		{
			$this->mc_interest_groups = serialize($this->mc_interest_groups);
		}
		if (is_array($this->mc_cached_values))
		{
			$this->mc_cached_values = serialize($this->mc_cached_values);
		}
		if (strlen($this->mc_tags))
		{
			$tags = explode(',', $this->mc_tags);
			$tags = array_filter(array_map('trim', $tags));

			if ($tags)
			{
				$this->mc_tags = implode(',', $tags);
			}
			else
			{
				$this->mc_tags = '';
			}
		}

		return true;
	}

	public function hasPrimaryKey()
	{
		$db 	= $this->getDbo();
		$key 	= $this->getKeyName();
		$table	= $this->getTableName();

		$query = $db->getQuery(true)
			->select($db->qn($key))
			->from($db->qn($table))
			->where($db->qn($key) . ' = ' . $db->q($this->{$key}));

		return $db->setQuery($query)->loadResult() !== null;
	}
}