<?php
/**
 *	@package		Sendinblue
 *	@subpackage		apikey.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Apikey Controller
 */
class SendinblueControllerApikey extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
	}

	public function dashboard()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue', false));
		return;
	}

	public function saveApikey() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
			
		$app   = \JFactory::getApplication();
		$jinput = $app->input;
		$data['id']  = trim($jinput->get('id', '', 'INT'));
		$data['apikey']  = trim($jinput->get('apikey', '', 'STRING'));
	
		if ($data['apikey'] == '') {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_API_KEY_CAN_NOT_BE_EMPTY'), 'error');
			$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=apikey', false));
			return;
		} else {
			JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_sendinblue/models', 'SendinblueModel');
			$model = JModelLegacy::getInstance('Setting', 'SendinblueModel');
			if ($data['id'] == '') { // new record	
				$data['title'] = date("Y-m-d H:i:s");
			}
			$result = $model->save($data);
			if ($result == true) {
				$app->enqueueMessage(JText::_('COM_SENDINBLUE_API_KEY_SUCCESSFULLY_SAVED'));
			} else {
				$app->enqueueMessage(JText::_('COM_SENDINBLUE_ERROR_IN_SAVING_API_KEY'), 'error');
				
			}
		}	 
	
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue', false));
		return;
	
	}

}
