<?php
/**
 *	@package		Sendinblue
 *	@subpackage		attributes.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Attributes Controller
 */
class SendinblueControllerAttributes extends JControllerAdmin
{
	/**
	 * The prefix to use with controller messages.
	 *
	 * @var    string
	 * @since  1.6
	 */
	protected $text_prefix = 'COM_SENDINBLUE_ATTRIBUTES';

	/**
	 * Method to get a model object, loading it if required.
	 *
	 * @param   string  $name    The model name. Optional.
	 * @param   string  $prefix  The class prefix. Optional.
	 * @param   array   $config  Configuration array for model. Optional.
	 *
	 * @return  JModelLegacy  The model.
	 *
	 * @since   1.6
	 */
	public function getModel($name = 'Attribute', $prefix = 'SendinblueModel', $config = array('ignore_request' => true))
	{
		return parent::getModel($name, $prefix, $config);
	}

	function importAttribs() {
			
		// conect to SIB and get data
		//JLoader::register('SibJapi', JPATH_COMPONENT_ADMINISTRATOR . '/helpers/sibjapi.php'); 
		$this->sibapi = new SibJapi;
		if ($this->sibapi->data !== false) {
			$this->accountDetails = $this->sibapi->getAccount();
			if ($this->accountDetails === false) {
				foreach ($this->sibapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
			} else {
				$attrResponse = $this->sibapi->getDataAll('contacts/attributes', true);
				// asort($attrs, SORT_NATURAL | SORT_FLAG_CASE);
				
				if ($attrResponse !== false) {

					$db = JFactory::getDbo();
					JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR . '/tables');

					$i = 1;	
					foreach ($attrResponse as $item) {
						$row = JTable::getInstance('Attribute', 'SendinblueTable', array());
						$row->attribname = $item->name;
						$row->attribcategoryid = $item->category;
						$row->attribtypeid = $item->type;
						$row->attribcalculatedvalue = $item->calculatedValue;
						$row->attribenumerationsubform = json_encode($item->enumeration);
						$row->published = true;
						$row->created_by = JFactory::getUser()->id;
						$row->created = date($db->getDateFormat());
						$row->ordering = $i;
						if (!$row->store()) {
							// log
						}
						$i++;
					}
				}
				
			}
		}
		
	}

}
