<?php
/**
 *	@package		Sendinblue
 *	@subpackage		exportcontacts.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Exportcontacts Controller
 */
class SendinblueControllerExportcontacts extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
	}

	public function dashboard()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue', false));
		return;
	}

	public function startExportcontacts() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$app = JFactory::getApplication();

		$model = $this->getModel('exportcontacts');
		$data  = $this->input->post->get('jform', array(), 'array');

		if ($data['usersall'] == '0' && !isset($data['usergroups']) && $data['contactsall'] == '0' && !isset($data['contactcategories'])) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_EXPORTCONTACTS_ERROR_NOTHING_SELECTED'), 'error');
			$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=exportcontacts', false) );
			return false;
		}
		
		$result = $model->export($data, 'users');
		$result = $model->export($data, 'contacts');
		
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=exportcontacts', false) );
				
	}
	

	public function createTestUsers() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		for ($i=1; $i < 4 ; $i++) {

		    $realname = 'TestUserFN LN' . date('n-s') . '_' . $i;  
		    $username = 'TestUserUN_' . date('n-s') . '_' . $i;
		    $password = 'TestUserPW_' . date('n-s') . '_' . $i;
		    $email = 'TestUserEM_' . date('n-s') . '_' . $i . '@testing.moc';
			if ($i == 2 ) { $block = 1; } else  { $block = 0; }
			 
			$udata = array(
			    "name"=>$realname,
			    "username"=>$username,
			    "password"=>$password,
			    "password2"=>$password,
			    "email"=>$email,
			    "block"=>$block
			);
			
			$user = new JUser;
           
			if(!$user->bind($udata)) {
			    throw new Exception("Could not bind data. Error: " . $user->getError());
			}
			if (!$user->save()) {
			     throw new Exception("Could not save user. Error: " . $user->getError());
			}
			$new_user_id[] = $user->id;
			
		}
		$app = JFactory::getApplication();
		foreach ($new_user_id as $item) {
			$app->enqueueMessage('Created user id: ' . $item);
		}
	
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=exportcontacts', false) );

	}

	
	public function createTestContacts() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
	
		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_contact/tables');
		
		for ($i=1; $i < 4 ; $i++) {
			$cd = JTable::getInstance('Contact', 'ContactTable');

		    $realname = 'TestContactFN LN' . date('n-s') . '_' . $i;  
		    $telephone = 'TestContactTP_' . date('n-s') . '_' . $i;
		    $catid = 4;
		    $email = 'TestContactEM_' . date('n-s') . '_' . $i . '@testing.moc';
			if ($i == 2 ) { $pub = 0; } else  { $pub = 1; }
			 
			$udata = array(
			    "name"=>$realname,
			    "telephone"=>$telephone,
			    "catid" => 4,
			    "email_to"=>$email,
			    "published" => $pub
			);
						
			if(!$cd->bind($udata)) {
			    throw new Exception("Could not bind data. Error: " . $cd->getError());
			}
			if (!$cd->save($udata)) {
			     throw new Exception("Could not save contact. Error: " . $cd->getError());
			}
			$new_user_id[] = $cd->id;
			
			unset($cd);
		
		}
		$app = JFactory::getApplication();
		foreach ($new_user_id as $item) {
			$app->enqueueMessage('Created contact id: ' . $item);
		}
		
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=exportcontacts', false) );
	
	}

}
