<?php
/**
 *	@package		Sendinblue
 *	@subpackage		marketingautomation.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Marketingautomation Controller
 */
class SendinblueControllerMarketingautomation extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
	}

	public function dashboard()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue', false));
		return;
	}

	public function setTrackingID() {
		$app = JFactory::getApplication();
		if (SibJapiHelper::setPluginTrackingID('system', 'sendinbluema')) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_TRACKID_SET_SUCCESS'));
		} else {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_TRACKID_SET_ERROR'), 'error');
		}
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=marketingautomation', false));
		return;
	}
	public function pluginEnable() {
		$app = JFactory::getApplication();
		if (SibJapiHelper::setPluginState('system', 'sendinbluema', 1)) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_ENABLED_SUCCESS'));
		} else {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_ENABLED_ERROR'), 'error'); 
		}
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=marketingautomation', false));
		return;
	}
	public function pluginDisable() {
		$app = JFactory::getApplication();
		if (SibJapiHelper::setPluginState('system', 'sendinbluema', 0)) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_DISABLED_SUCCESS'));
		} else {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_MA_PLUGIN_DISABLED_ERROR'), 'error'); 
		}
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=marketingautomation', false));
		return;
	}

}
