<?php
/**
 *	@package		Sendinblue
 *	@subpackage		smtpsettings.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Smtpsettings Controller
 */
class SendinblueControllerSmtpsettings extends JControllerLegacy
{
	public function __construct($config)
	{
		parent::__construct($config);
	}

	public function dashboard()
	{
		$this->setRedirect(JRoute::_('index.php?option=com_sendinblue', false));
		return;
	}

	public function saveSmtp() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		
		$this->setRedirect('index.php?option=com_sendinblue&view=smtpsettings');
		
		$app = \JFactory::getApplication();
		// get form data
		$jinput = $app->input;
		$formdata = $jinput->get('jform', array(), 'ARRAY'); 	
		$password = $formdata['smtppass'];
		if (strlen(trim($password)) < 3) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_INVALID_PASSWORD'), 'error');
			return;	
		}
		// get account data
		$this->sibjapi = new SibJapi(true, true);

		if ($this->sibjapi->settings === false) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_API_KEY_NOT_FOUND'), 'error');
		} else {
			if ($this->sibjapi->accountDetails === false) {
				foreach ($this->sibapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
			} else {
				$result = SibJapiHelper::setSMTPtoSendInBlue($this->sibjapi, $password);
				if ($result === true) {
					$app->enqueueMessage(JText::_('COM_SENDINBLUE_SUCCESFULLY_SET_SENDINBLUE_SMTP_SERVER_SETTINGS_TO_JOOMLA_EMAIL_SENDING_SETTINGS'));
				} else {
					$app->enqueueMessage(JText::_('COM_SENDINBLUE_ERROR_IN_SETTING_SENDINBLUE_SMTP_SERVER_SETTINGS_TO_JOOMLA_EMAIL_SENDING_SETTINGS'), 'error');
				}
			}
		}	

	}
	public function sendTestemail() {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$config = JFactory::getConfig();
		$app = JFactory::getApplication();
		
		// get form data
		$jinput = $app->input;
		$formdata = $jinput->get('jform', array(), 'ARRAY'); 	
		$testemail = $formdata['testemail'];
		if (trim($testemail) == '') { $testemail = $config->get('mailfrom'); }
		
		$subject = JText::_('COM_SENDINBLUE_THIS_IS_TEST_MESSAGE_FROM') . $config->get('sitename');
		$body = JText::_('COM_SENDINBLUE_THIS_IS_A_TEST_MAIL_SENT_USING_SENDINBLUE_SMTP_MAIL_SERVER_YOUR_EMAIL_SETTINGS_ARE_CORRECT');
			
		$from = array($config->get('mailfrom'), $config->get('fromname'));
		$to = $testemail;

		$mailer = JFactory::getMailer();
		$mailer->setSender($from);
		$mailer->addRecipient($to);
		$mailer->setSubject($subject);
		$mailer->setBody($body);

		$sent = $mailer->send();
		
		if ($sent === true) {
			$app->enqueueMessage(JText::_('COM_SENDINBLUE_TEST_EMAIL_MESSAGE_SUCCESFULLY_SENT'));
		} else {
			$msg = JText::_('COM_SENDINBLUE_THERE_IS_A_ERROR_IN_SENDING_TEST_MESSAGE_CHECK_YOUR_SMTP_PASSWORD_AND_CHECK_THAT_SERVER_PORT_FIVE_HUNDRED_AND_EIGHTY_SEVEN_IS_OPEN_FOR_COMMUNICATION');
			$app->enqueueMessage($msg, 'error');
		}
		$this->setRedirect('index.php?option=com_sendinblue&view=smtpsettings');
		
	}
	public function restoreSmtp() {
		$this->setRedirect('index.php?option=com_sendinblue&view=smtpsettings');
		
		$app = JFactory::getApplication();
		if (!($sibjapi = SibJapiHelper::getSibJapi())) {
			$msg = JText::_('COM_SENDINBLUE_UNABLE_TO_CONECT_TO_SENDINBLUE_SERVER_CHECK_YOUR_INTERNET_CONECTION');
			$app->enqueueMessage($msg, 'error');
			return;
		} else {
				if ($sibjapi->settings->smtpbackup == '') {
				$app->enqueueMessage(JText::_('COM_SENDINBLUE_THERE_IS_NOT_SMTP_BACKUP_DATA_TO_RESTORE'));
			} else {
				$dataObj = json_decode($sibjapi->settings->smtpbackup);
				$data = SibJapiHelper::fromObject($dataObj);
				if (SibJapiHelper::setJoomlaMailSettings($data)) {
					$db = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query = 'UPDATE #__sendinblue_setting SET smtpbackup = ""';
					$query .= ' WHERE id = ' . $sibjapi->settings->id;
					$db->setQuery($query);
					if (!($result = $db->query())) {
						$app->enqueueMessage(JText::_('COM_SENDINBLUE_ERROR_IN_RESTORING_SMTP_DATA_FROM_BACKUP_YOU_HAVE_TO_RESTORE_PREVIOUS_CONFIGURATION_MANUALLY_IN_JOOMLA_GLOBAL_SETTINGS'));
					} else { 
						$app->enqueueMessage(JText::_('COM_SENDINBLUE_SUCCESFULLY_RESTORED_SMTP_DATA_FROM_BACKUP'));
					}
				} else {
					$app->enqueueMessage(JText::_('COM_SENDINBLUE_ERROR_IN_RESTORING_SMTP_DATA_FROM_BACKUP_YOU_HAVE_TO_RESTORE_PREVIOUS_CONFIGURATION_MANUALLY_IN_JOOMLA_GLOBAL_SETTINGS'));
				}
				
			}
		}	
	}

}
