<?php
/**
 *	@package		Sendinblue
 *	@subpackage		exportcontacts.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Exportcontacts Model
 */
class SendinblueModelExportcontacts extends JModelItem
{
	/**
	 * Model context string.
	 *
	 * @var        string
	 */
	protected $_context = 'com_sendinblue.exportcontacts';

        /**
	 * Model user data.
	 *
	 * @var        strings
	 */
	protected $user;
	protected $userId;
	protected $guest;
	protected $groups;
	protected $levels;
	protected $app;
	protected $input;
	protected $uikitComp;

	/**
	 * @var object item
	 */
	protected $item;

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since   1.6
	 *
	 * @return void
	 */
	protected function populateState()
	{
		$this->app = JFactory::getApplication();
		$this->input = $this->app->input;
		// Get the item main id
		$id = $this->input->getInt('id', null);
		$this->setState('exportcontacts.id', $id);

		// Load the parameters.
		parent::populateState();
	}

	/**
	 * Method to get article data.
	 *
	 * @param   integer  $pk  The id of the article.
	 *
	 * @return  mixed  Menu item data object on success, false on failure.
	 */
	public function getItem($pk = null)
	{
		$this->user	= JFactory::getUser();
		// check if this user has permission to access item
		if (!$this->user->authorise('exportcontacts.access', 'com_sendinblue'))
		{
			$app = JFactory::getApplication();
			$app->enqueueMessage(JText::_('Not authorised!'), 'error');
			// redirect away if not a correct to cPanel/default view
			$app->redirect('index.php?option=com_sendinblue');
			return false;
		}
		$this->userId = $this->user->get('id');
		$this->guest = $this->user->get('guest');
		$this->groups = $this->user->get('groups');
		$this->authorisedGroups = $this->user->getAuthorisedGroups();
		$this->levels = $this->user->getAuthorisedViewLevels();
		$this->initSet = true;

		$pk = (!empty($pk)) ? $pk : (int) $this->getState('exportcontacts.id');
		
		if ($this->_item === null)
		{
			$this->_item = array();
		}

		if (!isset($this->_item[$pk]))
		{
			try
			{
				// Get a db connection.
				$db = JFactory::getDbo();

				// Create a new query object.
				$query = $db->getQuery(true);

				// Get data
// get DummyItem code
$query->select('1');

				// Reset the query using our newly populated query object.
				$db->setQuery($query);
				// Load the results as a stdClass object.
				$data = $db->loadObject();

				if (empty($data))
				{
					$app = JFactory::getApplication();
					// If no data is found redirect to default page and show warning.
					$app->enqueueMessage(JText::_('COM_SENDINBLUE_NOT_FOUND_OR_ACCESS_DENIED'), 'warning');
					$app->redirect('index.php?option=com_sendinblue');
					return false;
				}

				// set data object to item.
				$this->_item[$pk] = $data;
                        }
			catch (Exception $e)
			{
				if ($e->getCode() == 404)
				{
					// Need to go thru the error handler to allow Redirect to work.
					JError::raiseWaring(404, $e->getMessage());
				}
				else
				{
					$this->setError($e);
					$this->_item[$pk] = false;
				}
			}
		}

		return $this->_item[$pk];
	}

	public function export($data, $type) {
		$app = \JFactory::getApplication();
		// get users 
		$users = array();

		$doQuery = 1;
		if ($type == 'users') {
			$emailfield = 'email';
			$query = 'SELECT DISTINCT * FROM #__users AS u LEFT JOIN #__user_usergroup_map AS ugm ON u.id = ugm.user_id';
			if ($data['usersall'] == '0') {
				if (isset($data['usergroups'])) {
					$wheregp = 'ugm.group_id IN (' . implode(',', $data['usergroups']) . ')';
					if ($data['usersungrouped'] == '1') { $wheregp = '(' . $wheregp . ' OR ugm.group_id IS NULL)'; }
					$where[] = $wheregp; 
				} else {
					$doQuery = 0;
				}
			}
			if ($doQuery == 1) {
				if ($data['usersblocked'] == '0') { $where[] = 'u.block = 0'; }
				if (count($where)) { $query .= ' WHERE ' . implode(' AND ', $where); }
				$this->_db->setQuery($query);
				$users = $this->_db->loadObjectList();
			} 
		}
		if ($type == 'contacts') {
			$emailfield = 'email_to';
			$query = 'SELECT * FROM #__contact_details AS cd';
			if ($data['contactsall'] == '0') {
				if (isset($data['contactcategories'])) {
					$where[] = 'cd.catid IN (' . implode(',', $data['contactcategories']) . ')';
				} else {
					$doQuery = 0;
				}
			}
			if ($doQuery == 1) {
				if ($data['contactsunpublished'] == '0') { $where[] = 'cd.published = 1'; }
				if (count($where)) { $query .= ' WHERE ' . implode(' AND ', $where); }
				$this->_db->setQuery($query);
				$users = $this->_db->loadObjectList();
			} 
		}
		if (count($users) == 0) {
			$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_' . strtoupper($type) . '_SELECTED_NONE');
			$app->enqueueMessage($msg);
			return;			
		}

		$time_limit = (int) count($users)/2 + 120;
		set_time_limit($time_limit);

		$contacts = array();
		if ($sibjapi = SibJapiHelper::getSibJapi()) {
			$contactsResponse = $sibjapi->getDataAll('contacts');
			if ($contactsResponse === false) {
				$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_ERROR_CANNOTGETCONTACTS');
				$app->enqueueMessage($msg, 'error');
				return;			
			} else {
				foreach ($contactsResponse as $item) { $contacts[$item->email] = $item; }	
			}
		} else {
			$msg = JText::_('COM_SENDINBLUE_ERROR_UNABLE_TO_CONECT_TO_SERVER');
			$app->enqueueMessage($msg, 'error');
			return;
		}
		
		// get lists
		$listsResponse = $sibjapi->getDataAll('contacts/lists');
		if ($listsResponse === false) {
			$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_ERROR_CANNOTGETLISTS');
			$app->enqueueMessage($msg, 'error');
			return;			
		} else {
			foreach ($listsResponse as $item) { $listsAll[] = (int) $item->id; }
		}
		$lists = array();
		if ($data['listsall'] == '0') {
			if (isset($data['lists'])) {
				foreach ($data['lists'] as $item) { $lists[] = (int) $item; }
			}
		} else {
			$lists = $listsAll;
		}
		$listsDiff = array_diff($listsAll, $lists);
		foreach ($listsDiff as $item) { $listsDiffint[] = (int) $item; }

		// ready to send to Sendinblue
		foreach ($users as $item) {
			$nameparts = explode(' ', $item->name);
			$first = $nameparts[0];
			array_shift($nameparts);
			$last = implode(' ', $nameparts);
			$attribs = new stdClass();
			
			if (isset($data['firstname']) && $data['firstname'] != '') { $attribs->{$data['firstname']} = $first; }
			if (isset($data['lastname']) && $data['lastname'] != '') { $attribs->{$data['lastname']} = $last; }

			$cdata = new stdClass();
			$cdata->email = strtolower($item->{$emailfield}); 
			$cdata->attributes = $attribs;
			if (count($lists)) { $cdata->listIds = $lists; }

			if (isset($contacts[strtolower($item->email)])) { // update contact

				//$data->emailBlacklisted = false; // stay as it is
				if ($data['exportmode'] == 'reassign') {
					if (count($listsDiffint)) { $cdata->unlinkListIds = $listsDiffint; }
				}
				
				$response = $sibjapi->updateContact($cdata);
				if ($response === false) {
					$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_ERROR_UPDATE') . $cdata->email;
					foreach ($sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
					$app->enqueueMessage($msg, 'error');
					$sibjapi->errors = array(); // reset in case of loops
				} else {
					$users_update_ids[] = $contacts[strtolower($item->email)]->id;
				}
							
			} else { // add contact
				
				$cdata->emailBlacklisted = false;
				
				$response = $sibjapi->createContact($cdata);
				if ($response === false) {
					$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_ERROR_CREATE') . $cdata->email . " >> ";
					foreach ($sibjapi->errors as $key => $value) { $msg .= '; ' . $value; }
					$app->enqueueMessage($msg, 'error');
					$sibjapi->errors = array(); // reset in case of loops
				} else {
					$users_add_ids[] = $response->data->id;
				}
			}
		}

		$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_' . strtoupper($type) . '_SELECTED') . count($users);
		$app->enqueueMessage($msg);
		if (count($users_add_ids)) {
			$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_' . strtoupper($type) . '_CREATED') . count($users_add_ids);
			$app->enqueueMessage($msg);
		}
		if (count($users_update_ids)) {
			$msg = JText::_('COM_SENDINBLUE_EXPORTCONTACTS_' . strtoupper($type) . '_UPDATED') . count($users_update_ids);
			$app->enqueueMessage($msg);
		}
		
	}

}
