<?php
/**
 *	@package		Sendinblue
 *	@subpackage		blockattribcategoryattriblist.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Blockattribcategoryattriblist Form Field class for the Sendinblue component
 */
class JFormFieldBlockattribcategoryattriblist extends JFormFieldList
{
	/**
	 * The blockattribcategoryattriblist field type.
	 *
	 * @var		string
	 */
	public $type = 'blockattribcategoryattriblist';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		$db = JFactory::getDBO();
$query = $db->getQuery(true);
$query->select($db->quoteName(array('a.attribname','a.attribname'),array('id','blockattribcategoryattribid_attribname')));
$query->from($db->quoteName('#__sendinblue_attribute', 'a'));
$query->where($db->quoteName('a.published') . ' = 1');
$query->where($db->quoteName('a.attribcategoryid') . ' = "category"');
$query->where($db->quoteName('a.attribname') . ' <> "DOUBLE_OPT-IN"');
$query->order('a.attribname ASC');
$db->setQuery((string)$query);
$items = $db->loadObjectList();
$options = array();
if ($items)
{
	$options[] = JHtml::_('select.option', '', 'Select an option');
	foreach($items as $item)
	{
		$options[] = JHtml::_('select.option', $item->id, $item->blockattribcategoryattribid_attribname);
	}
}

return $options;
	}
}
