<?php
/**
 *	@package		Sendinblue
 *	@subpackage		blockattribnormaltextattriblist.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Blockattribnormaltextattriblist Form Field class for the Sendinblue component
 */
class JFormFieldBlockattribnormaltextattriblist extends JFormFieldList
{
	/**
	 * The blockattribnormaltextattriblist field type.
	 *
	 * @var		string
	 */
	public $type = 'blockattribnormaltextattriblist';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
		$db = JFactory::getDBO();
$query = $db->getQuery(true);
$query->select($db->quoteName(array('a.attribname','a.attribname'),array('id','blockattribnormaltextattribid_attribname')));
$query->from($db->quoteName('#__sendinblue_attribute', 'a'));
$query->where($db->quoteName('a.published') . ' = 1');
$query->where($db->quoteName('a.attribcategoryid') . ' = "normal"');
$query->where($db->quoteName('a.attribtypeid') . ' = "text"');
$query->order('a.attribname ASC');
$db->setQuery((string)$query);
$items = $db->loadObjectList();
$options = array();
if ($items)
{
	$options[] = JHtml::_('select.option', '', 'Select an option');
	foreach($items as $item)
	{
		$options[] = JHtml::_('select.option', $item->id, $item->blockattribnormaltextattribid_attribname);
	}
}

return $options;
	}
}
