<?php
/**
 *	@package		Sendinblue
 *	@subpackage		sibtemplates.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the list field type
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');

/**
 * Sibtemplates Form Field class for the Sendinblue component
 */
class JFormFieldSibtemplates extends JFormFieldList
{
	/**
	 * The sibtemplates field type.
	 *
	 * @var		string
	 */
	public $type = 'sibtemplates';

	/**
	 * Method to get a list of options for a list input.
	 *
	 * @return	array    An array of JHtml options.
	 */
	protected function getOptions()
	{
				$items = SibJapiHelper::getTemplatesSelectData();
		if (count($items)) {
			// $options[] = JHtml::_('select.option', '', 'Select an option');
			foreach($items as $key => $value) { $options[] = JHtml::_('select.option', $key, $value); }
		}		
		return $options;		


	}
}
