/**
 *	@package		Sendinblue
 *	@subpackage		subscription_data.js
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */





function blocktypeupdated(cntrl) {
    var updateName1 = "blockattribcategoryid";
    var updateName2 = "blockattribtypeid";
    var updateid1val = "";
    var updateid2val = "";
    
    switch (cntrl.value) {
        case "editor":
            updateid1val = "";
            updateid2val = "";
            break;
        case "attribglobal":
            updateid1val = "global";
            updateid2val = "float";
            break;
        case "attribnormaltext":
            updateid1val = "normal";
            updateid2val = "text";
            break;
        case "attribnormalnumber":
            updateid1val = "normal";
            updateid2val = "float";
            break;
        case "attribnormaldate":
            updateid1val = "normal";
            updateid2val = "date";
            break;
        case "attribnormalbool":
            updateid1val = "normal";
            updateid2val = "boolean";
            break;
        case "attribcategory":
            updateid1val = "category";
            updateid2val = "";
            break;
        case "divider":
            updateid1val = "";
            updateid2val = "";
            break;
        case "optin":
            updateid1val = "category";
            updateid2val = "";
            break;
        case "captcha":
            updateid1val = "";
            updateid2val = "";
            break;
        default:
    }

    var group = $(cntrl).closest(".subform-repeatable-group");
    var subformName = group.dataset.baseName;
    var i = group.dataset.group.slice(group.dataset.baseName.length);
    var updateid1 = "jform_"+subformName+"__"+subformName+i+"__"+updateName1;
    var updateid2 = "jform_"+subformName+"__"+subformName+i+"__"+updateName2;

    // console.log(jQuery("#"+updateid1).val());
    // console.log(jQuery("#"+updateid2).val());

    // update values
    jQuery("#"+updateid1).val(updateid1val).change();
    jQuery("#"+updateid2).val(updateid2val).change();
    // update controls
    jQuery("#"+updateid1).trigger('liszt:updated');
    jQuery("#"+updateid2).trigger('liszt:updated');

    // console.log(jQuery("#"+updateid1).val());
    // console.log(jQuery("#"+updateid2).val());

    // if (cntrl.value == "optin") {
        // var optinvalid = "#"+"jform_"+subformName+"__"+subformName+i+"__blockoptinattribid";
        // jQuery(optinvalid).prop('selectedIndex', 1); // 0 is empty
        // jQuery(optinvalid).change();
        // jQuery(optinvalid).trigger('liszt:updated');
        // jQuery(optinvalid).prop('disabled', true);
        // jQuery(optinvalid).change();
        // jQuery(optinvalid).trigger('liszt:updated');
    // }

} 
 
 
