<?php
/**
 *	@package		Sendinblue
 *	@subpackage		script.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHTML::_('behavior.modal');

/**
 * Script File of Sendinblue Component
 */
class com_sendinblueInstallerScript
{
	/**
	 * method to install the component
	 *
	 * @return void
	 */
	function install($parent)
	{

	}

	/**
	 * method to uninstall the component
	 *
	 * @return void
	 */
	function uninstall($parent)
	{
		// Get Application object
		$app = JFactory::getApplication();

		// Get The Database object
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);
		// Select id from content type table
		$query->select($db->quoteName('type_id'));
		$query->from($db->quoteName('#__content_types'));
		// Where Subscription_form alias is found
		$query->where( $db->quoteName('type_alias') . ' = '. $db->quote('com_sendinblue.subscription_form') );
		$db->setQuery($query);
		// Execute query to see if alias is found
		$db->execute();
		$subscription_form_found = $db->getNumRows();
		// Now check if there were any rows
		if ($subscription_form_found)
		{
			// Since there are load the needed  subscription_form type ids
			$subscription_form_ids = $db->loadColumn();
			// Remove Subscription_form from the content type table
			$subscription_form_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_sendinblue.subscription_form') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__content_types'));
			$query->where($subscription_form_condition);
			$db->setQuery($query);
			// Execute the query to remove Subscription_form items
			$subscription_form_done = $db->execute();
			if ($subscription_form_done)
			{
				// If succesfully remove Subscription_form add queued success message.
				$app->enqueueMessage(JText::_('The (com_sendinblue.subscription_form) type alias was removed from the <b>#__content_type</b> table'));
			}

			// Remove Subscription_form items from the contentitem tag map table
			$subscription_form_condition = array( $db->quoteName('type_alias') . ' = '. $db->quote('com_sendinblue.subscription_form') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__contentitem_tag_map'));
			$query->where($subscription_form_condition);
			$db->setQuery($query);
			// Execute the query to remove Subscription_form items
			$subscription_form_done = $db->execute();
			if ($subscription_form_done)
			{
				// If succesfully remove Subscription_form add queued success message.
				$app->enqueueMessage(JText::_('The (com_sendinblue.subscription_form) type alias was removed from the <b>#__contentitem_tag_map</b> table'));
			}

			// Remove Subscription_form items from the ucm content table
			$subscription_form_condition = array( $db->quoteName('core_type_alias') . ' = ' . $db->quote('com_sendinblue.subscription_form') );
			// Create a new query object.
			$query = $db->getQuery(true);
			$query->delete($db->quoteName('#__ucm_content'));
			$query->where($subscription_form_condition);
			$db->setQuery($query);
			// Execute the query to remove Subscription_form items
			$subscription_form_done = $db->execute();
			if ($subscription_form_done)
			{
				// If succesfully remove Subscription_form add queued success message.
				$app->enqueueMessage(JText::_('The (com_sendinblue.subscription_form) type alias was removed from the <b>#__ucm_content</b> table'));
			}

			// Make sure that all the Subscription_form items are cleared from DB
			foreach ($subscription_form_ids as $subscription_form_id)
			{
				// Remove Subscription_form items from the ucm base table
				$subscription_form_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $subscription_form_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_base'));
				$query->where($subscription_form_condition);
				$db->setQuery($query);
				// Execute the query to remove Subscription_form items
				$db->execute();

				// Remove Subscription_form items from the ucm history table
				$subscription_form_condition = array( $db->quoteName('ucm_type_id') . ' = ' . $subscription_form_id);
				// Create a new query object.
				$query = $db->getQuery(true);
				$query->delete($db->quoteName('#__ucm_history'));
				$query->where($subscription_form_condition);
				$db->setQuery($query);
				// Execute the query to remove Subscription_form items
				$db->execute();
			}
		}

		// If All related items was removed queued success message.
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_base</b> table'));
		$app->enqueueMessage(JText::_('All related items was removed from the <b>#__ucm_history</b> table'));

		// Remove sendinblue assets from the assets table
		$sendinblue_condition = array( $db->quoteName('name') . ' LIKE ' . $db->quote('com_sendinblue%') );

		// Create a new query object.
		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__assets'));
		$query->where($sendinblue_condition);
		$db->setQuery($query);
		$subscription_form_done = $db->execute();
		if ($subscription_form_done)
		{
			// If succesfully remove sendinblue add queued success message.
			$app->enqueueMessage(JText::_('All related items was removed from the <b>#__assets</b> table'));
		}

		// little notice as after service, in case of bad experience with component.
		echo '<h2>Did something go wrong? Are you disappointed?</h2>
		<p>Please let me know at <a href="mailto:branislav.gligorov@itsbg.eu">branislav.gligorov@itsbg.eu</a>.
		<br />We at Sendinblue are committed to building extensions that performs proficiently! You can help us, really!
		<br />Send me your thoughts on improvements that is needed, trust me, I will be very grateful!
		<br />Visit us at <a href="http://sendinblue.com" target="_blank">http://sendinblue.com</a> today!</p>';
	}

	/**
	 * method to update the component
	 *
	 * @return void
	 */
	function update($parent)
	{
		
	}

	/**
	 * method to run before an install/update/uninstall method
	 *
	 * @return void
	 */
	function preflight($type, $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// is redundant ...hmmm
		if ($type == 'uninstall')
		{
			return true;
		}
		// the default for both install and update
		$jversion = new JVersion();
		if (!$jversion->isCompatible('3.6.0'))
		{
			$app->enqueueMessage('Please upgrade to at least Joomla! 3.6.0 before continuing!', 'error');
			return false;
		}
		// do any updates needed
		if ($type == 'update')
		{
		}
		// do any install needed
		if ($type == 'install')
		{
		}
	}

	/**
	 * method to run after an install/update/uninstall method
	 *
	 * @return void
	 */
	function postflight($type, $parent)
	{
		// get application
		$app = JFactory::getApplication();
		// set the default component settings
		if ($type == 'install')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the subscription_form content type object.
			$subscription_form = new stdClass();
			$subscription_form->type_title = 'Sendinblue Subscription_form';
			$subscription_form->type_alias = 'com_sendinblue.subscription_form';
			$subscription_form->table = '{"special": {"dbtable": "#__sendinblue_subscription_form","key": "id","type": "Subscription_form","prefix": "sendinblueTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$subscription_form->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "title","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"title":"title","subsformmsgupdateerror":"subsformmsgupdateerror","subsformmsgcreateformsuccess":"subsformmsgcreateformsuccess","subsformmsgcreatesubscriptionsuccess":"subsformmsgcreatesubscriptionsuccess","subsformmsgcreateerror":"subsformmsgcreateerror","subsformmsgconfirmsubscriptionerrorlink":"subsformmsgconfirmsubscriptionerrorlink","subsformmsgconfirmsubscriptionsuccess":"subsformmsgconfirmsubscriptionsuccess","finalfollowuptmplid":"finalfollowuptmplid","followuptmplid":"followuptmplid","formredirectpagecustom":"formredirectpagecustom","finalconfirmation":"finalconfirmation","formredirectpage":"formredirectpage","optintmplid":"optintmplid","confirmationtype":"confirmationtype","subsformmsgupdatesubscriptionsuccess":"subsformmsgupdatesubscriptionsuccess","confirmationpage":"confirmationpage","subsformmsgupdateformsuccess":"subsformmsgupdateformsuccess","confirmationpagecustom":"confirmationpagecustom","subsformmsgconfirmsubscriptionerror":"subsformmsgconfirmsubscriptionerror","subsformmsgoptinerror":"subsformmsgoptinerror","siblists":"siblists"}}';
			$subscription_form->router = 'SendinblueHelperRoute::getSubscription_formRoute';
			$subscription_form->content_history_options = '{"formFile": "administrator/components/com_sendinblue/models/forms/subscription_form.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","finalfollowuptmplid","followuptmplid","finalconfirmation","formredirectpage","optintmplid","confirmationtype","confirmationpage"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "finalfollowuptmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "followuptmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "optintmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "siblists","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"}]}';

			// Set the object into the content types table.
			$subscription_form_Inserted = $db->insertObject('#__content_types', $subscription_form);


			// Install the global extenstion params.
			$query = $db->getQuery(true);
			// Field to update.
			$fields = array(
				$db->quoteName('params') . ' = ' . $db->quote('{"autorName":"Branislav Gligorov","autorEmail":"branislav.gligorov@itsbg.eu","baseurl":"https://api.sendinblue.com/v3/","connectiontimeout":"30","optintemplatelinktag":"{{ DOUBLEOPTIN }}","doubleoptinattributename":"DOUBLE_OPT-IN","optinlinkvalidityperiod":"60","doubleoptintempfolder":"FORM","doubleoptintemplist":"Temp - DOUBLE OPTIN","simulatesmtpnotactive":"0","simulatemanotactive":"0","save_history":"1","history_limit":"10"}'),
			);
			// Condition.
			$conditions = array(
				$db->quoteName('element') . ' = ' . $db->quote('com_sendinblue')
			);
			$query->update($db->quoteName('#__extensions'))->set($fields)->where($conditions);
			$db->setQuery($query);
			$allDone = $db->execute();

			echo '<a target="_blank" href="http://sendinblue.com" title="Sendinblue">
				<img src="components/com_sendinblue/assets/images/vdm-component.png"/>
				</a>';
		}
		// do any updates needed
		if ($type == 'update')
		{

			// Get The Database object
			$db = JFactory::getDbo();

			// Create the subscription_form content type object.
			$subscription_form = new stdClass();
			$subscription_form->type_title = 'Sendinblue Subscription_form';
			$subscription_form->type_alias = 'com_sendinblue.subscription_form';
			$subscription_form->table = '{"special": {"dbtable": "#__sendinblue_subscription_form","key": "id","type": "Subscription_form","prefix": "sendinblueTable","config": "array()"},"common": {"dbtable": "#__ucm_content","key": "ucm_id","type": "Corecontent","prefix": "JTable","config": "array()"}}';
			$subscription_form->field_mappings = '{"common": {"core_content_item_id": "id","core_title": "title","core_state": "published","core_alias": "null","core_created_time": "created","core_modified_time": "modified","core_body": "null","core_hits": "hits","core_publish_up": "null","core_publish_down": "null","core_access": "access","core_params": "params","core_featured": "null","core_metadata": "null","core_language": "null","core_images": "null","core_urls": "null","core_version": "version","core_ordering": "ordering","core_metakey": "null","core_metadesc": "null","core_catid": "null","core_xreference": "null","asset_id": "asset_id"},"special": {"title":"title","subsformmsgupdateerror":"subsformmsgupdateerror","subsformmsgcreateformsuccess":"subsformmsgcreateformsuccess","subsformmsgcreatesubscriptionsuccess":"subsformmsgcreatesubscriptionsuccess","subsformmsgcreateerror":"subsformmsgcreateerror","subsformmsgconfirmsubscriptionerrorlink":"subsformmsgconfirmsubscriptionerrorlink","subsformmsgconfirmsubscriptionsuccess":"subsformmsgconfirmsubscriptionsuccess","finalfollowuptmplid":"finalfollowuptmplid","followuptmplid":"followuptmplid","formredirectpagecustom":"formredirectpagecustom","finalconfirmation":"finalconfirmation","formredirectpage":"formredirectpage","optintmplid":"optintmplid","confirmationtype":"confirmationtype","subsformmsgupdatesubscriptionsuccess":"subsformmsgupdatesubscriptionsuccess","confirmationpage":"confirmationpage","subsformmsgupdateformsuccess":"subsformmsgupdateformsuccess","confirmationpagecustom":"confirmationpagecustom","subsformmsgconfirmsubscriptionerror":"subsformmsgconfirmsubscriptionerror","subsformmsgoptinerror":"subsformmsgoptinerror","siblists":"siblists"}}';
			$subscription_form->router = 'SendinblueHelperRoute::getSubscription_formRoute';
			$subscription_form->content_history_options = '{"formFile": "administrator/components/com_sendinblue/models/forms/subscription_form.xml","hideFields": ["asset_id","checked_out","checked_out_time","version"],"ignoreChanges": ["modified_by","modified","checked_out","checked_out_time","version","hits"],"convertToInt": ["published","ordering","finalfollowuptmplid","followuptmplid","finalconfirmation","formredirectpage","optintmplid","confirmationtype","confirmationpage"],"displayLookup": [{"sourceColumn": "created_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "access","targetTable": "#__viewlevels","targetColumn": "id","displayColumn": "title"},{"sourceColumn": "modified_by","targetTable": "#__users","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "finalfollowuptmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "followuptmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "optintmplid","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"},{"sourceColumn": "siblists","targetTable": "#__sendinblue_subject","targetColumn": "id","displayColumn": "name"}]}';

			// Check if subscription_form type is already in content_type DB.
			$subscription_form_id = null;
			$query = $db->getQuery(true);
			$query->select($db->quoteName(array('type_id')));
			$query->from($db->quoteName('#__content_types'));
			$query->where($db->quoteName('type_alias') . ' LIKE '. $db->quote($subscription_form->type_alias));
			$db->setQuery($query);
			$db->execute();

			// Set the object into the content types table.
			if ($db->getNumRows())
			{
				$subscription_form->type_id = $db->loadResult();
				$subscription_form_Updated = $db->updateObject('#__content_types', $subscription_form, 'type_id');
			}
			else
			{
				$subscription_form_Inserted = $db->insertObject('#__content_types', $subscription_form);
			}


			echo '<a target="_blank" href="http://sendinblue.com" title="Sendinblue">
				<img src="components/com_sendinblue/assets/images/vdm-component.png"/>
				</a>
				<h3>Upgrade to Version 1.0.9 Was Successful! Let us know if anything is not working as expected.</h3>';
		}
	}
}
