<?php
/**
 *	@package		Sendinblue
 *	@subpackage		sendinblue.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');
JHtml::_('behavior.tabstate');

// Access check.
if (!JFactory::getUser()->authorise('core.manage', 'com_sendinblue'))
{
	throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
};

// Add CSS file for all pages
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_sendinblue/assets/css/admin.css');
$document->addScript('components/com_sendinblue/assets/js/admin.js');

// require helper files
JLoader::register('SendinblueHelper', __DIR__ . '/helpers/sendinblue.php'); 
JLoader::register('JHtmlBatch_', __DIR__ . '/helpers/html/batch_.php'); 

// Triger the Global Admin Event
SendinblueHelper::globalEvent($document);

// Get an instance of the controller prefixed by Sendinblue
$controller = JControllerLegacy::getInstance('Sendinblue');

// Perform the Request task
$controller->execute(JFactory::getApplication()->input->get('task'));

// Redirect if set by the controller
$controller->redirect();
