CREATE TABLE IF NOT EXISTS `#__sendinblue_setting` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
	`apikey` CHAR(255) NOT NULL DEFAULT '',
	`postinstallmsgsent` DATETIME NOT NULL DEFAULT '0000-00-00',
	`smtpbackup` TEXT NOT NULL,
	`title` VARCHAR(190) NOT NULL DEFAULT '',
	`params` text NOT NULL DEFAULT '',
	`published` TINYINT(3) NOT NULL DEFAULT 1,
	`created_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`modified_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`checked_out` int(11) unsigned NOT NULL DEFAULT 0,
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`version` INT(10) unsigned NOT NULL DEFAULT 1,
	`hits` INT(10) unsigned NOT NULL DEFAULT 0,
	`access` INT(10) unsigned NOT NULL DEFAULT 0,
	`ordering` INT(11) NOT NULL DEFAULT 0,
	PRIMARY KEY  (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_checkout` (`checked_out`),
	KEY `idx_createdby` (`created_by`),
	KEY `idx_modifiedby` (`modified_by`),
	KEY `idx_state` (`published`),
	KEY `idx_title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__sendinblue_subscription_form` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
	`blocksubform` TEXT NOT NULL,
	`confirmationpage` TINYINT NULL DEFAULT 0,
	`confirmationpagecustom` VARCHAR(1024) NOT NULL DEFAULT '',
	`confirmationtype` TINYINT(1) NULL DEFAULT 0,
	`finalconfirmation` TINYINT NOT NULL DEFAULT 0,
	`finalfollowuptmplid` INT(1) NULL DEFAULT 0,
	`followuptmplid` INT(1) NULL DEFAULT 0,
	`formredirectpage` TINYINT NULL DEFAULT 0,
	`formredirectpagecustom` VARCHAR(1024) NOT NULL DEFAULT '',
	`optintmplid` INT(1) NULL DEFAULT 0,
	`siblists` VARCHAR(2048) NULL DEFAULT '',
	`subsformmsgconfirmsubscriptionerror` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgconfirmsubscriptionerrorlink` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgconfirmsubscriptionsuccess` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgcreateerror` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgcreateformsuccess` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgcreatesubscriptionsuccess` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgoptinerror` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgupdateerror` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgupdateformsuccess` VARCHAR(1024) NOT NULL DEFAULT '',
	`subsformmsgupdatesubscriptionsuccess` VARCHAR(1024) NOT NULL DEFAULT '',
	`title` VARCHAR(190) NOT NULL DEFAULT '',
	`params` text NOT NULL DEFAULT '',
	`published` TINYINT(3) NOT NULL DEFAULT 1,
	`created_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`modified_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`checked_out` int(11) unsigned NOT NULL DEFAULT 0,
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`version` INT(10) unsigned NOT NULL DEFAULT 1,
	`hits` INT(10) unsigned NOT NULL DEFAULT 0,
	`access` INT(10) unsigned NOT NULL DEFAULT 0,
	`ordering` INT(11) NOT NULL DEFAULT 0,
	PRIMARY KEY  (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_checkout` (`checked_out`),
	KEY `idx_createdby` (`created_by`),
	KEY `idx_modifiedby` (`modified_by`),
	KEY `idx_state` (`published`),
	KEY `idx_title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__sendinblue_subscription_data` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
	`confirmationtype` TINYINT(1) NULL DEFAULT 0,
	`email` VARCHAR(190) NOT NULL DEFAULT '',
	`subscriptionformid` INT NOT NULL DEFAULT 0,
	`token` TEXT NULL,
	`params` text NOT NULL DEFAULT '',
	`published` TINYINT(3) NOT NULL DEFAULT 1,
	`created_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`modified_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`checked_out` int(11) unsigned NOT NULL DEFAULT 0,
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`version` INT(10) unsigned NOT NULL DEFAULT 1,
	`hits` INT(10) unsigned NOT NULL DEFAULT 0,
	`access` INT(10) unsigned NOT NULL DEFAULT 0,
	`ordering` INT(11) NOT NULL DEFAULT 0,
	PRIMARY KEY  (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_checkout` (`checked_out`),
	KEY `idx_createdby` (`created_by`),
	KEY `idx_modifiedby` (`modified_by`),
	KEY `idx_state` (`published`),
	KEY `idx_email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `#__sendinblue_attribute` (
	`id` INT(11) NOT NULL AUTO_INCREMENT,
	`asset_id` INT(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
	`attribcalculatedvalue` VARCHAR(190) NULL DEFAULT '',
	`attribcategoryid` VARCHAR(190) NULL DEFAULT '',
	`attribenumerationsubform` TEXT NOT NULL,
	`attribname` VARCHAR(190) NULL DEFAULT '',
	`attribtypeid` VARCHAR(190) NULL DEFAULT '',
	`params` text NOT NULL DEFAULT '',
	`published` TINYINT(3) NOT NULL DEFAULT 1,
	`created_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`modified_by` INT(10) unsigned NOT NULL DEFAULT 0,
	`created` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`modified` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`checked_out` int(11) unsigned NOT NULL DEFAULT 0,
	`checked_out_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
	`version` INT(10) unsigned NOT NULL DEFAULT 1,
	`hits` INT(10) unsigned NOT NULL DEFAULT 0,
	`access` INT(10) unsigned NOT NULL DEFAULT 0,
	`ordering` INT(11) NOT NULL DEFAULT 0,
	PRIMARY KEY  (`id`),
	KEY `idx_access` (`access`),
	KEY `idx_checkout` (`checked_out`),
	KEY `idx_createdby` (`created_by`),
	KEY `idx_modifiedby` (`modified_by`),
	KEY `idx_state` (`published`),
	KEY `idx_attribname` (`attribname`),
	KEY `idx_attribcategoryid` (`attribcategoryid`),
	KEY `idx_attribtypeid` (`attribtypeid`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8mb4 DEFAULT COLLATE=utf8mb4_general_ci;



--
-- Always insure this column rules is large enough for all the access control values.
--
ALTER TABLE `#__assets` CHANGE `rules` `rules` MEDIUMTEXT NOT NULL COMMENT 'JSON encoded access control.';

--
-- Always insure this column name is large enough for long component and view names.
--
ALTER TABLE `#__assets` CHANGE `name` `name` VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.';
