<?php
/**
 *	@package		Sendinblue
 *	@subpackage		default.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// Add PHP (custom view script) * - head

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('apikey.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'apikey.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=apikey'.$urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">
        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
</form>
<?php if ($this->settings) {
	$id = $this->settings->id;
	$apikey = $this->settings->apikey;
} else {
	$id = '';
	$apikey = '';
} ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=apikey'.$urlId); ?>" method="post" name="adminForm" id="adminFormREPLACEMENT" class="form-validate" enctype="multipart/form-data">
	<div class="form-horizontal">
		<div class="row-fluid form-horizontal-desktop">
			<div class="span12">
        		<div class="introtext">
        			<p><?php echo JText::_('COM_SENDINBLUE_APIKEY_INTRO'); ?></p>
        			<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_APIKEY_INFO'); ?></p>
        		</div>
				<div class="control-group">
					<div class="control-label"><label id="jform_apikey-lbl" for="jform_apikey" class="hasPopover required" title="" data-content="API key used to conect to Sendinblue API" data-original-title="API key">
						API key<span class="star">&nbsp;*</span></label>
					</div>
					<div class="controls">
						<input name="apikey" id="apikey" value="<?php echo $apikey; ?>" class="text_area required" size="80" placeholder="xkeysib-..." maxlength="255" required="required" aria-required="true" autocomplete="off" type="text">
					</div>
				</div>     
				
				<input type="hidden" name="id" value="<?php echo $id; ?>" />
		        <input type="hidden" name="task" value="" />
		        <?php echo JHtml::_('form.token'); ?>
	       </div>
	    </div>
	</div>
</form>

<?php else: ?>
        <h1><?php echo JText::_('COM_SENDINBLUE_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

