<?php
/**
 *	@package		Sendinblue
 *	@subpackage		view.html.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access'); 

/**
 * Sendinblue View class for the Apikey
 */
class SendinblueViewApikey extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{
		// get component params
		$this->params = JComponentHelper::getParams('com_sendinblue');
		// get the application
		$this->app = JFactory::getApplication();
		// get the user object
		$this->user = JFactory::getUser();
		// get global action permissions
		$this->canDo = SendinblueHelper::getActions('apikey');
		// Initialise variables.
		$this->item = $this->get('Item');
		$this->settings = $this->get('Settings');
		// Add PHP (custom JViewLegacy display) 

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			// add the tool bar
			$this->addToolBar();
		}

		// set the document
		$this->setDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function setDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_ADMINISTRATOR.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new sendinblueHeaderCheck;
		// Add PHP (custom document script) 
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/administrator/components/com_sendinblue/assets/css/apikey.css', (SendinblueHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
		// Set the Custom JS script to view
		$this->document->addScriptDeclaration("
			jQuery( document ).ready(function($) {
				$('#adminForm').remove();
				$('#adminFormREPLACEMENT').attr('id', 'adminForm');
			});
			
		");
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		// hide the main menu
		$this->app->input->set('hidemainmenu', true);
		// set the title
		if (isset($this->item->name) && $this->item->name)
		{
			$title = $this->item->name;
		}
		// Check for empty title and add view name if param is set
		if (empty($title))
		{
			$title = JText::_('COM_SENDINBLUE_APIKEY');
		}
		// add title to the page
		JToolbarHelper::title($title,'key');
		// add the back button
		// JToolBarHelper::custom('apikey.back', 'undo-2', '', 'COM_SENDINBLUE_BACK', false);
		// add cpanel button
		JToolBarHelper::custom('apikey.dashboard', 'grid-2', '', 'COM_SENDINBLUE_DASH', false);
		if ($this->canDo->get('apikey.save'))
		{
			// add Save button.
			JToolBarHelper::custom('apikey.saveApikey', 'publish', '', 'COM_SENDINBLUE_SAVE', false);
		}

		// set help url for this view if found
		$help_url = SendinblueHelper::getHelpUrl('apikey');
		if (SendinblueHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_SENDINBLUE_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_sendinblue');
		}
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		// use the helper htmlEscape method instead.
		return SendinblueHelper::htmlEscape($var, $this->_charset);
	}
}
?>
