<?php
/**
 *	@package		Sendinblue
 *	@subpackage		view.html.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue View class for the Attributes
 */
class SendinblueViewAttributes extends JViewLegacy
{
	/**
	 * Attributes view display method
	 * @return void
	 */
	function display($tpl = null)
	{
		if ($this->getLayout() !== 'modal')
		{
			// Include helper submenu
			SendinblueHelper::addSubmenu('attributes');
		}

		// Assign data to the view
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');
		$this->state = $this->get('State');
		$this->user = JFactory::getUser();
		$this->listOrder = $this->escape($this->state->get('list.ordering'));
		$this->listDirn = $this->escape($this->state->get('list.direction'));
		$this->saveOrder = $this->listOrder == 'ordering';
		// get global action permissions
		$this->canDo = SendinblueHelper::getActions('attribute');
		$this->canEdit = $this->canDo->get('core.edit');
		$this->canState = $this->canDo->get('core.edit.state');
		$this->canCreate = $this->canDo->get('core.create');
		$this->canDelete = $this->canDo->get('core.delete');
		$this->canBatch = $this->canDo->get('core.batch');

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			$this->addToolbar();
			$this->sidebar = JHtmlSidebar::render();
			// load the batch html
			if ($this->canCreate && $this->canEdit && $this->canState)
			{
				$this->batchDisplay = JHtmlBatch_::render();
			}
		}
		
		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		// Display the template
		parent::display($tpl);

		// Set the document
		$this->setDocument();
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		JToolBarHelper::title(JText::_('COM_SENDINBLUE_ATTRIBUTES'), 'list');
		JHtmlSidebar::setAction('index.php?option=com_sendinblue&view=attributes');
		JFormHelper::addFieldPath(JPATH_COMPONENT . '/models/fields');

		if ($this->canCreate)
		{
			JToolBarHelper::addNew('attribute.add');
		}

		// Only load if there are items
		if (SendinblueHelper::checkArray($this->items))
		{
			if ($this->canEdit)
			{
				JToolBarHelper::editList('attribute.edit');
			}

			if ($this->canState)
			{
				JToolBarHelper::publishList('attributes.publish');
				JToolBarHelper::unpublishList('attributes.unpublish');
				JToolBarHelper::archiveList('attributes.archive');

				if ($this->canDo->get('core.admin'))
				{
					JToolBarHelper::checkin('attributes.checkin');
				}
			}

			// Add a batch button
			if ($this->canBatch && $this->canCreate && $this->canEdit && $this->canState)
			{
				// Get the toolbar object instance
				$bar = JToolBar::getInstance('toolbar');
				// set the batch button name
				$title = JText::_('JTOOLBAR_BATCH');
				// Instantiate a new JLayoutFile instance and render the batch button
				$layout = new JLayoutFile('joomla.toolbar.batch');
				// add the button to the page
				$dhtml = $layout->render(array('title' => $title));
				$bar->appendButton('Custom', $dhtml, 'batch');
			}

			if ($this->state->get('filter.published') == -2 && ($this->canState && $this->canDelete))
			{
				JToolbarHelper::deleteList('', 'attributes.delete', 'JTOOLBAR_EMPTY_TRASH');
			}
			elseif ($this->canState && $this->canDelete)
			{
				JToolbarHelper::trash('attributes.trash');
			}
		}
		if ($this->user->authorise('attribute.import_attribs', 'com_sendinblue'))
		{
			// add Import attribs button.
			JToolBarHelper::custom('attributes.importAttribs', 'pencil', '', 'COM_SENDINBLUE_IMPORT_ATTRIBS', false);
		}

		// set help url for this view if found
		$help_url = SendinblueHelper::getHelpUrl('attributes');
		if (SendinblueHelper::checkString($help_url))
		{
				JToolbarHelper::help('COM_SENDINBLUE_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_sendinblue');
		}

		if ($this->canState)
		{
			JHtmlSidebar::addFilter(
				JText::_('JOPTION_SELECT_PUBLISHED'),
				'filter_published',
				JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true)
			);
			// only load if batch allowed
			if ($this->canBatch)
			{
				JHtmlBatch_::addListSelection(
					JText::_('COM_SENDINBLUE_KEEP_ORIGINAL_STATE'),
					'batch[published]',
					JHtml::_('select.options', JHtml::_('jgrid.publishedOptions', array('all' => false)), 'value', 'text', '', true)
				);
			}
		}

		JHtmlSidebar::addFilter(
			JText::_('JOPTION_SELECT_ACCESS'),
			'filter_access',
			JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text', $this->state->get('filter.access'))
		);

		if ($this->canBatch && $this->canCreate && $this->canEdit)
		{
			JHtmlBatch_::addListSelection(
				JText::_('COM_SENDINBLUE_KEEP_ORIGINAL_ACCESS'),
				'batch[access]',
				JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text')
			);
		}

		// Set Attribcategoryid Selection
		$this->attribcategoryidOptions = $this->getTheAttribcategoryidSelections();
		if ($this->attribcategoryidOptions)
		{
			// Attribcategoryid Filter
			JHtmlSidebar::addFilter(
				'- Select '.JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBCATEGORYID_LABEL').' -',
				'filter_attribcategoryid',
				JHtml::_('select.options', $this->attribcategoryidOptions, 'value', 'text', $this->state->get('filter.attribcategoryid'))
			);

			if ($this->canBatch && $this->canCreate && $this->canEdit)
			{
				// Attribcategoryid Batch Selection
				JHtmlBatch_::addListSelection(
					'- Keep Original '.JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBCATEGORYID_LABEL').' -',
					'batch[attribcategoryid]',
					JHtml::_('select.options', $this->attribcategoryidOptions, 'value', 'text')
				);
			}
		}

		// Set Attribtypeid Selection
		$this->attribtypeidOptions = $this->getTheAttribtypeidSelections();
		if ($this->attribtypeidOptions)
		{
			// Attribtypeid Filter
			JHtmlSidebar::addFilter(
				'- Select '.JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBTYPEID_LABEL').' -',
				'filter_attribtypeid',
				JHtml::_('select.options', $this->attribtypeidOptions, 'value', 'text', $this->state->get('filter.attribtypeid'))
			);

			if ($this->canBatch && $this->canCreate && $this->canEdit)
			{
				// Attribtypeid Batch Selection
				JHtmlBatch_::addListSelection(
					'- Keep Original '.JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBTYPEID_LABEL').' -',
					'batch[attribtypeid]',
					JHtml::_('select.options', $this->attribtypeidOptions, 'value', 'text')
				);
			}
		}
	}

	/**
	 * Method to set up the document properties
	 *
	 * @return void
	 */
	protected function setDocument()
	{
		if (!isset($this->document))
		{
			$this->document = JFactory::getDocument();
		}
		$this->document->setTitle(JText::_('COM_SENDINBLUE_ATTRIBUTES'));
		$this->document->addStyleSheet(JURI::root() . "administrator/components/com_sendinblue/assets/css/attributes.css", (SendinblueHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		if(strlen($var) > 50)
		{
			// use the helper htmlEscape method instead and shorten the string
			return SendinblueHelper::htmlEscape($var, $this->_charset, true);
		}
		// use the helper htmlEscape method instead.
		return SendinblueHelper::htmlEscape($var, $this->_charset);
	}

	/**
	 * Returns an array of fields the table can be sorted by
	 *
	 * @return  array  Array containing the field name to sort by as the key and display text as value
	 */
	protected function getSortFields()
	{
		return array(
			'a.sorting' => JText::_('JGRID_HEADING_ORDERING'),
			'a.published' => JText::_('JSTATUS'),
			'a.attribname' => JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBNAME_LABEL'),
			'a.attribcategoryid' => JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBCATEGORYID_LABEL'),
			'a.attribtypeid' => JText::_('COM_SENDINBLUE_ATTRIBUTE_ATTRIBTYPEID_LABEL'),
			'a.id' => JText::_('JGRID_HEADING_ID')
		);
	}

	protected function getTheAttribcategoryidSelections()
	{
		// Get a db connection.
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);

		// Select the text.
		$query->select($db->quoteName('attribcategoryid'));
		$query->from($db->quoteName('#__sendinblue_attribute'));
		$query->order($db->quoteName('attribcategoryid') . ' ASC');

		// Reset the query using our newly populated query object.
		$db->setQuery($query);

		$results = $db->loadColumn();

		if ($results)
		{
			// get model
			$model = $this->getModel();
			$results = array_unique($results);
			$_filter = array();
			foreach ($results as $attribcategoryid)
			{
				// Translate the attribcategoryid selection
				$text = $model->selectionTranslation($attribcategoryid,'attribcategoryid');
				// Now add the attribcategoryid and its text to the options array
				$_filter[] = JHtml::_('select.option', $attribcategoryid, JText::_($text));
			}
			return $_filter;
		}
		return false;
	}

	protected function getTheAttribtypeidSelections()
	{
		// Get a db connection.
		$db = JFactory::getDbo();

		// Create a new query object.
		$query = $db->getQuery(true);

		// Select the text.
		$query->select($db->quoteName('attribtypeid'));
		$query->from($db->quoteName('#__sendinblue_attribute'));
		$query->order($db->quoteName('attribtypeid') . ' ASC');

		// Reset the query using our newly populated query object.
		$db->setQuery($query);

		$results = $db->loadColumn();

		if ($results)
		{
			// get model
			$model = $this->getModel();
			$results = array_unique($results);
			$_filter = array();
			foreach ($results as $attribtypeid)
			{
				// Translate the attribtypeid selection
				$text = $model->selectionTranslation($attribtypeid,'attribtypeid');
				// Now add the attribtypeid and its text to the options array
				$_filter[] = JHtml::_('select.option', $attribtypeid, JText::_($text));
			}
			return $_filter;
		}
		return false;
	}
}
