<?php
/**
 *	@package		Sendinblue
 *	@subpackage		default.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('chat.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'chat.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=chat'.$urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">
        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
</form>
	<div class="form-horizontal">
		<div class="row-fluid form-horizontal-desktop">

			<?php if ($this->sibjapi->settings === false) { ?>
			
				<div class="introtext">
					<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
					<p><?php echo JText::_('COM_SENDINBLUE_ACCOUNT_NOTE'); ?></p>
					<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_NO_APIKEY_SET'); ?></p>
				</div>
			
			<?php } else { ?>
			
				<?php if ($this->sibjapi->accountDetails === false) { ?>
					<div class="introtext">
						<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
						<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_INVALID_APIKEYDATA'); ?></p>
					</div>	
				<?php } else { ?>
						
					<?php $ad = $this->sibjapi->accountDetails->data; ?>
					
					<?php if ($this->simulatemanotactive || !isset($ad->marketingAutomation->enabled) || ( isset($ad->marketingAutomation->enabled) && $ad->marketingAutomation->enabled != true)) { ?>
						<div class="introtext">
							<p><?php echo JText::_('COM_SENDINBLUE_CHAT_INFO'); ?></p>
							<p>&nbsp;</p>
							<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_NOT_ACTIVE'); ?></p>
						</div>
						
					<?php } else { // MA is ON but lets check plugin ?>
						<?php if ($this->pluginState === null) { ?>
							<div class="introtext">
								<p><?php echo JText::_('COM_SENDINBLUE_CHAT_INFO'); ?></p>
								<p>&nbsp;</p>
								<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_NO_PLUGIN'); ?></p>
								<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_NO_PLUGIN_INFO'); ?></p>
							</div> 
						<?php } elseif ($this->pluginState === false) { ?>
							<div class="introtext">
								<p><?php echo JText::_('COM_SENDINBLUE_CHAT_INFO'); ?></p>
								<p>&nbsp;</p>
								<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE'); ?></p>
								<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_NOT'); ?></p>
								<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_NOT_INFO'); ?></p>
							</div> 
						<?php } else { ?>
							<?php if ($this->pluginCodeSet === false) { ?>
								<div class="introtext">
									<p><?php echo JText::_('COM_SENDINBLUE_CHAT_INFO'); ?></p>
									<p>&nbsp;</p>
									<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE'); ?></p>
									<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_TRACKINGID_ERROR'); ?></p>
									<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_TRACKINGID_ERROR_INFO'); ?></p>
								</div> 
							<?php } else { ?>	
								<div class="introtext">
									<p><?php echo JText::_('COM_SENDINBLUE_CHAT_ACTIVE'); ?></p>
									<p>&nbsp;</p>
									<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE'); ?></p>
									<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_TRACKINGID'); ?></p>
									<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_ACTIVE_PLUGIN_TRACKINGID_INFO'); ?></p>
								</div> 
							<?php } ?>
						<?php } ?>
	
						<div class="accountdetails">
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_SUBMENU_DATA_TITLE'); ?></p>
								<dl class="dl-horizontal">
									<dt><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_FIELD_TRACKINGID'); ?></dt><dd><?php echo $ad->marketingAutomation->key; ?></dd>
								</dl>
							</div>
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_SUBMENU_PLUGIN_TITLE'); ?></p>
								<dl class="dl-horizontal">
									<dt><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_FIELD_PLUGIN_INSTALLED'); ?></dt><dd><?php if ($this->pluginState !== null) { echo JText::_('JYES'); } else { echo JText::_('JNO'); } ?></dd>
									<dt><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_FIELD_PLUGIN_ENABLED'); ?></dt><dd><?php if ($this->pluginState === true) { echo JText::_('JYES'); } else { echo JText::_('JNO'); } ?></dd>
									<dt><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_FIELD_TRACKINGID'); ?></dt><dd><?php echo $this->pluginCode; ?></dd>
									<dt><?php echo JText::_('COM_SENDINBLUE_MARKETING_AUTOMATION_FIELD_OPTIONAL_EMAIL_ID'); ?></dt><dd><?php echo $this->pluginEmail; ?></dd>
								</dl>

							</div>
						</div>	
						
							
					<?php } ?>
					
				<?php } ?>
					
			<?php } ?>

		</div>					
	</div>					

<?php else: ?>
        <h1><?php echo JText::_('COM_SENDINBLUE_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

