<?php
/**
 *	@package		Sendinblue
 *	@subpackage		view.html.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access'); 

/**
 * Sendinblue View class for the Chat
 */
class SendinblueViewChat extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{
		// get component params
		$this->params = JComponentHelper::getParams('com_sendinblue');
		// get the application
		$this->app = JFactory::getApplication();
		// get the user object
		$this->user = JFactory::getUser();
		// get global action permissions
		$this->canDo = SendinblueHelper::getActions('chat');
		// Initialise variables.
		$this->item = $this->get('Item');
				$app   = \JFactory::getApplication();
				$this->sibjapi = new SibJapi(true, true); 
				if ($this->sibjapi->accountDetails === null || $this->sibjapi->accountDetails === false) {
					foreach ($this->sibjapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
					// show additiona error message in view based on the object state
				} else { 
					if (isset($this->sibjapi->accountDetails->data->marketingAutomation->enabled) && $this->sibjapi->accountDetails->data->marketingAutomation->enabled == true) { // SendInblueAccount has enabled MA
						// Is plug-in instaled?
						$this->pluginState = SibJapiHelper::getPluginState('system', 'sendinbluema');
						if ($this->pluginState !== null) { // check key
							$plugin = SibJapiHelper::getPluginData('system', 'sendinbluema');
							$params = new JRegistry($plugin->params);
							$this->pluginCode = $params->get('code');
							$this->pluginEmail = $params->get('emailid');
							if ($this->pluginCode == $this->sibjapi->accountDetails->data->marketingAutomation->key) {
								$this->pluginCodeSet = true; 
							} else {
								$this->pluginCodeSet = false;
							}
						}
					} 
				}
				$this->simulatemanotactive = $this->params->get('simulatemanotactive', null);
		

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			// add the tool bar
			$this->addToolBar();
		}

		// set the document
		$this->setDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function setDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_ADMINISTRATOR.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new sendinblueHeaderCheck;
		if ($this->sibjapi->settings === false) {
			$removebuttons = array( 'pluginEnable', 'pluginDisable', 'setTrackingID' );
		} else {
			if ($this->sibjapi->accountDetails === false) {
				$removebuttons = array( 'pluginEnable', 'pluginDisable', 'setTrackingID' );
			} else { 
				$ad = $this->sibjapi->accountDetails->data;
				if ($this->simulatemanotactive || !isset($ad->marketingAutomation->enabled) || ( isset($ad->marketingAutomation->enabled) && $ad->marketingAutomation->enabled != true)) {
					$removebuttons = array( 'pluginEnable', 'pluginDisable', 'setTrackingID' );						
				} else { // MA is ON but lets check plugin 
					if ($this->pluginState === null) {
						$removebuttons = array( 'pluginEnable', 'pluginDisable', 'setTrackingID' );
					} elseif ($this->pluginState === false) {
						$removebuttons = array( 'pluginDisable', 'setTrackingID' );
					} else {
						if ($this->pluginCodeSet === false) {
							$removebuttons = array( 'pluginEnable' );
						} else {	
							$removebuttons = array( 'pluginEnable', 'setTrackingID' );
						}
					}
				}
			}
		}
		if (count($removebuttons)) {
		$js = '';
			foreach ($removebuttons as $item) {
		$js .= "var attr = $(this).attr('onclick');";
		$js .= "if (typeof attr !== typeof undefined && attr !== false) {";
				$js .= "if ( $( this ).attr('onclick').indexOf('" . $item . "') >= 0  ) { $( this ).closest('div').remove(); }";
		$js .= "}";
			}			
			$js = "
				jQuery( document ).ready(function($) {
					$('button').each(function( index ) {"
					. $js .	"
					});
				});
			";
			$this->document->addScriptDeclaration($js);
		}
		
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/administrator/components/com_sendinblue/assets/css/chat.css', (SendinblueHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		// hide the main menu
		$this->app->input->set('hidemainmenu', true);
		// set the title
		if (isset($this->item->name) && $this->item->name)
		{
			$title = $this->item->name;
		}
		// Check for empty title and add view name if param is set
		if (empty($title))
		{
			$title = JText::_('COM_SENDINBLUE_CHAT');
		}
		// add title to the page
		JToolbarHelper::title($title,'comments-2');
		// add the back button
		// JToolBarHelper::custom('chat.back', 'undo-2', '', 'COM_SENDINBLUE_BACK', false);
		// add cpanel button
		JToolBarHelper::custom('chat.dashboard', 'grid-2', '', 'COM_SENDINBLUE_DASH', false);
		if ($this->canDo->get('chat.enable_plugin'))
		{
			// add Enable plugin button.
			JToolBarHelper::custom('chat.pluginEnable', 'publish', '', 'COM_SENDINBLUE_ENABLE_PLUGIN', false);
		}
		if ($this->canDo->get('chat.disable_plugin'))
		{
			// add Disable plugin button.
			JToolBarHelper::custom('chat.pluginDisable', 'unpublish', '', 'COM_SENDINBLUE_DISABLE_PLUGIN', false);
		}
		if ($this->canDo->get('chat.set_plugin_tracking_id'))
		{
			// add Set plugin Tracking ID button.
			JToolBarHelper::custom('chat.setTrackingID', 'pencil', '', 'COM_SENDINBLUE_SET_PLUGIN_TRACKING_ID', false);
		}

		// set help url for this view if found
		$help_url = SendinblueHelper::getHelpUrl('chat');
		if (SendinblueHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_SENDINBLUE_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_sendinblue');
		}
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		// use the helper htmlEscape method instead.
		return SendinblueHelper::htmlEscape($var, $this->_charset);
	}
}
?>
