<?php
/**
 *	@package		Sendinblue
 *	@subpackage		default.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('dashboard.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'dashboard.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=dashboard'.$urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">
        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
</form>
<div id="j-main-container">
	<div class="span9">





<?php if ($this->sibjapi->settings === false) { ?>

	<div class="introtext">
		<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
		<p><?php echo JText::_('COM_SENDINBLUE_ACCOUNT_NOTE'); ?></p>
		<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_NO_APIKEY_SET'); ?></p>
		<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_APIKEY_INFO'); ?></p>
	</div>

<?php } else { ?>

	<?php if ($this->sibjapi->accountDetails === false) { ?>
		<div class="introtext">
			<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
			<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_INVALID_APIKEYDATA'); ?></p>
			<p class="alert-info"><?php echo JText::_('COM_SENDINBLUE_APIKEY_INFO_DASHBOARD'); ?></p>
		</div>	
	<?php } else { ?>
		<div class="accountdetails">
			
			<?php $ad = $this->sibjapi->accountDetails->data; ?>
			
			<div class="row-fluid">
				<div class="span6">
					<p>Your data</p>
					<dl class="dl-horizontal">
						<dt>First name:</dt><dd><?php if (isset($ad->firstName)) { echo $ad->firstName; } ?></dd>
						<dt>Last name:</dt><dd><?php if (isset($ad->lastName)) { echo $ad->lastName; } ?></dd>
						<dt>Email address:</dt><dd><?php if (isset($ad->email)) { echo $ad->email; } ?></dd>
						<dt>Company name:</dt><dd><?php if (isset($ad->companyName)) { echo $ad->companyName; } ?></dd>
					</dl>
				</div>
				<div class="span6">
					<p>Address</p>
					<dl class="dl-horizontal">
						<dt>Street:</dt><dd><?php if (isset($ad->address->street)) { echo $ad->address->street; } ?></dd>
						<dt>City:</dt><dd><?php if (isset($ad->address->city)) { echo $ad->address->city; } ?></dd>
						<dt>ZIP Code:</dt><dd><?php if (isset($ad->address->zipCode)) { echo $ad->address->zipCode; } ?></dd>
						<dt>Country:</dt><dd><?php if (isset($ad->address->country)) { echo $ad->address->country; } ?></dd>
					</dl>
				</div>
			</div>
			<div class="row-fluid">
				<div class="span6">
					<p>Email Plan</p>
					<dl class="dl-horizontal">
						<dt>Plan type:</dt><dd><?php if (isset($ad->plan[0]->type)) { echo $ad->plan[0]->type; } ?></dd>
						<dt>Credits:</dt><dd><?php if (isset($ad->plan[0]->credits)) { echo $ad->plan[0]->credits; } ?></dd>
						<dt>Credits type:</dt><dd><?php if (isset($ad->plan[0]->creditsType)) { echo $ad->plan[0]->creditsType; } ?></dd>
					</dl>
				</div>
				<div class="span6">
					<p>SMS Plan</p>
					<dl class="dl-horizontal">
						<dt>Plan type:</dt><dd><?php if (isset($ad->plan[1]->type)) { echo $ad->plan[1]->type; } ?></dd>
						<dt>Credits:</dt><dd><?php if (isset($ad->plan[1]->credits)) { echo $ad->plan[1]->credits; } ?></dd>
						<dt>Credits type:</dt><dd><?php if (isset($ad->plan[1]->creditsType)) { echo $ad->plan[1]->creditsType; } ?></dd>
					</dl>
				</div>
			</div>


			<div class="infomsg">
				<?php //if (isset($this->msgsent) && $this->msgsent == true) { ?>
					<?php echo JText::_('COM_SENDINBLUE_INSTALLATION_NOTE') . $this->sibjapi->settings->postinstallmsgsent; ?>.
				<?php //} ?>
			</div>
		</div>
	<?php } ?>
		
<?php } ?>




<?php if(isset($this->icons['main']) && is_array($this->icons['main'])) :?>
	<?php foreach($this->icons['main'] as $icon): ?>
		<div class="dashboard-wraper">
			<div class="dashboard-content"> 
				<a class="icon" href="<?php echo $icon->url; ?>">
					<img alt="<?php echo $icon->alt; ?>" src="components/com_sendinblue/assets/images/icons/<?php  echo $icon->image; ?>">
					<span class="dashboard-title"><?php echo JText::_($icon->name); ?></span>
				</a>
			 </div>
		</div>
	<?php endforeach; ?>
	<div class="clearfix"></div>
<?php else: ?>
	<div class="alert alert-error"><h4 class="alert-heading"><?php echo JText::_("COM_SENDINBLUE_PERMISSION_DENIED_OR_NOT_CORRECTLY_SET"); ?></h4><div class="alert-message"><?php echo JText::_("COM_SENDINBLUE_PLEASE_NOTIFY_YOUR_SYSTEM_ADMINISTRATOR_IF_RESULT_IS_UNEXPECTED"); ?></div></div>
<?php endif; ?>

	</div>
	<div class="span3">
		<?php echo $this->loadTemplate('sendinbluecomponent'); ?>
	</div>
</div>
<?php else: ?>
        <h1><?php echo JText::_('COM_SENDINBLUE_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

