<?php
/**
 *	@package		Sendinblue
 *	@subpackage		view.html.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access'); 

/**
 * Sendinblue View class for the Dashboard
 */
class SendinblueViewDashboard extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{
		// get component params
		$this->params = JComponentHelper::getParams('com_sendinblue');
		// get the application
		$this->app = JFactory::getApplication();
		// get the user object
		$this->user = JFactory::getUser();
		// get global action permissions
		$this->canDo = SendinblueHelper::getActions('dashboard');
		// Initialise variables.
		$this->item = $this->get('Item');
				
				$this->icons			= $this->get('Icons');
				$this->manifest = SendinblueHelper::manifest();
				$app   = \JFactory::getApplication();
				$this->sibjapi = new SibJapi(true, true); 
				if ($this->sibjapi->accountDetails === null || $this->sibjapi->accountDetails === false) {
					foreach ($this->sibjapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
				} else { 
					$msgsent = SibJapiHelper::sendPostInstallMesage($this->sibjapi);
				}
		
		

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			// add the tool bar
			$this->addToolBar();
		}

		// set the document
		$this->setDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function setDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_ADMINISTRATOR.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new sendinblueHeaderCheck;
		$this->contributors = array();
		
		$this->app->input->set('hidemainmenu', false);
		
		// Add PHP (custom document script) 
				// set buttons to remove under specific conditions - button are set buy method names defined under custom buttons
				$removebuttons = array( 'dashboard' );
				if (count($removebuttons)) {
					$js = '';
					foreach ($removebuttons as $item) {
		$js .= "var attr = $(this).attr('onclick');";
		$js .= "if (typeof attr !== typeof undefined && attr !== false) {";
				$js .= "if ( $( this ).attr('onclick').indexOf('" . $item . "') >= 0  ) { $( this ).closest('div').remove(); }";
		$js .= "}";
					}			
					$js = "
						jQuery( document ).ready(function($) {
							$('button').each(function( index ) {"
							. $js .	"
							});
						});
					";
					$this->document->addScriptDeclaration($js);
				}
		
		
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/administrator/components/com_sendinblue/assets/css/dashboard.css', (SendinblueHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
		// Set the Custom CSS script to view
		$this->document->addStyleDeclaration("
			.dashboard-container {
			    margin-left: 10px;
			    margin-top: 10px;
			    width: 100%;
			}
			.dashboard-container [class*=\"span\"] {
			    display: block;
			    float: none;
			    margin-left: 0;
			    width: auto;
			}
			.dashboard-container:before, .dashboard-container:after {
			    content: \"\";
			    display: table;
			}
			.dashboard-container:after {
			    clear: both;
			}
			.dashboard-container [class*=\"span\"] {
			    box-sizing: border-box;
			    display: block;
			    float: left;
			    min-height: 145px;
			    min-width: 96px;
			    width: 100%;
			}
			.dashboard-container [class*=\"span\"]:first-child {
			    margin-left: 0;
			}
			.dashboard-wraper {
			    background: none repeat scroll 0 0 hsl(0, 0%, 93%);
			    border-radius: 5px;
			    float: left;
			    margin: 1%;
			    padding: 3px;
			    width: 17%;
			    min-height: 194px;
			    min-width: 96px;
			}
			.dashboard-content a {
			    background: linear-gradient(to bottom, hsl(0, 0%, 100%) 0%, hsl(0, 0%, 96%) 47%, hsl(0, 0%, 93%) 100%) repeat scroll 0 0 hsla(0, 0%, 0%, 0);
			    border: 1px solid hsl(0, 0%, 85%);
			    border-radius: 4px;
			    box-shadow: 0 0 3px hsla(0, 0%, 0%, 0.1) inset;
			    color: hsl(0, 0%, 20%);
			    display: block;
			    min-height: 89px;
			    padding: 10px;
			    text-align: center;
			    text-decoration: none;
			}
			.dashboard-content a:hover {
			    background: linear-gradient(to bottom, hsl(0, 0%, 90%) 0%, hsl(0, 0%, 100%) 100%) repeat scroll 0 0 hsla(0, 0%, 0%, 0);
			    color: hsl(200, 100%, 30%);
			    text-decoration: none;
			}
			.dashboard-title {
			    display: block;
			    padding-top: 5px;
			}
			.dashboard-info {
			    background: linear-gradient(to bottom, hsl(0, 0%, 100%) 0%, hsl(0, 0%, 96%) 47%, hsl(0, 0%, 93%) 100%) repeat scroll 0 0 hsla(0, 0%, 0%, 0);
			    border: 1px solid hsl(0, 0%, 85%);
			    border-radius: 4px;
			    box-shadow: 0 0 3px hsla(0, 0%, 0%, 0.1) inset;
			    color: hsl(0, 0%, 20%);
			    display: block;
			    font-size: 12px;
			    padding: 10px;
			    text-align: center;
			}
			.dashboard-info span {
			    display: block;
			    text-align: center;
			}
			.dashboard-info img {
			    margin: 0 auto;
			}
			.dashboard-table {
			    border-top: 1px solid hsl(0, 0%, 87%);
			    margin-top: 5px;
			    width: 100%;
			}
			.dashboard-info h5 {
			    font-size: 11px;
			    font-weight: bold;
			}
			.dashboard-block {
			    background: linear-gradient(to bottom, hsl(0, 0%, 95%) 0%, hsl(0, 0%, 86%) 100%) repeat scroll 0 0 hsla(0, 0%, 0%, 0);
			    border: 1px solid hsl(0, 0%, 76%);
			    border-radius: 3px;
			    box-shadow: 0 1px 0 hsl(0, 0%, 98%) inset;
			    margin-bottom: 20px;
			}
			.dashboard-block .dashboard-block-head {
			    background: linear-gradient(to bottom, hsl(0, 0%, 95%) 0%, hsl(0, 0%, 86%) 100%) repeat scroll 0 0 hsla(0, 0%, 0%, 0);
			    border-bottom: 1px solid hsl(0, 0%, 76%);
			    border-radius: 3px 3px 0 0;
			    box-shadow: 0 1px 0 hsl(0, 0%, 98%) inset, 0 0 3px hsl(0, 0%, 87%);
			    height: 40px;
			    position: relative;
			}
			.dashboard-block .dashboard-block-head h5 {
			    font-size: 12px;
			    margin: 0;
			    padding-left: 10px;
			    padding-top: 11px;
			    text-transform: uppercase;
			}
			.dashboard-block .dashboard-block-content {
			    background: none repeat scroll 0 0 hsl(0, 0%, 93%);
			    border-radius: 0 0 3px 3px;
			}
			.dashboard-block .dashboard-block-box {
			    background: none repeat scroll 0 0 hsl(0, 0%, 100%);
			    border-top: 1px solid hsl(0, 0%, 82%);
			    box-shadow: 0 0 5px hsl(0, 0%, 87%) inset;
			}
			.dashboard-block .dashboard-block-content .dashboard-block-box {
			    margin-top: 0 !important;
			}
			.dashboard-block .dashboard-block-content .dashboard-block-box .dashboard-block-table {
			    margin-bottom: 0 !important;
			}
			.dashboard-block-table {
			    background-color: hsla(0, 0%, 0%, 0);
			    border-collapse: collapse;
			    border-spacing: 0;
			    margin-bottom: 20px;
			    max-width: 100%;
			    width: 100%;
			}
			.dashboard-block-table th, .dashboard-block-table td {
			    border-top: 1px solid hsl(0, 0%, 87%);
			    line-height: 20px;
			    padding: 5px;
			    text-align: left;
			    vertical-align: middle;
			}
			.dashboard-badge {
			    background-color: hsl(0, 0%, 60%);
			    border-radius: 9px;
			    color: hsl(0, 0%, 100%);
			    font-size: 11.844px;
			    font-weight: bold;
			    line-height: 14px;
			    padding: 1px 9px 2px;
			    text-shadow: 0 -1px 0 hsla(0, 0%, 0%, 0.25);
			    vertical-align: baseline;
			    white-space: nowrap;
			}
		");
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		// hide the main menu
		$this->app->input->set('hidemainmenu', true);
		// set the title
		if (isset($this->item->name) && $this->item->name)
		{
			$title = $this->item->name;
		}
		// Check for empty title and add view name if param is set
		if (empty($title))
		{
			$title = JText::_('COM_SENDINBLUE_DASHBOARD');
		}
		// add title to the page
		JToolbarHelper::title($title,'grid-2');
		// add the back button
		// JToolBarHelper::custom('dashboard.back', 'undo-2', '', 'COM_SENDINBLUE_BACK', false);
		// add cpanel button
		JToolBarHelper::custom('dashboard.dashboard', 'grid-2', '', 'COM_SENDINBLUE_DASH', false);

		// set help url for this view if found
		$help_url = SendinblueHelper::getHelpUrl('dashboard');
		if (SendinblueHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_SENDINBLUE_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_sendinblue');
		}
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		// use the helper htmlEscape method instead.
		return SendinblueHelper::htmlEscape($var, $this->_charset);
	}
}
?>
