<?php
/**
 *	@package		Sendinblue
 *	@subpackage		default.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('exportcontacts.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'exportcontacts.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=exportcontacts'.$urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">
        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
</form>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=exportcontacts'.$urlId); ?>" method="post" name="adminForm" id="adminFormREPLACEMENT" class="form-validate" enctype="multipart/form-data">
    <input type="hidden" name="task" value="" />
    <?php echo JHtml::_('form.token'); ?>

	<div class="form-horizontal">
		<div class="row-fluid form-horizontal-desktop">

			<?php if ($this->sibjapi->settings === false) { ?>
			
				<div class="introtext">
					<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
					<p><?php echo JText::_('COM_SENDINBLUE_ACCOUNT_NOTE'); ?></p>
					<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_NO_APIKEY_SET'); ?></p>
				</div>
			
			<?php } else { ?>

				<?php if ($this->sibjapi->accountDetails === false) { ?>
					<div class="introtext">
						<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
						<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_INVALID_APIKEYDATA'); ?></p>
					</div>	
				<?php } else { ?>
					
					<?php if ($this->attribs === false) { ?>
						<div class="introtext">
							<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
							<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_UNABLE_TO_LOAD_ATTRIBUTES'); ?></p>
						</div>	
					<?php } else { ?>

						<div class="accountdetails">
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_EXPORTCONTACTS_USERS_OPTIONS_TITLE'); ?></p>
								<?php echo $this->form->renderFieldset('users'); ?>
								<p><?php echo JText::_('COM_SENDINBLUE_EXPORTCONTACTS_CONTACTS_OPTIONS_TITLE'); ?></p>
								<?php echo $this->form->renderFieldset('contacts'); ?>
			 				</div>
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_EXPORTCONTACTS_LISTS_TITLE'); ?></p>
								<?php echo $this->form->renderFieldset('listsoptions'); ?>
								<p><?php echo JText::_('COM_SENDINBLUE_EXPORTCONTACTS_TITLE'); ?></p>
								<div><?php echo JText::_('COM_SENDINBLUE_EXPORTCONTACTS_INFO'); ?></div>
								<?php echo $this->form->renderFieldset('nameoptions'); ?>
							</div>
						</div>
	
					<?php } ?>

				<?php } ?>

			<?php } ?>

		</div>
	</div>
</form>

<?php else: ?>
        <h1><?php echo JText::_('COM_SENDINBLUE_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

