<?php
/**
 *	@package		Sendinblue
 *	@subpackage		view.html.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access'); 

/**
 * Sendinblue View class for the Exportcontacts
 */
class SendinblueViewExportcontacts extends JViewLegacy
{
	// Overwriting JView display method
	function display($tpl = null)
	{
		// get component params
		$this->params = JComponentHelper::getParams('com_sendinblue');
		// get the application
		$this->app = JFactory::getApplication();
		// get the user object
		$this->user = JFactory::getUser();
		// get global action permissions
		$this->canDo = SendinblueHelper::getActions('exportcontacts');
		// Initialise variables.
		$this->item = $this->get('Item');
					$app   = \JFactory::getApplication();
					$this->sibjapi = new SibJapi(true, true); 
					if ($this->sibjapi->accountDetails === null || $this->sibjapi->accountDetails === false) {
						foreach ($this->sibjapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
						// show additiona error message in view based on the object state
					} else {
						// reload attributes 
						if (!($this->attribs = SibJapiHelper::importAttribs())) {
							// show additiona error message in view based on the object state
						} else {
							\JForm::addFormPath(JPATH_COMPONENT . '/models/forms');
							\JForm::addFieldPath(JPATH_COMPONENT . '/models/fields');
							$name = 'com_sendinblue.exportcontacts';
							$source = 'exportcontacts';
							$this->form = \JForm::getInstance($name, $source, array('control' => 'jform'));
						}
					}		
		

		// We don't need toolbar in the modal window.
		if ($this->getLayout() !== 'modal')
		{
			// add the tool bar
			$this->addToolBar();
		}

		// set the document
		$this->setDocument();

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors), 500);
		}

		parent::display($tpl);
	}

	/**
	 * Prepares the document
	 */
	protected function setDocument()
	{

		// always make sure jquery is loaded.
		JHtml::_('jquery.framework');
		// Load the header checker class.
		require_once( JPATH_COMPONENT_ADMINISTRATOR.'/helpers/headercheck.php' );
		// Initialize the header checker.
		$HeaderCheck = new sendinblueHeaderCheck;
		// add the document default css file
		$this->document->addStyleSheet(JURI::root(true) .'/administrator/components/com_sendinblue/assets/css/exportcontacts.css', (SendinblueHelper::jVersion()->isCompatible('3.8.0')) ? array('version' => 'auto') : 'text/css');
		// Set the Custom JS script to view
		$this->document->addScriptDeclaration("
			jQuery( document ).ready(function($) {
				$('#adminForm').remove();
				$('#adminFormREPLACEMENT').attr('id', 'adminForm');
			});
			
		");
	}

	/**
	 * Setting the toolbar
	 */
	protected function addToolBar()
	{
		// hide the main menu
		$this->app->input->set('hidemainmenu', true);
		// set the title
		if (isset($this->item->name) && $this->item->name)
		{
			$title = $this->item->name;
		}
		// Check for empty title and add view name if param is set
		if (empty($title))
		{
			$title = JText::_('COM_SENDINBLUE_EXPORTCONTACTS');
		}
		// add title to the page
		JToolbarHelper::title($title,'users');
		// add the back button
		// JToolBarHelper::custom('exportcontacts.back', 'undo-2', '', 'COM_SENDINBLUE_BACK', false);
		// add cpanel button
		JToolBarHelper::custom('exportcontacts.dashboard', 'grid-2', '', 'COM_SENDINBLUE_DASH', false);
		if ($this->canDo->get('exportcontacts.export_contacts'))
		{
			// add Export contacts button.
			JToolBarHelper::custom('exportcontacts.startExportcontacts', 'upload', '', 'COM_SENDINBLUE_EXPORT_CONTACTS', false);
		}

		// set help url for this view if found
		$help_url = SendinblueHelper::getHelpUrl('exportcontacts');
		if (SendinblueHelper::checkString($help_url))
		{
			JToolbarHelper::help('COM_SENDINBLUE_HELP_MANAGER', false, $help_url);
		}

		// add the options comp button
		if ($this->canDo->get('core.admin') || $this->canDo->get('core.options'))
		{
			JToolBarHelper::preferences('com_sendinblue');
		}
	}

	/**
	 * Escapes a value for output in a view script.
	 *
	 * @param   mixed  $var  The output to escape.
	 *
	 * @return  mixed  The escaped value.
	 */
	public function escape($var)
	{
		// use the helper htmlEscape method instead.
		return SendinblueHelper::htmlEscape($var, $this->_charset);
	}
}
?>
