<?php
/**
 *	@package		Sendinblue
 *	@subpackage		default.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

//Add PHP (custom view script) *
$config = JFactory::getConfig();
$smtppass = $config->get('smtppass'); 
$mailfrom = $config->get('mailfrom');


JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
?>
<?php if ($this->canDo->get('smtpsettings.access')): ?>
<script type="text/javascript">
	Joomla.submitbutton = function(task) {
		if (task === 'smtpsettings.back') {
			parent.history.back();
			return false;
		} else {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
	}
</script>
<?php $urlId = (isset($this->item->id)) ? '&id='. (int) $this->item->id : ''; ?>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=smtpsettings'.$urlId); ?>" method="post" name="adminForm" id="adminForm" class="form-validate" enctype="multipart/form-data">
        <input type="hidden" name="task" value="" />
        <?php echo JHtml::_('form.token'); ?>
</form>
<form action="<?php echo JRoute::_('index.php?option=com_sendinblue&view=smtpsettings'.$urlId); ?>" method="post" name="adminForm" id="adminFormREPLACEMENT" class="form-validate" enctype="multipart/form-data">

	<div class="form-horizontal">
		<div class="row-fluid form-horizontal-desktop">

			<?php if ($this->sibjapi->settings === false) { ?>
			
				<div class="introtext">
					<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
					<p><?php echo JText::_('COM_SENDINBLUE_ACCOUNT_NOTE'); ?></p>
					<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_NO_APIKEY_SET'); ?></p>
				</div>
			
			<?php } else { ?>
			
				<?php if ($this->sibjapi->accountDetails === false) { ?>
					<div class="introtext">
						<p><?php echo JText::_('COM_SENDINBLUE_SHORT_DESC'); ?></p>
						<p class="alert-error"><?php echo JText::_('COM_SENDINBLUE_ERROR_INVALID_APIKEYDATA'); ?></p>
					</div>	
				<?php } else {  ?>
						
					<?php $ad = $this->sibjapi->accountDetails->data; ?>
					
					<?php if ($this->simulatesmtpnotactive || !isset($ad->relay->enabled) || ( isset($ad->relay->enabled) && $ad->relay->enabled != true)) { ?>
						<div class="introtext">
							<p><?php echo JText::_('COM_SENDINBLUE_SMTP_NOT_ACTIVE'); ?></p>
						</div>
						
					<?php } else { // smtp is ON but lets check setting ?>
						<?php if ($this->SMTPset == false) { ?>
							<div class="introtext">
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_ACTIVE_NOT_SET'); ?> <strong><?php echo JText::_('COM_SENDINBLUE_SET_EMAIL_SETTINGS'); ?></strong>.</p>
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_ACTIVE_NOT_SET_INFO'); ?></p>
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_TESTMAIL_INFO'); ?></p>
								<p class="alert-info"><strong><?php echo JText::_('COM_SENDINBLUE_SMTP_IMPORTANT'); ?> <strong><?php echo JText::_('COM_SENDINBLUE_RESTORE_SMPT_SETTINGS'); ?></strong></p>
							</div> 
						<?php } else { ?>
							<div class="introtext">
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_ACTIVE_SET'); ?> <strong><?php echo JText::_('COM_SENDINBLUE_SET_EMAIL_SETTINGS'); ?></strong>.</p>
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_ACTIVE_NOT_SET_INFO'); ?></p>
								<p><?php echo JText::_('COM_SENDINBLUE_SMTP_TESTMAIL_INFO'); ?></p>
								<p class="alert-info"><strong><?php echo JText::_('COM_SENDINBLUE_SMTP_IMPORTANT'); ?> <strong><?php echo JText::_('COM_SENDINBLUE_RESTORE_SMPT_SETTINGS'); ?></strong></p>
							</div>
						<?php } ?>
	
						<div class="accountdetails">
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_YOUR_SMTP_SERVER_DATA'); ?></p>
								<dl class="dl-horizontal">
									<dt><?php echo JText::_('COM_SENDINBLUE_HOST_NAME'); ?></dt><dd><?php echo $ad->relay->data->relay; ?></dd>
									<dt><?php echo JText::_('COM_SENDINBLUE_SMTP_USERNAME'); ?></dt><dd><?php echo $ad->relay->data->userName; ?></dd>
									<dt><?php echo JText::_('COM_SENDINBLUE_SMTP_PORT'); ?></dt><dd><?php echo $ad->relay->data->port; ?></dd>
									<dt>
										<div class="control-label">
											<label id="jform_password-lbl" for="jform_password" class="hasPopover" title="" 
												data-content="Password to be used to conect to Sendinblue SMTP server" data-original-title="SMTP password"><?php echo JText::_('COM_SENDINBLUE_SMTP_PASSWORD'); ?></label>
										</div>
									</dt>
									<dd>
										<div class="controls">
											<input type="password" name="jform[smtppass]" id="jform_password" value="<?php echo $smtppass; ?>" class="text_area" size="80" placeholder="" maxlength="255" autocomplete="off">
										</div>
									</dd>
								</dl>
							</div>
							<div class="span6">
								<p><?php echo JText::_('COM_SENDINBLUE_TESTING'); ?></p>

								<div class="control-group">
									<div class="control-label">
										<label id="jform_testemail-lbl" for="jform_mailfrom" class="hasPopover" title="" 
											data-content="Testing email address" data-original-title="Testing email"><?php echo JText::_('COM_SENDINBLUE_TEST_EMAIL'); ?></label>
									</div>
									<div class="controls">
										<input type="text" name="jform[testemail]" id="jform_testemail" value="<?php echo $mailfrom; ?>"  
										class="text_area validate-email" size="80" placeholder="" maxlength="255" autocomplete="off">
									</div>

								</div>					

							</div>
						</div>	
						
							
					<?php } ?>
					
				<?php } ?>
					
			<?php } ?>

		</div>					
	</div>					



	<input type="hidden" name="task" value="" />
	<?php echo JHtml::_('form.token'); ?>
</form>


<?php else: ?>
        <h1><?php echo JText::_('COM_SENDINBLUE_NO_ACCESS_GRANTED'); ?></h1>
<?php endif; ?>

