<?php
/**
 * @package    sponsorswall
 * @subpackage controllers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

class SponsorswallControllerColumnwidths extends JControllerAdmin
{
    /**
     * Method handles the save action for the columnwidths
     * @since 1.0.0
     */
    public function save()
    {
        $app   = JFactory::getApplication();
        $input = $app->input;
        $model = $this->getModel();

        $form_data = $input->post->get('jform', '', 'ARRAY');
        if (empty($form_data)) {
            $app->redirect(JRoute::_('index.php?option=com_sponsorswall&view=columnwidths', false));
        }

        $model->saveColumnWidths($form_data);

        //TODO function schreiben und aufrufen, die die Tabelle bereinigt

        JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_sponsorswall&view=columnwidths', false));
    }

    /**
     * Method to get a model object, loading it if required.
     *
     * @param   string $name The model name. Optional.
     * @param   string $prefix The class prefix. Optional.
     * @param   array $config Configuration array for model. Optional.
     *
     * @return  JModelLegacy  The model.
     *
     * @since   1.6
     */
    public function getModel($name = 'Columnwidths', $prefix = 'SponsorswallModel', $config = array('ignore_request' => true))
    {
        return parent::getModel($name, $prefix, $config);
    }
}