<?php
/**
 * @package    sponsorswall
 * @subpackage controllers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

class SponsorswallControllerSend extends JControllerAdmin
{
	public function installationNotification() {
		$mailer = JFactory::getMailer();
		$host   = JUri::getInstance()->getHost();
		
		//Set sender
		$config = JFactory::getConfig();
		$sender = array( 
			$config->get( 'mailfrom' ),
			$config->get( 'fromname' ) 
		);
		$mailer->setSender($sender);
		
		//Add recipient
		$mailer->addRecipient('agr@agmedia.de');
		
		$body   = "Sponsorswall wurde auf ". $host ." installiert.";
		$mailer->setSubject('AGMedia - Extension installation - Sponsorswall');
		$mailer->setBody($body);
		$send = $mailer->Send();
		
		JFactory::getApplication()->redirect(JRoute::_('index.php?option=com_sponsorswall'));
	}
}