<?php
/**
 * @package    sponsorswall
 * @subpackage controllers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

use Joomla\Utilities\ArrayHelper;

class SponsorswallControllerSponsors extends JControllerAdmin
{
    /**
     * Method to save ordering
     *
     * @return  int   (1) on success
     *
     * @since   1.0.0
     */
    public function saveOrderAjax()
    {
        $input = JFactory::getApplication()->input;
        $pks   = $input->post->get('cid', array(), 'array');
        $order = $input->post->get('order', array(), 'array');
        ArrayHelper::toInteger($pks);
        ArrayHelper::toInteger($order);
        $model  = $this->getModel();
        $return = $model->saveorder($pks, $order);
        if ($return) {
            echo "1";
        }
        JFactory::getApplication()->close();
    }

    /**
     * Method to get a model object, loading it if required.
     *
     * @param   string $name The model name. Optional.
     * @param   string $prefix The class prefix. Optional.
     * @param   array $config Configuration array for model. Optional.
     *
     * @return  JModelLegacy  The model.
     *
     * @since   1.6
     */
    public function getModel($name = 'Sponsor', $prefix = 'SponsorswallModel', $config = array('ignore_request' => true))
    {
        return parent::getModel($name, $prefix, $config);
    }
}