<?php
/**
 * @package    sponsorswall
 * @subpackage helpers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * ThirdParty Component Category Tree
 * @since 1.0.0
 */
class SponsorswallCategories extends JCategories
{
    /**
     * Constructor
     *
     * @param   array $options Array of options
     * @since   1.0.0
     */
    public function __construct($options = array())
    {
        $options['table']     = '#__sponsorswall';
        $options['extension'] = 'com_sponsorswall';

        parent::__construct($options);
    }

    public function getCategoriesTree($max_level = 0)
    {
        $db = JFactory::getDbo();

        $query = $db->getQuery(true);
        $query->select('n.title, COUNT(*) AS level, n.id as id, 
            (
            SELECT parent.id
                FROM #__categories as parent              
                WHERE parent.lft < n.lft AND parent.rgt > n.rgt    
                ORDER BY parent.rgt-n.rgt ASC
                LIMIT 1
            ) as parent_id')
            ->from('#__categories AS n, #__categories AS p')
            ->where('n.lft BETWEEN p.lft AND p.rgt AND (p.id != n.id OR n.lft = 1)')
            ->where($db->quoteName('n.extension') . ' = ' . $db->quote('com_sponsorswall'));

        //If $max_level is set
        if ($max_level > 0) {
            $query->where($db->quoteName('n.level') . ' <= ' . $db->quote($max_level));
        }

        $query->group('n.lft');
        $query->order('n.lft');

        /*
         *   SELECT n.name,
                     COUNT(*)-1 AS level
                FROM tree AS n,
                     tree AS p
               WHERE n.lft BETWEEN p.lft AND p.rgt
            GROUP BY n.lft
            ORDER BY n.lft;
         * */

//        echo $query->dump();exit;
        $db->setQuery($query);
        $db->execute();
        $count  = $db->getNumRows();
        $result = $db->loadAssocList();

//        echo "<pre>"; print_r($result); exit;

        if ($count < 1) return array();
        return $result;
    }
}