<?php
/**
 * @package    sponsorswall
 * @subpackage helpers
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

jimport('joomla.filesystem.folder'); 					// Import filesystem libraries. Perhaps not necessary, but does not hurt

/**
 * Sponsorswall Helper.
 *
 * @package     Sponsorswall
 * @subpackage  Helpers
 * @since       1.0.0
 */
class SponsorswallHelper
{
    /**
     * Configure the Linkbar.
     *
     * @param $vName string The name of the active view.
     * @since 1.0.0
     */
    public static function addSubmenu($vName)
    {
        $jinput    = JFactory::getApplication()->input;
        $option    = $jinput->get->get('option', '');
        $extension = $jinput->get->get('extension', '');
        $view      = $jinput->get->get('view', '');

        if ($option == 'com_sponsorswall') {
            AgmLibAdminSidebar::setDefaultView('sponsors');

            AgmLibAdminSidebar::addHeader(JText::_('COM_SPONSORSWALL_SIDEBAR_HEADER'));
            AgmLibAdminSidebar::addLink(JText::_('COM_SPONSORSWALL_SIDEBAR_SPONSORS'), 'com_sponsorswall', 'sponsors', 'fa-sitemap');
            AgmLibAdminSidebar::addSpecialLink(JText::_('COM_SPONSORSWALL_SIDEBAR_CATEGORIES'), 'com_categories', 'categories', 'com_sponsorswall');
            AgmLibAdminSidebar::addLink(JText::_('COM_SPONSORSWALL_SIDEBAR_COLUMNWIDTHS'), 'com_sponsorswall', 'columnwidths', 'fa-sitemap');
        } elseif ($option == 'com_categories' AND $extension == 'com_sponsorswall') {
            JHtmlSidebar::addEntry(
                JText::_('COM_SPONSORSWALL_SIDEBAR_BACK'),
                'index.php?option=com_sponsorswall',
                $vName == 'sponsorswall'
            );
        }
    }
	
	/**
	 * Checke if all required components are installed
	 *
	 * @param $agmLibRequired		bool
	 * @param $agmLibMinVersion		string	e.g.: '1.0.0'
	 * 
	 * @return 	bool
	 * @version	1.1.0				Version der Funktion
	 * @since 	1.0.0
	 */
	public static function checkInstallation($agmLibRequired, $agmLibMinVersion)
	{
		//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		//Prüfen ob AGMedia Library installiert ist
		if(!JFolder::exists(JPATH_LIBRARIES . '/agmlib')) {
			throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIB_NOT_INTALLED'), 403);	
		}
		
		//Prüfen ob AGMedia library installiert ist
		if ($agmLibRequired) {
			$db = JFactory::getDbo();

			//Array mit einer Liste von allen Datenbanktabellen
			$query = $db->getQuery(true);
			$query
				->select('*')
				->from('#__extensions')
				->where('element LIKE "agmlib"');

			$db->setQuery($query);
			$result = $db->loadAssoc();

			if (empty($result['extension_id'])) {
				throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIB_NOT_INTALLED'), 403);
			}
		}		

		//Prüfen ob AGMedia library loader installiert ist
		if ($agmLibRequired && !defined('AGMEDIA_LIBRARYLOADER_INSTALLED')) {
			$db = JFactory::getDbo();

			//Array mit einer Liste von allen Datenbanktabellen
			$query = $db->getQuery(true);
			$query
				->select('*')
				->from('#__extensions')
				->where('element LIKE "%agmlibloader%"');

			$db->setQuery($query);
			$result = $db->loadAssoc();

			if (!empty($result['extension_id'])) {

				if ($result['enabled'] == 1) {
					define('AGMEDIA_LIBRARYLOADER_INSTALLED', '1');
				} else {
					throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIBRARLOADER_DISABLED'), 403);
				}

			} else {

				throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIBRARYLOADER_NOT_INTALLED'), 403);

			}
		}

		if(!AGMLIB_INCLUDED) {
			throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIBRARYLOADER_NOT_EXECUTED'), 403);	
		}

		if($agmLibRequired) {
			if(!AgmLibBase::versionCompare(AgmLibBase::version(), '>=', $agmLibMinVersion)) {
				throw new JAccessExceptionNotallowed(JText::_('ERROR_AGMLIB_VERSION_TOO_LOW'), 403);
			}
		}
	}
}