<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * The name of this class is dependent on the component being installed.
 * The class name should have the component's name, directly followed by
 * the text InstallerScript (ex:. com_helloWorldInstallerScript).
 *
 * This class will be called by Joomla!'s installer, if specified in your component's
 * manifest file, and is used for custom automation actions in its installation process.
 *
 * In order to use this automation script, you should reference it in your component's
 * manifest file as follows:
 * <scriptfile>script.php</scriptfile>
 *
 * @package     Joomla.Administrator
 * @subpackage  sponsorswall
 *
 * @copyright   Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
class com_sponsorswallInstallerScript
{
    /**
     * This method is called after a component is installed.
     *
     * @param  \stdClass $parent - Parent object calling this method.
     *
     * @return void
     */
    public function install($parent) 
    {
        //$parent->getParent()->setRedirectURL('index.php?option=com_sponsorswall');
    }

    /**
     * This method is called after a component is uninstalled.
     *
     * @param  \stdClass $parent - Parent object calling this method.
     *
     * @return void
     */
    public function uninstall($parent) 
    {
		$db = JFactory::getDbo();
		$query  = $db->getQuery(true);
		$query->setQuery('DROP TABLE '. $db->quoteName('#__sponsorswall_columnwidths') .', '. $db->quoteName('#__sponsorswall_sponsors'));
		$db->setQuery($query);
		$db->execute();
    }

    /**
     * This method is called after a component is updated.
     *
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
    public function update($parent) 
    {
		$db = JFactory::getDbo();
		$query  = $db->getQuery(true);
		
		$query->setQuery("SHOW COLUMNS FROM #__sponsorswall_sponsors");
		$db->setQuery($query);			
		$result = $db->loadAssocList();
		
		if(is_array($result) && !empty($result)) {
			//Check for "link_target"
			$key = array_search('link_target', array_column($result, 'Field'));
			if($key === false) {
				//Update Table
				$query = $db->getQuery(true);
				$query->setQuery("ALTER TABLE `#__sponsorswall_sponsors` ADD `link_target` TINYINT NOT NULL DEFAULT '1' AFTER `link`;");
				$db->setQuery($query);
				$db->execute();
			}						
		}		
    }

    /**
     * Runs just before any installation action is preformed on the component.
     * Verifications and pre-requisites should run in this function.
     *
     * @param  string    $type   - Type of PreFlight action. Possible values are:
     *                           - * install
     *                           - * update
     *                           - * discover_install
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
    public function preflight($type, $parent) 
    {
    }

    /**
     * Runs right after any installation action is preformed on the component.
     *
     * @param  string    $type   - Type of PostFlight action. Possible values are:
     *                           - * install
     *                           - * update
     *                           - * discover_install
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
    function postflight($type, $parent) 
    {
		?>
		
		<style type="text/css">
		.version-history {
			margin: 0 0 2em 0;
			padding: 0;
			list-style-type: none;
		}
		.version-history > li {
			margin: 0 0 0.5em 0;
			padding: 0 0 0 4em;
		}
		.version-new,
		.version-fixed,
		.version-upgraded {
			float: left;
			font-size: 0.8em;
			margin-left: -4.9em;
			width: 4.5em;
			color: white;
			text-align: center;
			font-weight: bold;
			text-transform: uppercase;
			-webkit-border-radius: 4px;
			-moz-border-radius: 4px;
			border-radius: 4px;
		}

		.version-new {
			background: #7dc35b;
		}
		.version-fixed {
			background: #e9a130;
		}
		.version-upgraded {
			background: #61b3de;
		}

		.install-ok {
			background: #7dc35b;
			color: #fff;
			padding: 3px;
		}

		.install-not-ok {
			background: #E9452F;
			color: #fff;
			padding: 3px;
		}

		.install-warning {
			background: #EFBB67;
			color: #fff;
			padding: 3px;
		}
		.big-warning {
			background: #FAF0DB;
			border: solid 1px #EBC46F;
			padding: 5px;
			font-size: 22px;
			line-height: 22px;
		}

		.big-warning b {
			color: red;
		}

		.red {
			color: red;
		}
		</style>		
		
		<div class="row-fluid" style="margin-bottom: 40px">	
			<div class="span12">
				<p>Thank you for installing Sponsorswall. I hope you enjoy using this extension. Let me know if you miss a feature or find a bug.<p>

				<h2>Changelog v1.0.7</h2>
				<ul class="version-history">
					<li><span class="version-new">New</span> Final version for Joomla 3</li>	
					<li><span class="version-new">New</span> Removed the function to enter a membership serial number. Component is free version for now.</li>	
				</ul>	

				<h2>Changelog v1.0.6</h2>
				<ul class="version-history">
					<li><span class="version-new">Fixed</span> A few little bugs</li>	
				</ul>	
				
				<h2>Changelog v1.0.5</h2>
				<ul class="version-history">
					<li><span class="version-new">New</span> Description for Categories. Some users of the component whished to be able to describe the sponsors category. Now you are able to. Just fill out the description field for the category with any html styling as you whish.</li>	
				</ul>	
				<?php /*
				
				<h2>Changelog v1.0.4</h2>
				<ul class="version-history">
					<li><span class="version-new">New</span> Url for sponsor is not required by default anymore.</li>	
					<li><span class="version-new">New</span> Target for link click now selectable by dropdown.</li>
					<li><span class="version-fixed">Fixed</span> Some bugs</li>					
				</ul>		
				
				<h2>Changelog v1.0.3</h2>
				<ul class="version-history">
					<li><span class="version-fixed">Fixed</span> Fixed a bug where you were not able to define default column widths if you have had selected Bootstrap 4 as template in the options.</li>					
				</ul>	
				
				<h2>Changelog v1.0.2</h2>
				<ul class="version-history">
					<li><span class="version-fixed">Fixed</span> Fixed a bug for Bootstrap4 templates where col-xs-* was changed to col-*</li>					
				</ul>				
				
				<h2>Changelog v1.0.1</h2>
				<ul class="version-history">
					<li><span class="version-new">New</span> Added uninstall information so that databse will get cleaned up if you uninstall the component</li>					
				</ul>
				
				<div class="alert alert-info">
				  <button type="button" class="close" data-dismiss="alert">&times;</button>
				  <h4>A message from the developer!</h4>
				  Before you start, let me ask you this real quick. As a developer I am naturally curious where and how my extensions are being used. Therefore I would be happy if you would let me know that you have installed this extension by clicking the button. Of course this is completely voluntary.
				</div>
				*/ ?>
				<a class="btn btn-large btn-primary" href="index.php?option=com_sponsorswall&task=send.installationNotification">Yes, start using Sponsorswall and send an installation notification.</a>
				<a class="btn btn-large btn-secondary" href="index.php?option=com_sponsorswall">No, just start using Sponsorswall</a>
			</div>
		</div>
		<?php
    }
}