<?php
/**
 * @package    sponsorswall
 * @subpackage models
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * Methods supporting a list of banner records.
 *
 * @since  1.6
 */
class SponsorswallModelColumnwidths extends JModelList
{
    /**
     * Constructor.
     *
     * @param   array $config An optional associative array of configuration settings.
     *
     * @see     JControllerLegacy
     * @since   1.6
     */
    public function __construct($config = array())
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
//                'cid', 'a.cid',
//                'name', 'a.name',
//                'state', 'a.state',
//                'ordering', 'a.ordering',
//                'catid', 'a.catid', 'category_name',
//                'checked_out', 'a.checked_out',
//                'checked_out_time', 'a.checked_out_time',
//                'created', 'a.created',
//                'clicks', 'a.clicks',
//                'publish_up', 'a.publish_up',
//                'publish_down', 'a.publish_down',
//                'published',
            );
        }

        parent::__construct($config);
    }

    public function getItems()
    {
        $items = parent::getItems();

        // Daten hinzufügen
        if (!empty($items)) {
            $db = JFactory::getDbo();

            foreach ($items as $key => $item) {
                ////////////////////////////////////////////////////////////////////////////////////////////////////////
                // Kategorietitel einrücken
                $spacer = '|-';
                for ($i = 1; $i < $item->level; $i++) {
                    $items[$key]->title = $spacer . ' ' . $items[$key]->title;
                }

                ////////////////////////////////////////////////////////////////////////////////////////////////////////
                // Spaltenbreiten der Kategorie holen
                $conditions = array(
                    $db->quoteName('cid') . ' = ' . $db->quote($item->id),
                );

                $query = $db->getQuery(true);
                $query->select(array(
                    $db->quoteName('col_xs'),
                    $db->quoteName('col_sm'),
                    $db->quoteName('col_md'),
                    $db->quoteName('col_lg')
                ))
                    ->from($db->quoteName('#__sponsorswall_columnwidths'))
                    ->where($conditions);
                $db->setQuery($query);
                $db->execute();
                $count  = $db->getNumRows();
                $result = $db->loadAssoc();
                if ($count < 1) continue;

                $items[$key]->col_widths = $result;
            }
        }

        return $items;
    }

    /**
     * Returns a reference to the a Table object, always creating it.
     *
     * @param   string $type The table type to instantiate
     * @param   string $prefix A prefix for the table class name. Optional.
     * @param   array $config Configuration array for model. Optional.
     *
     * @return  JTable  A JTable object
     *
     * @since   1.6
     */
    public function getTable($type = 'Columnwidth', $prefix = 'SponsorswallTable', $config = array())
    {
        return JTable::getInstance($type, $prefix, $config);
    }

    public function saveColumnWidths($form_data)
    {
        $db = JFactory::getDbo();
        foreach ($form_data as $catid => $cat) {
            $new_entry = true;

            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // Prüfen ob es bereits einen Eintrag für die Kategorie in der Tabelle gibt
            $conditions = array(
                $db->quoteName('cid') . ' = ' . $db->quote($catid),
            );

            $query = $db->getQuery(true);
            $query->select($db->quoteName(array('id')))
                ->from($db->quoteName('#__sponsorswall_columnwidths'))
                ->where($conditions);
            $db->setQuery($query);
            $db->execute();
            $count  = $db->getNumRows();
            $result = $db->loadAssoc();

            if ($count > 0) $new_entry = false;


            $object = new StdClass();

            if ($new_entry) {
                $object->cid = $catid;
            } else {
                $object->id = $result['id'];
            }

            $object->col_xs = $cat['col_xs'];
            $object->col_sm = $cat['col_sm'];
            $object->col_md = $cat['col_md'];
            $object->col_lg = $cat['col_lg'];

            if ($new_entry) {
                // Insert the object into the table.
                $result = JFactory::getDbo()->insertObject('#__sponsorswall_columnwidths', $object);
            } else {
                // Update data in the table using id as the primary key.
                $result = JFactory::getDbo()->updateObject('#__sponsorswall_columnwidths', $object, 'id');
            }
        }

        return true;
    }

    /**
     * Build an SQL query to load the list data.
     *
     * @return  JDatabaseQuery
     *
     * @since   1.6
     */
    protected function getListQuery()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Default query variables
        $db    = $this->getDbo();
        $query = $db->getQuery(true);

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Select the required fields from the table.
        $query->select(
            $this->getState(
                'list.select',
                'n.id AS id,'
                . 'n.title AS title,'
                . 'COUNT(n.id)-1 AS level'
            )
        );
        $query->from($db->quoteName('#__categories', 'n'));
        $query->from($db->quoteName('#__categories', 'p'));
        $query->where('n.lft BETWEEN p.lft AND p.rgt');
        $query->where($db->quoteName('n.extension') . ' = ' . $db->quote('com_sponsorswall'));
        $query->group('n.lft');
        $query->order('n.lft');

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Join over the users for the checked out user.
//		$query->select(
//		    $db->quoteName('w.col-xs', 'col-xs'),
//		    $db->quoteName('w.col-sm', 'col-sm'),
//		    $db->quoteName('w.col-md', 'col-md'),
//		    $db->quoteName('w.col-lg', 'col-lg')
//        )
//			->join('LEFT', $db->quoteName('#__sponsorswall_columnwidths', 'w') . ' ON n.id = w.cid');

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Filter by category.
        $categoryId = $this->getState('filter.cid');
        if (is_numeric($categoryId)) {
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // SubQuery bauen um auch Kinder der Kategorien beim Filtern zu berücksichtigen
            $subquery = $db->getQuery(true);
            $subquery
                ->select('n.title, COUNT(*) AS level, n.id as id')
                ->from('#__categories AS n, #__categories AS p')
                ->where('n.lft BETWEEN p.lft AND p.rgt')
                ->where($db->quoteName('n.extension') . ' = ' . $db->quote('com_sponsorswall'))
                ->where($db->quoteName('p.id') . ' = ' . $db->quote($categoryId));

            $subquery->group('n.lft');
            $subquery->order('n.lft');
            $db->setQuery($subquery);
            $db->execute();
            $count  = $db->getNumRows();
            $result = $db->loadAssocList();

            ///////////////////////////////////////////////////////////////////////////////////////////////////
            // SubQuery Ergebnis auswerten und die Filterkriterien auf die Hauptquery anwenden
            if ($count > 0) {
                $categories = array();
                foreach ($result as $cat) {
                    $categories[] = $db->escape($cat['id']);
                }
                $categories_string = implode(', ', $categories);
                $query->where($db->quoteName('n.id') . ' IN (' . $categories_string . ')');
            } else {
                $query->where($db->quoteName('n.id') . ' = ' . (int)$categoryId);
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Filter by search in title
        $search = $this->getState('filter.search');

        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where($db->quoteName('n.id') . ' = ' . (int)substr($search, 3));
            } else {
                $search = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($search), true) . '%'));
                $query->where('(n.title LIKE ' . $search . ')');
            }
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Add the list ordering clause.
        $orderCol  = $this->state->get('list.ordering', 'n.title');
        $orderDirn = $this->state->get('list.direction', 'ASC');

        $query->order($db->escape($orderCol . ' ' . $orderDirn));

        return $query;
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param   string $id A prefix for the store id.
     *
     * @return  string  A store id.
     *
     * @since   1.6
     */
    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.search');
        $id .= ':' . $this->getState('filter.published');
        $id .= ':' . $this->getState('filter.cid');

        return parent::getStoreId($id);
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @param   string $ordering An optional ordering field.
     * @param   string $direction An optional direction (asc|desc).
     *
     * @return  void
     *
     * @since   1.6
     */
    protected function populateState($ordering = 'n.title', $direction = 'asc')
    {
        // Load the filter state.
        $this->setState('filter.search', $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search', '', 'string'));
        $this->setState('filter.cid', $this->getUserStateFromRequest($this->context . '.filter.cid', 'filter_cid', '', 'cmd'));

        // Load the parameters.
        $this->setState('params', JComponentHelper::getParams('com_sponsorswall'));

        // List state information.
        parent::populateState($ordering, $direction);
    }
}
