<?php
/**
 * @package    sponsorswall
 * @subpackage fields
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

JFormHelper::loadFieldClass('list');
JLoader::register('SponsorswallCategories', JPATH_BASE . '/components/com_sponsorswall/helpers/category.php');

/**
 * Formularfeld liefert Optionen für eine Select Liste.
 * @since 1.0.0
 */
class JFormFieldSponsorswallCategory extends JFormFieldList
{

    //The field class must know its own type through the variable $type.
    protected $type = 'SponsorswallCategory';

    public function getOptions($distributor_id = 0)
    {
        $options   = array();
        $options[] = JHtml::_('select.option', 0, JText::_('COM_SPONSORSWALL_SELECT_DEFAULT_OPTION'), 'value', 'text');

        $max_level            = ($this->element['max_level'] > 0) ? $this->element['max_level'] : 0;
        $first_level_disabled = ($this->element['first_level_disabled'] == 1) ? true : false;

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Lade die Kategorien
        $categories      = new SponsorswallCategories;
        $categories_tree = $categories->getCategoriesTree($max_level);
        if (empty($categories_tree)) return $options;

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        // Baue die Optionen
        $spacer = '|-';
        foreach ($categories_tree as $category) {
            $cat_title = $category['title'];

            if ($category['level'] > 1) {
                for ($i = 1; $i < $category['level']; $i++) {
                    $cat_title = $spacer . ' ' . $cat_title;
                }
            }

            $disabled = false;
            if ($first_level_disabled && $category['level'] == 1) $disabled = true;

            //option(string $value, string $text = '', mixed $optKey = 'value', string $optText = 'text', boolean $disable = false) : \stdClass
            $options[] = JHtmlSelect::option($category['id'], $cat_title, 'value', 'text', $disabled);
        }

        return $options;
    }

}