<?php
/**
 * @package    sponsorswall
 * @subpackage component
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

if (!defined('DS')) {
    define('DS', "/");
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// COMPONENT SETTINGS
//-----------------------------------------------------------------------------------------------------------------------------------------
// DEFINE VERSION
if (!defined('AGMEDIA_SPONSORSWALL_VERSION')) {
    define('AGMEDIA_SPONSORSWALL_VERSION', '1.0.7');
}

// AGMedia Library setup
$agmLibRequired		= true;
$agmLibMinVersion	= '1.0.10';
//-----------------------------------------------------------------------------------------------------------------------------------------


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Joomla imports
jimport('joomla.filesystem.folder'); 					// Import filesystem libraries. Perhaps not necessary, but does not hurt
jimport('joomla.application.component.controller');		// import joomla controller library

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Register Tables
JTable::addIncludePath(JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_sponsorswall' . DS . 'tables');

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Register Helpers
JLoader::register('SponsorswallHelper', JPATH_COMPONENT . '/helpers/sponsorswall.php');
JLoader::register('SponsorswallCategories', JPATH_COMPONENT . '/helpers/category.php');

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Prüfen ob Benutzer entsprechende Berechtigung hat
if (!JFactory::getUser()->authorise('core.manage', 'com_sponsorswall')) {
    throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Check installation
SponsorswallHelper::checkInstallation($agmLibRequired, $agmLibMinVersion);

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Get an instance of the controller
$controller = JControllerLegacy::getInstance('Sponsorswall');
$input      = JFactory::getApplication()->input;
$task       = $input->get('task');

$controller->execute($task);
$controller->redirect();