<?php
/**
 * @package    sponsorswall
 * @subpackage tables
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

class SponsorswallTableSponsor extends JTable
{
    public $id;
    public $created;
    public $created_by;
    public $publish_up;
    public $publish_down;
    public $modified;
    public $modified_by;

    public function __construct($db)
    {
        parent::__construct('#__sponsorswall_sponsors', 'id', $db);

        $this->created    = JFactory::getDate()->toSql();
        $this->created_by = JFactory::getUser()->id;

        $this->publish_up = JFactory::getDate()->toSql();
        $this->setColumnAlias('published', 'state');
    }

    /**
     * Overloaded check function
     *
     * @return  boolean
     *
     * @see     JTable::check
     * @since   1.0.0
     */
    public function check()
    {
        // Check the publish down date is not earlier than publish up.
        if ($this->publish_down > $this->_db->getNullDate() && $this->publish_down < $this->publish_up) {
            $this->setError(JText::_('JGLOBAL_START_PUBLISH_AFTER_FINISH'));

            return false;
        }

        if (empty($this->publish_up)) {
            $this->publish_up = $this->getDbo()->getNullDate();
        }

        if (empty($this->publish_down)) {
            $this->publish_down = $this->getDbo()->getNullDate();
        }

        //Set modified
        if ($this->id != 0) {
            $this->modified    = JFactory::getDate()->toSql();
            $this->modified_by = JFactory::getUser()->id;
        }

        return parent::check();
    }
}