<?php
/**
 * @package    sponsorswall
 * @subpackage tmpl
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

AgmLibAdminBackend::load();

$user = JFactory::getUser();

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$field_columnwidth = JFormHelper::loadFieldType('SponsorswallColumnwidth', false);
?>

<div class="row-fluid">
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
		<?php echo AgmLibAdminInfopanel::render('com_sponsorswall'); ?>
    </div>
    <div id="j-main-container" class="span10">
        <form action="<?php echo JRoute::_('index.php?option=com_sponsorswall&view=columnwidths'); ?>" method="post"
              name="adminForm" id="adminForm">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
            ?>
            <?php if (empty($this->items)) : ?>
                <div class="alert alert-no-items">
                    <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                </div>
            <?php else : ?>
                <table id="sponsorsList" class="table table-striped table-hover">
                    <thead>
                    <tr>
                        <th>
                            <?php echo JText::_('COM_SPONSORSWALL_CATEGORY'); ?>
                        </th>
                        <th>
                            col_xs
                        </th>
                        <th>
                            col_sm
                        </th>
                        <th>
                            col_md
                        </th>
                        <th>
                            col_lg
                        </th>
                    </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <td colspan="6">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                    </tfoot>
                    <tbody>
                    <?php foreach ($this->items as $i => $item) :
//                        $canEdit    = $user->authorise('core.edit',       'com_sponsorswall.category.' . $item->cid);
                        $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $user->get('id') || $item->checked_out == 0;
                        $canChange = $user->authorise('core.edit.state', 'com_sponsorswall') && $canCheckin;
                        ?>

                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="1">
                            <td><?php echo $this->escape($item->title); ?></td>
                            <td>
                                <?php
                                $value_xs = (!empty($item->col_widths)) ? $item->col_widths['col_xs'] : 0;
                                if ($item->level > 1) :
                                    echo JHtml::_('select.genericlist', $field_columnwidth->getOptions(), 'jform[' . $item->id . '][col_xs]', '', 'value', 'text', $value_xs, 'id');
                                endif;
                                ?>
                            </td>
                            <td>
                                <?php
                                $value_sm = (!empty($item->col_widths)) ? $item->col_widths['col_sm'] : 0;
                                if ($item->level > 1) :
                                    echo JHtml::_('select.genericlist', $field_columnwidth->getOptions(), 'jform[' . $item->id . '][col_sm]', '', 'value', 'text', $value_sm, 'id');
                                endif;
                                ?>
                            </td>
                            <td>
                                <?php
                                $value_md = (!empty($item->col_widths)) ? $item->col_widths['col_md'] : 0;
                                if ($item->level > 1) :
                                    echo JHtml::_('select.genericlist', $field_columnwidth->getOptions(), 'jform[' . $item->id . '][col_md]', '', 'value', 'text', $value_md, 'id');
                                endif;
                                ?>
                            </td>
                            <td>
                                <?php
                                $value_lg = (!empty($item->col_widths)) ? $item->col_widths['col_lg'] : 0;
                                if ($item->level > 1) :
                                    echo JHtml::_('select.genericlist', $field_columnwidth->getOptions(), 'jform[' . $item->id . '][col_lg]', '', 'value', 'text', $value_lg, 'id');
                                endif;
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
            
            <div>
                <input type="hidden" name="task" value=""/>
                <input type="hidden" name="boxchecked" value="0"/>
                <?php echo JHtml::_('form.token'); ?>
            </div>
        </form>
    </div>
</div>