<?php
/**
 * @package    sponsorswall
 * @subpackage views
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * HTML View class for the Sponsorswall Component.
 *
 * @package    Columnwidths
 * @subpackage Views
 * @since 1.0.0
 */
class SponsorswallViewColumnwidths extends JViewLegacy
{
    public $sidebar;
    public $categories;
    public $items;
    public $state;
    public $pagination;
    public $filterForm;
    public $activeFilters;

    protected $canDo;

    public function display($tpl = null)
    {
        //+++++++++++++++++++++++++++++++++++
        //+ ACCESS CHECK
        //+++++++++++++++++++++++++++++++++++
        $this->canDo = JHelperContent::getActions('com_sponsorswall');

        if (!$this->canDo->get('core.create')
            && !$this->canDo->get('core.edit')
            && !$this->canDo->get('core.delete')
            && !$this->canDo->get('core.edit.own')
        ) {
            JToolBarHelper::title(JText::_('COM_SPONSORSWALL_ACCESS_DENIED'));
            // Add Back button
            $button  = '<div class="btn-group">
			          <button type="button" class="btn btn-default" aria-haspopup="true" aria-expanded="false" onclick="location.href=\'' . JRoute::_('index.php?option=com_sponsorswall') . '\'">
			            <span class="icon-arrow-left-4"></span> ' . JText::_('COM_SPONSORSWALL_SIDEBAR_BACK') . '
			          </button>';
            $toolbar = JToolbar::getInstance();
            $toolbar->appendButton('Custom', $button);

            JError::raiseError(403, 'Du hast nicht die erfordeliche Berechtigung. Kontaktiere bitte einen Administrator.');
            return false;
            //throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        //+++++++++++++++++++++++++++++++++++
        //+ ACCESS GRANTED
        //+++++++++++++++++++++++++++++++++++
        $this->categories    = $this->get('CategoryOrders');
        $this->items         = $this->get('Items');
        $this->pagination    = $this->get('Pagination');
        $this->state         = $this->get('State');
        $this->filterForm    = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

        //Sidebar
        SponsorswallHelper::addSubmenu('columnwidths');
        $this->sidebar = AgmLibAdminSidebar::render('com_sponsorswall');

        $this->addToolbar();

        // Auf Fehler prüfen
        $errors = $this->get('Errors');

        if (count($errors)) {
            JError::raiseError(500, implode('<br />', $errors));

            return false;
        }

        parent::display($tpl);
    }

    protected function addToolbar()
    {
        JToolBarHelper::title(JText::_('COM_SPONSORSWALL_ADMIN'));

        $user = JFactory::getUser();
        if (count($user->getAuthorisedCategories('com_sponsorswall', 'core.create')) > 0
            || $this->canDo->get('core.edit')
            || $this->canDo->get('core.edit.state')
        ) {
            JToolBarHelper::apply('columnwidths.save');
        }

        if ($user->authorise('core.admin', 'com_sponsorswall') || $user->authorise('core.options', 'com_sponsorswall')) {
            JToolbarHelper::preferences('com_sponsorswall');
        }
    } // function toolbar / end
}
