<?php
/**
 * @package    sponsorswall
 * @subpackage views
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

/**
 * HTML View class for the Sponsorswall Component.
 *
 * @package    Sponsors
 * @subpackage Views
 * @since 1.0.0
 */
class SponsorswallViewSponsor extends JViewLegacy
{
    protected $item;
    protected $canDo;

    public function display($tpl = null)
    {
        //+++++++++++++++++++++++++++++++++++
        //+ ACCESS CHECK
        //+++++++++++++++++++++++++++++++++++
        $this->canDo = JHelperContent::getActions('com_sponsorswall');

        if (!$this->canDo->get('core.create')
            && !$this->canDo->get('core.edit')
            && !$this->canDo->get('core.delete')
            && !$this->canDo->get('core.edit.own')
        ) {
            JToolBarHelper::title(JText::_('COM_SPONSORSWALL_ACCESS_DENIED'));
            // Add Back button
            $button  = '<div class="btn-group">
			          <button type="button" class="btn btn-default" aria-haspopup="true" aria-expanded="false" onclick="location.href=\'' . JRoute::_('index.php?option=com_sponsorswall') . '\'">
			            <span class="icon-arrow-left-4"></span> ' . JText::_('COM_SPONSORSWALL_SIDEBAR_BACK') . '
			          </button>';
            $toolbar = JToolbar::getInstance();
            $toolbar->appendButton('Custom', $button);

            JError::raiseError(403, 'Du hast nicht die erfordeliche Berechtigung. Kontaktiere bitte einen Administrator.');
            return false;
            //throw new JAccessExceptionNotallowed(JText::_('JERROR_ALERTNOAUTHOR'), 403);
        }

        //+++++++++++++++++++++++++++++++++++
        //+ ACCESS GRANTED
        //+++++++++++++++++++++++++++++++++++
        JFactory::getApplication()->input->set('hidemainmenu', true);

        $this->form = $this->get('Form');
        $this->item = $this->get('Item');

        $this->addToolbar();
        parent::display($tpl);
    }

    protected function addToolbar()
    {
        if ($this->item->id == 0) {
            JToolBarHelper::title(JText::_('COM_SPONSORSWALL_SPONSOR_NEW'));
        } else {
            JToolBarHelper::title(JText::_('COM_SPONSORSWALL_SPONSOR_CHANGE'));
        }

        JToolBarHelper::apply('sponsor.apply');
        JToolBarHelper::save('sponsor.save');
        JToolBarHelper::save2copy('sponsor.save2copy');
        JToolBarHelper::save2new('sponsor.save2new');
        JToolBarHelper::cancel('sponsor.cancel', 'JTOOLBAR_CANCEL');
    }
}