<?php
/**
 * @package    sponsorswall
 * @subpackage tmpl
 * @author     Alexander Grözinger {@link http://www.agmedia.de}
 * @author     Created on Mar-2018
 * @license    GNU/GPL
 * @copyright  AGMedia.de
 */
/*
   _   ___ __  __        _ _           _
  /_\ / __|  \/  |___ __| (_)__ _   __| |___
 / _ \ (_ | |\/| / -_) _` | / _` |_/ _` / -_)
/_/ \_\___|_|  |_\___\__,_|_\__,_(_)__,_\___|
*/

// No direct access to this file
defined('_JEXEC') or die(';-)');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user = JFactory::getUser();

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn  = $this->escape($this->state->get('list.direction'));

$saveOrder = $listOrder == 'ordering';
if ($saveOrder) {
    $saveOrderingUrl = 'index.php?option=com_sponsorswall&task=sponsors.saveOrderAjax&tmpl=component';
    JHtml::_('sortablelist.sortable', 'sponsorsList', 'adminForm', strtolower($listDirn), $saveOrderingUrl);
}
$sortFields = $this->getSortFields();
?>

<script type="text/javascript">
    Joomla!.orderTable = function () {
        var table = document.getElementById("sortTable");
        var direction = document.getElementById("directionTable");
        var order = table.options[table.selectedIndex].value;
        var dirn = '';

        if (order != '<?php echo $listOrder; ?>') {
            dirn = 'asc';
        }
        else {
            dirn = direction.options[direction.selectedIndex].value;
        }
        Joomla
        !
        .
        tableOrdering(order, dirn, '');
    }
</script>

<div class="row-fluid">
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
		<?php echo AgmLibAdminInfopanel::render('com_sponsorswall'); ?>
    </div>
    <div id="j-main-container" class="span10">
        <form action="<?php echo JRoute::_('index.php?option=com_sponsorswall&view=sponsors'); ?>" method="post"
              name="adminForm" id="adminForm">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this));
            ?>
            <?php if (empty($this->items)) : ?>
                <div class="alert alert-no-items">
                    <?php echo JText::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
                </div>
            <?php else : ?>
                <table id="sponsorsList" class="table table-striped table-hover">
                    <thead>
                    <tr>
                        <th width="1%" class="nowrap center hidden-phone">
                            <?php echo JHtml::_('searchtools.sort', '', 'ordering', $listDirn, $listOrder, null, 'asc', 'JGRID_HEADING_ORDERING', 'icon-menu-2'); ?>
                        </th>
                        <th width="1%" class="center">
                            <?php echo JHtml::_('grid.checkall'); ?>
                        </th>
                        <th class="center" width="5%">
                            <?php echo JHtml::_('searchtools.sort', 'JSTATUS', 'state', $listDirn, $listOrder); ?>
                        </th>
                        <th width="20%">
                            <?php echo JHtml::_('searchtools.sort', 'COM_SPONSORSWALL_NAME', 'name', $listDirn, $listOrder); ?>
                        </th>
                        <th>
                            <?php echo JHtml::_('searchtools.sort', 'COM_SPONSORSWALL_CATEGORY', 'category_name', $listDirn, $listOrder); ?>
                        </th>
                        <th>
                            <?php echo JHtml::_('searchtools.sort', 'COM_SPONSORSWALL_IMAGE', 'image', $listDirn, $listOrder); ?>
                        </th>
                        <th class="center">
                            <?php echo JHtml::_('searchtools.sort', 'COM_SPONSORSWALL_CLICKS', 'clicks', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                    </thead>
                    <tfoot>
                    <tr>
                        <td colspan="7">
                            <?php echo $this->pagination->getListFooter(); ?>
                        </td>
                    </tr>
                    </tfoot>
                    <tbody>
                    <?php foreach ($this->items as $i => $item) :
                        $canEdit = $user->authorise('core.edit', 'com_sponsorswall.category.' . $item->cid);
                        $canCheckin = $user->authorise('core.manage', 'com_checkin') || $item->checked_out == $user->get('id') || $item->checked_out == 0;
                        $canChange = $user->authorise('core.edit.state', 'com_sponsorswall') && $canCheckin;
                        ?>

                        <tr class="row<?php echo $i % 2; ?>" sortable-group-id="1">
                            <td class="order nowrap center hidden-phone">
                                <?php
                                $iconClass = '';

                                if (!$canChange) {
                                    $iconClass = ' inactive';
                                } elseif (!$saveOrder) {
                                    $iconClass = ' inactive tip-top hasTooltip" title="' . JHtml::_('tooltipText', 'JORDERINGDISABLED');
                                }
                                ?>
                                <span class="sortable-handler <?php echo $iconClass ?>">
									<span class="icon-menu" aria-hidden="true"></span>
								</span>
                                <?php if ($canChange && $saveOrder) : ?>
                                    <input type="text" style="display:none" name="order[]" size="5"
                                           value="<?php echo $item->ordering; ?>" class="width-20 text-area-order"/>
                                <?php endif; ?>
                            </td>
                            <td class="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
                            <td class="center">
                                <div class="btn-group">
                                    <?php echo JHtml::_('jgrid.published', $item->state, $i, 'sponsors.', $canChange, 'cb', $item->publish_up, $item->publish_down); ?>
                                    <?php // Create dropdown items and render the dropdown list.
                                    if ($canChange) {
                                        //JHtml::_('actionsdropdown.' . ((int) $item->state === 2 ? 'un' : '') . 'archive', 'cb' . $i, 'sponsors');
                                        JHtml::_('actionsdropdown.' . ((int)$item->state === -2 ? 'un' : '') . 'trash', 'cb' . $i, 'sponsors');
                                        echo JHtml::_('actionsdropdown.render', $this->escape($item->name));
                                    }
                                    ?>
                                </div>
                            </td>
                            <td class="has-context">
                                <div class="">
                                    <?php if ($item->checked_out) : ?>
                                        <?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'sponsors.', $canCheckin); ?>
                                    <?php endif; ?>
                                    <?php if ($canEdit) : ?>
                                        <a href="<?php echo JRoute::_('index.php?option=com_sponsorswall&task=sponsor.edit&id=' . (int)$item->id); ?>">
                                            <?php echo $this->escape($item->name); ?></a>
                                    <?php else : ?>
                                        <?php echo $this->escape($item->name); ?>
                                    <?php endif; ?>
                                    <div class="small">
                                        <?php echo JText::_('JCATEGORY') . ': ' . $this->escape($item->category_name); ?>
                                    </div>
                                </div>
                            </td>

                            <td><?php echo $this->escape($item->category_name); ?></td>
                            <td><?php echo $this->escape($item->image); ?></td>
                            <td class="center"><?php echo $this->escape($item->clicks); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
            
	        <div>
	            <input type="hidden" name="task" value=""/>
	            <input type="hidden" name="boxchecked" value="0"/>
	            <?php echo JHtml::_('form.token'); ?>
	        </div>
        </form>
    </div>
</div>