<?php

    /**
     * JCH Optimize - Performs several front-end optimizations for fast downloads
     *
     * @package   jchoptimize/joomla-platform
     * @author    Samuel Marshall <samuel@jch-optimize.net>
     * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
     * @license   GNU/GPLv3, or later. See LICENSE file
     *
     * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
     */

    use Joomla\CMS\HTML\HTMLHelper;

    defined( '_JEXEC' ) or die( 'Restricted Access' );

    $options = [
        'orderFieldSelector' => '#list_fullordering',
        'limitFieldSelector' => '#list_limit',
        'searchBtnSelector' => '.filter-search-bar__button',
        'filtersHidden' => $filtersHidden
    ];

    HTMLHelper::_( 'searchtools.form', '#adminForm', $options );

use function _JchOptimizeVendor\e;

?>

<?php if(!JCH_PRO): ?>
    <script>
        document.querySelector('#toolbar-share button.button-share').disabled = true;
    </script>
<?php endif; ?>

<?php if(version_compare(JVERSION, '3.999.999', 'le')): ?>
    <?php echo $__env->make('navigation', \_JchOptimizeVendor\Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>



<?php if(version_compare(JVERSION, '4', 'lt')): ?>
    <?php echo $__env->make('page_cache_j3', \_JchOptimizeVendor\Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('page_cache_j4', \_JchOptimizeVendor\Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

<?php $__env->startSection('browse-table-body-withrecords'); ?>
    
    <?php $i = 0; ?>
    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td>
                <input type="checkbox" id="cb<?php echo e($i++); ?>" name="cid[]" value="<?php echo e($item['id']); ?>"
                       onclick="Joomla.isChecked(this.checked)" class="form-check-input">
            </td>
            <td>
                <?php echo e(date('l, F d, Y h:i:s A', $item['mtime'])); ?> GMT
            </td>
            <td>
                <a title="<?php echo e($item['url']); ?>" href="<?php echo e($item['url']); ?>" class="page-cache-url" target="_blank"><?php echo e($item['url']); ?></a>
            </td>
            <td style="text-align: center;">
                <?php if($item['device'] == 'Desktop'): ?>
                    <span class="fa fa-desktop" data-bs-toggle="tooltip" title="<?php echo e($item['device']); ?>"></span>
                <?php else: ?>
                    <span class="fa fa-mobile-alt" data-bs-toggle="tooltip" title="<?php echo e($item['device']); ?>"></span>
                <?php endif; ?>
            </td>
            <td>
                <?php echo e($item['adapter']); ?>

            </td>
            <td style="text-align: center;">
                <?php if($item['http-request'] == 'yes'): ?>
                    <span class="fa fa-check-circle" style="color: green;"></span>
                <?php else: ?>
                    <span class="fa fa-times-circle" style="color: firebrick;"></span>
                <?php endif; ?>
            </td>
            <td class="hidden-phone hidden-tablet d-none d-sm-none d-md-none d-lg-none d-xl-none d-xxl-table-cell">
                <span class="page-cache-id"><?php echo e($item['id']); ?></span>
            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('browse-table-footer'); ?>
    <tr>
        <td colspan="99">

            <?php if($paginator->pageCount > 1 ): ?>
                <nav aria-label="pagination" class="pagination justify-content-center" style="text-align: center;">
                    <ul class="pagination justify-content-center">
                        
                        <?php if(isset($paginator->previous)): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($pageLink); ?>&list_page=<?php echo e($paginator->first); ?>">Start</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link"
                                   href="<?php echo e($pageLink); ?>&list_page=<?php echo e($paginator->previous); ?>">Previous</a>
                            </li>
                        <?php else: ?>
                            <li class="page-item disabled">
                                <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Start</a>
                            </li>

                            <li class="page-item disabled">
                                <a class="page-link" href="#" tabindex="-1" aria-disabled="true">Previous</a>
                            </li>
                        <?php endif; ?>

                        
                        <?php $__currentLoopData = $paginator->pagesInRange; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page != $paginator->current): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($pageLink); ?>&list_page=<?php echo e($page); ?>"><?php echo e($page); ?></a>
                                </li>
                            <?php else: ?>
                                <li class="page-item active" aria-current="page">
                                    <a class="page-link" href="<?php echo e($pageLink); ?>&list_page=<?php echo e($page); ?>"><?php echo e($page); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php if(isset($paginator->next)): ?>
                            <li class="page-item">
                                <a class="page-link" href="<?php echo e($pageLink); ?>&list_page=<?php echo e($paginator->next); ?>">Next</a>
                            </li>
                            <li class="page-item">
                                <a class="page-link"
                                   href="<?php echo e($pageLink); ?>&list_page=<?php echo e($paginator->last); ?>">End</a>
                            </li>
                        <?php else: ?>
                            <li class="page-item disabled">
                                <a class="page-link" href="#">Next</a>
                            </li>
                            <li class="page-item disabled">
                                <a class="page-link" href="#">End</a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>

            <?php endif; ?>

        </td>
    </tr>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('browse-hidden-fields'); ?>
    
    <input type="hidden" name="option" id="option" value="com_jchoptimize"/>
    <input type="hidden" name="view" id="view" value="PageCache"/>
    <input type="hidden" name="task" id="task" value=""/>
    <?php echo HTMLHelper::_('form.token'); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('browse', \_JchOptimizeVendor\Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /NAS3/vhosts/GY23731/golfdethumeries.fr/public_www/administrator/components/com_jchoptimize/lib/tmpl/page_cache.blade.php ENDPATH**/ ?>