<?php

/**
 * JCH Optimize - Performs several front-end optimizations for fast downloads
 *
 * @package   jchoptimize/joomla-platform
 * @author    Samuel Marshall <samuel@jch-optimize.net>
 * @copyright Copyright (c) 2020 Samuel Marshall / JCH Optimize
 * @license   GNU/GPLv3, or later. See LICENSE file
 *
 * If LICENSE file missing, see <http://www.gnu.org/licenses/>.
 */

use Joomla\CMS\Language\Text;

defined( '_JEXEC' ) or die( 'Restricted Access' );

use function _JchOptimizeVendor\e;

?>

<ul class="nav nav-tabs">
    <li class="nav-item <?php echo $view == 'ControlPanel' ? 'active': '' ?>">
        <a class="nav-link <?php echo $view == 'ControlPanel' ? 'active': '' ?>" href="index.php?option=com_jchoptimize">
            <?php echo e(Text::_('COM_JCHOPTIMIZE_TOOLBAR_LABEL_CONTROLPANEL')); ?>

        </a>
    </li>
    <li class="nav-item <?php echo $view == 'OptimizeImages' ? 'active': '' ?>">
        <a class="nav-link <?php echo $view == 'OptimizeImages' ? 'active': '' ?>" href="index.php?option=com_jchoptimize&amp;view=OptimizeImages">
            <?php echo e(Text::_('COM_JCHOPTIMIZE_TOOLBAR_LABEL_OPTIMIZEIMAGE')); ?>

        </a>
    </li>
    <li class="nav-item <?php echo $view == 'PageCache' ? 'active': '' ?>">
        <a class="nav-link <?php echo $view == 'PageCache' ? 'active' : '' ?>" href="index.php?option=com_jchoptimize&amp;view=PageCache">
            <?php echo e(Text::_('COM_JCHOPTIMIZE_TOOLBAR_LABEL_PAGECACHE')); ?>

        </a>
    </li>
</ul>

<?php /**PATH /NAS3/vhosts/GY23731/golfdethumeries.fr/public_www/administrator/components/com_jchoptimize/lib/tmpl/navigation.blade.php ENDPATH**/ ?>