<?php
return [
    '@class' => 'Gantry\\Component\\File\\CompiledYamlFile',
    'filename' => '/home/golfdeg/www/templates/g5_helium/custom/particles/accordion_overlay.yaml',
    'modified' => 1703787794,
    'data' => [
        'name' => 'Accordion_Overlay',
        'description' => 'Accordion_Overlay.',
        'type' => 'particle',
        'icon' => 'fa-file-image-o',
        'form' => [
            'fields' => [
                'enabled' => [
                    'type' => 'input.checkbox',
                    'label' => 'Enabled',
                    'description' => 'Globally enable to the particles.',
                    'default' => true
                ],
                'image' => [
                    'type' => 'input.imagepicker',
                    'label' => 'Image',
                    'description' => 'Select the main image.'
                ],
                'mode' => [
                    'type' => 'select.selectize',
                    'label' => 'Overlay mode',
                    'description' => 'Select overlay mode.',
                    'default' => 'uk-overlay',
                    'options' => [
                        'uk-overlay' => 'Default overlay',
                        'uk-overlay-hover' => 'Overlay on hover',
                        'uk-overlay-icon' => 'Overlay icon',
                        'uk-overlay-image' => 'Overlay image'
                    ]
                ],
                'position' => [
                    'type' => 'select.selectize',
                    'label' => 'Overlay position',
                    'description' => 'Select overlay position.',
                    'default' => 'default',
                    'options' => [
                        'default' => 'Default',
                        'uk-overlay-top' => 'Top',
                        'uk-overlay-bottom' => 'Bottom',
                        'uk-overlay-left' => 'Left',
                        'uk-overlay-right' => 'Right'
                    ]
                ],
                'position2' => [
                    'type' => 'select.selectize',
                    'label' => 'Overlay position2',
                    'description' => 'Select overlay position.',
                    'default' => 'default',
                    'options' => [
                        'default' => 'Default',
                        'uk-overlay-top' => 'Top',
                        'uk-overlay-bottom' => 'Bottom',
                        'uk-overlay-left' => 'Left',
                        'uk-overlay-right' => 'Right'
                    ]
                ],
                'transition' => [
                    'type' => 'select.selectize',
                    'label' => 'Overlay transitions',
                    'description' => 'Select overlay transitions (Only work on Overlay hover mode).',
                    'default' => 'none',
                    'options' => [
                        'none' => 'None',
                        'uk-overlay-slide-top' => 'Slide Top',
                        'uk-overlay-slide-bottom' => 'Slide Bottom',
                        'uk-overlay-slide-left' => 'Slide Left',
                        'uk-overlay-slide-right' => 'Slide Right',
                        'uk-overlay-fade' => 'Fade',
                        'uk-overlay-scale' => 'Scale',
                        'uk-overlay-spin' => 'Spin',
                        'uk-overlay-grayscale' => 'Grayscale'
                    ]
                ],
                'background' => [
                    'type' => 'input.checkbox',
                    'label' => 'Overlay background',
                    'description' => 'Enable background overlay.',
                    'default' => true
                ],
                'image2' => [
                    'type' => 'input.imagepicker',
                    'label' => 'Overlay Image',
                    'description' => 'Select the image for Overlay image mode.'
                ],
                'text' => [
                    'type' => 'textarea.textarea',
                    'label' => 'Text de gauche',
                    'description' => 'Customize the text (custom HTML).'
                ],
                'moduleId' => [
                    'type' => 'input.number',
                    'label' => 'ModuleId à afficher',
                    'description' => 'Customize the text (custom HTML).'
                ],
                'collapse' => [
                    'type' => 'input.checkbox',
                    'label' => 'Collapse',
                    'description' => 'Disable multiple open items.',
                    'default' => true
                ],
                'showfirst' => [
                    'type' => 'input.checkbox',
                    'label' => 'Show first',
                    'description' => 'Open the first item.',
                    'default' => true
                ],
                'animation' => [
                    'type' => 'select.select',
                    'label' => 'Animation',
                    'description' => 'Select the animation.',
                    'options' => [
                        '' => 'None',
                        'uk-animation-fade' => 'Fade',
                        'uk-animation-scale-up' => 'Scale Up',
                        'uk-animation-scale-down' => 'Scale Down',
                        'uk-animation-slide-top' => 'Slide In Top',
                        'uk-animation-slide-bottom' => 'Slide In Bottom',
                        'uk-animation-slide-left' => 'Slide In Left',
                        'uk-animation-slide-right' => 'Slide In Right',
                        'uk-animation-shake' => 'Shake',
                        'uk-animation-scale' => 'Scale'
                    ]
                ],
                'duration' => [
                    'type' => 'input.number',
                    'label' => 'Duration',
                    'description' => 'Animation duration (millisecond)',
                    'default' => 500
                ],
                'iconposition' => [
                    'type' => 'select.selectize',
                    'label' => 'Icon position',
                    'default' => 'left',
                    'description' => 'Select the icon position.',
                    'options' => [
                        'left' => 'Left',
                        'right' => 'Right'
                    ]
                ],
                'clsactive' => [
                    'type' => 'input.selectize',
                    'label' => 'Class Active',
                    'description' => 'Class to add when an item is active.'
                ],
                'accordion' => [
                    'type' => 'collection.list',
                    'array' => true,
                    'label' => 'List items',
                    'description' => 'Create a list of items.',
                    'value' => 'name',
                    'ajax' => true,
                    'fields' => [
                        '.openicon' => [
                            'type' => 'input.icon',
                            'label' => 'Open icon',
                            'description' => 'Choose the open icon.',
                            'default' => 'fa fa-minus'
                        ],
                        '.closeicon' => [
                            'type' => 'input.icon',
                            'label' => 'Close icon',
                            'description' => 'Choose the close icon.',
                            'default' => 'fa fa-plus'
                        ],
                        '.title' => [
                            'type' => 'input.text',
                            'label' => 'Item Title',
                            'description' => 'Customize the title of item.'
                        ],
                        '.content' => [
                            'type' => 'textarea.textarea',
                            'label' => 'Item Content',
                            'description' => 'Customize the content of item.'
                        ]
                    ]
                ],
                'class' => [
                    'type' => 'input.selectize',
                    'label' => 'CSS Classes',
                    'description' => 'CSS class name for the particle.'
                ],
                'copyright' => [
                    'type' => 'separator.note',
                    'class' => 'alert alert-info',
                    'content' => 'Developed and maintained by <a href="https://www.joomlead.com/" target="_blank">JoomLead.com</a><br><strong>Version: 1.0.1</strong>'
                ]
            ]
        ]
    ]
];
