<?php
/*------------------------------------------------------------------------
# manage.html.php - Ossolution Services Booking
# ------------------------------------------------------------------------
# author    Ossolution team
# copyright Copyright (C) 2018 joomdonation.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.joomdonation.com
# Technical Support:  Forum - http://www.joomdonation.com/forum.html
*/

// No direct access.
defined('_JEXEC') or die;
class HTML_OSappscheduleManage
{
    static function listOrders($rows,$lists,$pageNav)
	{
		global $mainframe,$mapClass,$configClass,$jinput;
        $db = JFactory::getDbo();
		?>
		<div class="<?php echo $mapClass['row-fluid'];?> manageorders">
			<div class="<?php echo $mapClass['span4'];?>">
				<div class="page-header">
					<h1><?php echo JText::_('OS_MANAGE_ORDERS');?></h1>
				</div>
			</div>
			<div class="<?php echo $mapClass['span8'];?> pull-right alignright" style="margin-top:15px;">
                <a class="btn btn-success" title="<?php echo JText::_('OS_ADD_ORDER')?>" href="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_editorder"/><?php echo JText::_('OS_ADD_ORDER')?></a>
                <input type="button" class="btn btn-info" value="<?php echo JText::_('OS_EXPORT_SELECTED_ORDERS')?>" title="<?php echo JText::_('OS_EXPORT_SELECTED_ORDERS')?>" onclick="javascript:exportSelectedOrders()"/>
                <input type="button" class="btn btn-info" value="<?php echo JText::_('OS_EXPORT_CSV')?>" title="<?php echo JText::_('OS_EXPORT_CSV')?>" onclick="javascript:exportCsv()"/>
                <input type="button" class="btn btn-info" value="<?php echo JText::_('OS_EXPORT_INVOICE')?>" title="<?php echo JText::_('OS_EXPORT_INVOICE')?>" onclick="javascript:exportInvoice()"/>
				<input type="button" class="btn btn-danger" value="<?php echo JText::_('OS_REMOVE_ORDER')?>" title="<?php echo JText::_('OS_REMOVE_ORDER')?>" onclick="javascript:removeOrders()"/>
				<input type="button" class="btn btn-warning" value="<?php echo JText::_('OS_BACK')?>" title="<?php echo JText::_('OS_GO_BACK')?>" onclick="javascript:history.go(-1);"/>
			</div>
		</div>
		<form method="POST" action="<?php echo Jroute::_('index.php?option=com_osservicesbooking&view=manageallorders&Itemid='.$jinput->getInt('Itemid',0));?>" name="ftForm" id="ftForm">
			<div class="<?php echo $mapClass['row-fluid'];?>">
				<div class="<?php echo $mapClass['span12'];?> pull-right">
					<strong><?php echo JText::_('OS_FILTER')?>:</strong>
					<?php echo $lists['filter_venue']; ?>
					<?php echo $lists['filter_service']; ?>
					<?php echo $lists['filter_employee']; ?>
					<?php echo $lists['filter_status']; ?>
					<?php echo JHtml::_('calendar',$lists['filter_date_from'],'filter_date_from','filter_date_from','%Y-%m-%d',array('placeholder' => JText::_('OS_FROM'),'onchange' => '', 'class' => 'input-small'));?>
					<?php echo JHtml::_('calendar',$lists['filter_date_to'],'filter_date_to','filter_date_to','%Y-%m-%d',array('placeholder' => JText::_('OS_TO'),'', 'class' => 'input-small'))?>
                    <input type="text" class="input-medium" placeholder="<?php echo JText::_('OS_KEYWORD');?>" name="keyword" id="keyword" value="<?php echo OSBHelper::getStringValue('keyword','');?>"/>
					<button class="btn hasTooltip" title="" type="submit" data-original-title="<?php echo JText::_('OS_SEARCH');?>">
						<i class="icon-search"></i>
					</button>
				</div>
			</div>
			<div class="<?php echo $mapClass['row-fluid'];?>">
				<div class="<?php echo $mapClass['span12'];?>">
					<?php 
					$optionArr = array();
					$statusArr = array(JText::_('OS_PENDING'),JText::_('OS_COMPLETED'),JText::_('OS_CANCELED'),JText::_('OS_ATTENDED'),JText::_('OS_TIMEOUT'),JText::_('OS_DECLINED'),JText::_('OS_REFUNDED'));
					$statusVarriableCode = array('P','S','C','A','T','D','R');
					for($j=0;$j<count($statusArr);$j++){
						$optionArr[] = JHtml::_('select.option',$statusVarriableCode[$j],$statusArr[$j]);				
					}
					if(count($rows) > 0)
					{
					?>
					<table class="adminlist table table-striped" width="100%">
						<thead>
							<tr>
								<th width="2%">
									<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
								</th>
								<th width="3%">
									ID
								</th>
								<th width="15%">
									<?php echo JText::_('OS_CUSTOMER_DETAILS');?>
								</th>
								<th width="45%">
									<?php echo JText::_('OS_DETAILS');?>
								</th>
								<?php
								if($configClass['disable_payments'] == 1){
								?>
									<th width="25%">
										<?php echo JText::_('OS_ORDER_PAYMENT');?>
									</th>
								<?php
								} 
								?>
                                <th width="7%">
                                </th>
							</tr>
						</thead>
						<?php
						if($configClass['disable_payments'] == 1)
						{
							$cols = 6;
						}
						else
						{
							$cols = 5;
						}
						?>
						<tfoot>
							<tr>
								<td width="100%" colspan="<?php echo $cols?>" style="text-align:center;">
									<?php
										echo $pageNav->getListFooter();
									?>
									
								</td>
							</tr>
						</tfoot>
						<tbody>
						<?php
						$k = 0;

						for ($i=0, $n=count($rows); $i < $n; $i++) 
						{
							$row = $rows[$i];
							$checked = JHtml::_('grid.id', $i, $row->id);
							$link 		= JRoute::_( 'index.php?option=com_osservicesbooking&task=default_orderDetailsForm&id='. $row->id.'&ref='.md5($row->id) );
							
							$db->setQuery("SELECT * FROM #__app_sch_order_items WHERE order_id = '$row->id'");
							$items = $db->loadObjectList();
							$servicesArr = array();
							for($j=0;$j<count($items);$j++)
							{
								$config = new JConfig();
								$offset = $config->offset;
								date_default_timezone_set($offset);	
								$item = $items[$j];
								$db->setQuery("Select * from #__app_sch_services where id = '$item->sid'");
								$s = $db->loadObject();
								$service_name = $s->service_name;
								$service_time_type = $s->service_time_type;
								
								$db->setQuery("Select id,employee_name from #__app_sch_employee where id = '$item->eid'");
								$employee_name = $db->loadObject();
								$employee_name = $employee_name->employee_name;
								$temp = $j + 1;
								$temp .= ". ".$service_name." [".date($configClass['date_format'],$item->start_time)." ".date($configClass['time_format'],$item->start_time)." - ".date($configClass['date_format'],$item->end_time)." ".date($configClass['time_format'],$item->end_time)."] ".JText::_('OS_EMPLOYEE').": ".$employee_name."";
								if($service_time_type == 1){
									$temp .= ". ".JText::_('OS_NUMBER_SLOT').": ".$item->nslots;
								}
								$servicesArr[] = $temp;
								
							}
							$service = implode("<BR />",$servicesArr);
							?>
							<tr class="<?php echo "row$k"; ?>">
								<td align="center"><?php echo $checked; ?></td>
								<td align="left"><a href="<?php echo $link; ?>"><?php echo str_pad($row->id,6,'000000',0); ?></a></td>
								<td align="left">
                                    <?php
                                    if($row->user_id > 0)
                                    {
                                        $link = JRoute::_('index.php?option=com_osservicesbooking&task=manage_userinfo&userId='.$row->user_id);
                                    }
                                    ?>
                                    <a href="<?php echo $link; ?>">
                                        <?php echo $row->order_name; ?>
                                    </a>
									<BR />
									<a href="mailto:<?php echo $row->order_email?>" target="_blank"><?php echo $row->order_email?></a></td>
								<td align="left" >
								<?php 
								echo "<span style='color:gray;'>".JText::_('OS_CURRENT_STATUS').": <strong>".OSBHelper::orderStatus(0,$row->order_status)."</strong>";
								?>
								<BR />
								<?php 
								echo JText::_('OS_ORDER_DATE')." <strong>".date($configClass["date_time_format"],strtotime($row->order_date));?></strong></span>
								<BR />
								<span style="font-size:11px;"><?php echo $service?></span></td>
								<?php
								if($configClass['disable_payments'] == 1){
								?>
									<td align="left" style="font-size:11px;">
									<?php
										echo JText::_('OS_TOTAL').": ".OSBHelper::showMoney($row->order_final_cost,1);
									?>
									<br />
									<?php
										echo JText::_('OS_DISCOUNT').": ".OSBHelper::showMoney($row->order_discount,1);
									?>
									<br />
									<?php
										echo JText::_('OS_DEPOSIT').": ".OSBHelper::showMoney($row->order_upfront,1);
									?>
									<br />
									<?php 
									$order_payment = $row->order_payment;
									if($order_payment != ""){
										echo Jtext::_('OS_PAYMENT')." <strong>".JText::_(os_payments::loadPaymentMethod($order_payment)->title)."</strong>";
									}
								}
								?></td>
                                    <td class="center">
                                        <a href="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_editorder&id=<?php echo $row->id;?>" title="<?php echo JText::_('OS_EDIT_ORDER');?>">
                                            <i class="fa fa-edit icon-edit"></i>
                                        </a>
                                        &nbsp;
                                        <a href="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_removeorders&cid[]=<?php echo $row->id;?>" title="<?php echo JText::_('OS_REMOVE_ORDER');?>">
                                            <i class="fa fa-remove icon-delete" title="<?php echo JText::_('OS_REMOVE_ORDER');?>"></i>
                                        </a>
                                    </td>
								<?php
								?>
								
							</tr>
						<?php
							$k = 1 - $k;	
						}
						?>
						</tbody>
					</table>
					<?php 
					}else{
						?>
						<div class="alert alert-no-items"><?php echo Jtext::_('OS_NO_MATCHING_RESULTS');?></div>
						<?php 
					}?>
					<input type="hidden" name="option" value="com_osservicesbooking" />
					<input type="hidden" name="task" id="task" value="manage_orders" />
					<input type="hidden" name="boxchecked" value="0" />
					<input type="hidden" name="live_site" id="live_site" value="<?php echo Juri::root();?>" />
					<input type="hidden" name="current_order_id" id="current_order_id" value="" />
					<input type="hidden" name="Itemid" value="<?php echo JFactory::getApplication()->input->getInt('Itemid',0); ?>" />
				</div>
			</div>
		</form>
        <script type="text/javascript">
            function exportInvoice()
            {
                jQuery("#task").val('manage_exportinvoice');
                document.ftForm.submit();
            }
            function exportSelectedOrders()
            {
				var flag = 0;
				for (var i = 0; i< <?php echo count($rows);?>; i++) 
				{
				  if(document.ftForm["cid[]"][i].checked)
				  {
						flag ++;
				  }
				}
				if (flag == 0) 
				{
					alert ("<?php echo JText::_('OS_NO_ORDERS_TO_EXPORT');?>");
					return false;
				}
				else
				{
					jQuery("#task").val('manage_exportSelectedOrders');
					document.ftForm.submit();
				}
            }
            function exportCsv()
            {
                jQuery("#task").val('manage_exportCsv');
                document.ftForm.submit();
            }
        </script>
		<?php
	}

    /**
     * @param $option
     * @param $row
     * @param $rows
     * @param $pageNav
     * @param $fields
     * @param $lists
     * @throws Exception
     */
    static function orders_detail($option,$row,$rows,$pageNav,$fields,$lists){
        global $mainframe,$configClass,$jinput,$mapClass;
        $config         = new JConfig();
        $offset         = $config->offset;
        date_default_timezone_set($offset);
        $mainframe 	    = JFactory::getApplication();
        $jinput->set( 'hidemainmenu', 1 );
        if ($row->id){
            $title      = ' ['.JText::_('OS_EDIT').']';
        }else{
            $title      = ' ['.JText::_('OS_NEW').']';
        }
        $document       = JFactory::getDocument();
        $document->setTitle(JText::_('OS_ORDER_DETAIL').$title);
        ?>
        <div class="<?php echo $mapClass['row-fluid'];?>">
            <div class="<?php echo $mapClass['span6'];?>">
                <div class="page-header">
                    <h1><?php echo JText::_('OS_ORDER_DETAIL').$title;?></h1>
                </div>
            </div>
            <div class="<?php echo $mapClass['span6'];?> pull-right alignright" style="margin-top:15px;">
                <input type="button" class="btn btn-warning" value="<?php echo JText::_('OS_SAVE')?>" title="<?php echo JText::_('OS_SAVE')?>" onclick="javascript:saveOrder(1);"/>
                <input type="button" class="btn btn-danger" value="<?php echo JText::_('OS_APPLY')?>" title="<?php echo JText::_('OS_APPLY')?>" onclick="javascript:saveOrder(0);"/>
                <input type="button" class="btn" value="<?php echo JText::_('OS_CANCEL')?>" title="<?php echo JText::_('OS_GO_BACK')?>" onclick="javascript:gotoOrdersList();"/>
            </div>
        </div>
        <?php
        if (version_compare(JVERSION, '3.5', 'ge')){
            ?>
			<script src="<?php echo JUri::root()?>media/com_osservicesbooking/assets/css/bootstrap/js/jquery.min.js" type="text/javascript"></script>
            <script src="<?php echo JUri::root()?>media/jui/js/fielduser.min.js" type="text/javascript"></script>
        <?php } ?>
        <form method="POST" action="<?php echo JUri::root(); ?>index.php?option=com_osservicesbooking&task=orders_detail&cid[]=<?php echo $row->id;?>" name="adminForm" id="adminForm" enctype="multipart/form-data">
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div style="width:100%;padding:20px;" class="<?php echo $mapClass['span12'];?> form-horizontal">
                    <fieldset>
                        <?php
                        if($row->id > 0){
                            ?>
                            <div class="<?php echo $mapClass['control-group'];?>">
                                <div class="<?php echo $mapClass['control-label'];?>">
                                    <label title="<?php echo JText::_( 'OS_ORDER_NUMBER' );?>::<?php echo JText::_('OS_ORDER_NUMBER_DESC'); ?>" class="hasTip" ><?php echo JText::_("OS_ORDER_NUMBER"); ?></label>
                                </div>
                                <div class="<?php echo $mapClass['controls'];?>">
                                    <span class="readonly"><?php echo str_pad($row->id,6,'000000',0); ?></span>
                                </div>
                            </div>
                            <?php
                        }
                        ?>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_CUSTOMER') ;?>" class="hasTip"><?php echo JText::_( 'OS_CUSTOMER') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <?php
                                //echo OSappscheduleOrders::getUserInput($row->user_id,$row->id);
                                ?>
                                <input class="input-small" disabled type="text" name="user_id" id="user_id" value="<?php echo $row->user_id?>" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_NAME') ;?>::<?php echo JText::_( 'OS_NAME_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_NAME') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-large" value="<?php echo $row->order_name; ?>" name="order_name" id="order_name" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_EMAIL') ;?>::<?php echo JText::_( 'OS_EMAIL_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_EMAIL') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-large" value="<?php echo $row->order_email; ?>" name="order_email" id="order_email" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_PHONE') ;?>::<?php echo JText::_( 'OS_PHONE_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_PHONE') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">

                                <input type="text" class="input-mini" value="<?php echo $row->dial_code; ?>" name="dial_code" />
                                <input type="text" class="input-small" value="<?php echo $row->order_phone; ?>" name="order_phone" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_COUNTRY') ;?>::<?php echo JText::_( 'OS_COUNTRY_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_COUNTRY') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <?php echo $lists['country'];?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_CITY') ;?>::<?php echo JText::_( 'OS_CITY_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_CITY') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-large" value="<?php echo $row->order_city; ?>" name="order_city" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_STATE') ;?>::<?php echo JText::_( 'OS_STATE_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_STATE') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-large" value="<?php echo $row->order_state; ?>" name="order_state" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_ZIP') ;?>::<?php echo JText::_( 'OS_ZIP_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_ZIP') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-mini" value="<?php echo $row->order_zip; ?>" name="order_zip" />
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_ADDRESS') ;?>::<?php echo JText::_( 'OS_ADDRESS_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_ADDRESS') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-large" value="<?php echo $row->order_address; ?>" name="order_address" />
                            </div>
                        </div>
                        <?php
                        $db = JFactory::getDbo();
                        $db->setQuery("Select * from #__app_sch_fields where field_area = '1' and published = '1'");
                        $fields = $db->loadObjectList();
                        if(count($fields) > 0){
                            for($i=0;$i<count($fields);$i++){
                                $field = $fields[$i];
                                ?>
                                <div class="<?php echo $mapClass['control-group'];?>">
                                    <div class="<?php echo $mapClass['control-label'];?>">
                                        <label title="<?php echo OSBHelper::getLanguageFieldValueOrder($field,'field_label',$row->order_lang); //$field->field_label ;?>" class="hasTip"><?php echo OSBHelper::getLanguageFieldValueOrder($field,'field_label',$row->order_lang); //$field->field_label;?></label>
                                    </div>
                                    <div class="<?php echo $mapClass['controls'];?>">
									<span class="readonly" style="font-weight:normal !important;">
										<?php
                                        OsAppscheduleDefault::orderField($field,$row->id);
                                        ?>
									</span>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_NOTES') ;?>" class="hasTip"><?php echo JText::_( 'OS_NOTES') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <textarea name="notes" class="input-medium"><?php echo $row->order_notes; ?></textarea>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_PAYMENT') ;?>::<?php echo JText::_( 'OS_PAYMENT_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_PAYMENT') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <?php
                                $order_payment = $row->order_payment;
                                echo $lists['payment'];
                                ?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_TOTAL') ;?>::<?php echo JText::_( 'OS_TOTAL_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_TOTAL') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-small" value="<?php echo $row->order_total; ?>" name="order_total" /> <?php echo $configClass['currency_format'];?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_DISCOUNT') ;?>" class="hasTip"><?php echo JText::_( 'OS_DISCOUNT') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-small" value="<?php echo $row->order_discount; ?>" name="order_discount" /> <?php echo $configClass['currency_format'];?>
                            </div>
                        </div>
                        <?php
                        if($configClass['enable_tax']==1){
                            ?>
                            <div class="<?php echo $mapClass['control-group'];?>">
                                <div class="<?php echo $mapClass['control-label'];?>">
                                    <label title="<?php echo JText::_( 'OS_TAX') ;?>::<?php echo JText::_( 'OS_TAX_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_TAX') ;?></label>
                                </div>
                                <div class="<?php echo $mapClass['controls'];?>">
                                    <input type="text" class="input-small" value="<?php echo $row->order_tax; ?>" name="order_tax" /> <?php echo $configClass['currency_format'];?>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_GROSS_AMOUNT') ;?>::<?php echo JText::_( 'OS_FINAL_COST_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_GROSS_AMOUNT') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-small" value="<?php echo $row->order_final_cost; ?>" name="order_final_cost" /> <?php echo $configClass['currency_format'];?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_UPFRONT') ;?>::<?php echo JText::_( 'OR_UPFRONT_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_UPFRONT') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <input type="text" class="input-small" value="<?php echo $row->order_upfront; ?>" name="order_upfront" /> <?php echo $configClass['currency_format'];?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_DATE') ;?>::<?php echo JText::_( 'OS_DATE_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_DATE') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <?php
                                echo JHTML::_('calendar',$row->order_date, 'order_date', 'order_date', '%Y-%m-%d', array('class'=>'input-medium', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;'));
                                ?>
                                <?php echo $lists['order_date_hour'] . ' ' . $lists['order_date_minute']; ?>
                            </div>
                        </div>
                        <div class="<?php echo $mapClass['control-group'];?>">
                            <div class="<?php echo $mapClass['control-label'];?>">
                                <label title="<?php echo JText::_( 'OS_STATUS') ;?>::<?php echo JText::_( 'OS_STATUS_DESC') ;?>" class="hasTip"><?php echo JText::_( 'OS_STATUS') ;?></label>
                            </div>
                            <div class="<?php echo $mapClass['controls'];?>">
                                <span class="readonly"> <?php echo $row->order_status_select_list; ?></span>
                            </div>
                        </div>
                    </fieldset>
                </div>
            </div>
            <?php

            if($row->id > 0){
                ?>
                <div class="<?php echo $mapClass['row-fluid'];?>">
                    <div class="<?php echo $mapClass['span12'];?> form-horizontal">
                        <fieldset>
                            <legend><?php echo JText::_('OS_SERVICELIST')?></legend>
                            <div class="navbar">
                                <div class="navbar-inner" style="text-align:right;">
                                    <a href="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_addservice&order_id=<?php echo $row->id?>" style="color:white;font-weight:bold;" class="btn btn-info"><?php echo JText::_('OS_ADD_SERVICES');?></a>
                                </div>
                            </div>
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th width="20" align="left">
                                        <?php echo JText::_( '#' ); ?>
                                    </th>
                                    <th class="title" width="15%">
                                        <?php echo JText::_('OS_SERVICES');?>
                                    </th>
                                    <th class="title" width="15%">
                                        <?php echo JText::_('OS_EMPLOYEE');?>
                                    </th>
                                    <th width="15%">
                                        <?php echo JText::_('OS_WORKTIME_START_TIME');?>
                                    </th>
                                    <th width="15%">
                                        <?php echo JText::_('OS_WORKTIME_END_TIME');?>
                                    </th>
                                    <th width="15%">
                                        <?php echo JText::_('OS_DATE');?>
                                    </th>
                                    <th width="25%">
                                        <?php echo JText::_('OS_OTHER_INFORMATION');?>
                                    </th>
                                    <th width="5%">
                                        <?php echo JText::_('OS_CHECKED_IN');?>
                                    </th>
                                    <th width="5%">
                                        <?php echo JText::_('OS_REMOVE');?>
                                    </th>
                                </tr>
                                </thead>
                                <tfoot>
                                <tr>
                                    <td colspan="9">
                                        <?php echo $pageNav->getListFooter(); ?>
                                    </td>
                                </tr>
                                </tfoot>
                                <tbody>
                                <?php
                                $config = new JConfig();
                                $offset = $config->offset;
                                date_default_timezone_set($offset);
                                $k = 0;
                                if( count( $rows ) ) {
                                    for ($i=0, $n=count( $rows ); $i < $n; $i++) {
                                        $item = &$rows[$i];
                                        ?>
                                        <tr class="<?php echo "row$k"; ?>">
                                            <td >
                                                <?php echo $pageNav->getRowOffset( $i ); ?>
                                            </td>
                                            <td style="padding-left:10px;text-align:left;"><?php echo $item->service_name?></td>
                                            <td style="padding-left:10px;text-align:left;"><?php echo $item->employee_name?></td>
                                            <td align="center"><?php echo date($configClass['time_format'],$item->start_time); ?></td>
                                            <td align="center"><?php echo date($configClass['time_format'],$item->end_time); ?></td>
                                            <td align="center"><?php echo date($configClass['date_format'],strtotime($item->booking_date)) ; ?></td>
                                            <td align="left">
                                                <?php
                                                if($item->service_time_type ==1){
                                                    echo JText::_('OS_NUMBER_SLOT').": ".$item->nslots."<BR />";
                                                }
                                                $db->setQuery("Select * from #__app_sch_fields where field_area = '0' and published = '1'");
                                                $fields = $db->loadObjectList();
                                                if(count($fields) > 0){
                                                    for($i1=0;$i1<count($fields);$i1++){
                                                        $field = $fields[$i1];
                                                        $db->setQuery("Select count(id) from #__app_sch_order_field_options where order_item_id = '$item->id' and field_id = '$field->id'");
                                                        $count = $db->loadResult();
                                                        if($count > 0){
                                                            if($field->field_type == 1){
                                                                $db->setQuery("Select option_id from #__app_sch_order_field_options where order_item_id = '$item->id' and field_id = '$field->id'");
                                                                $option_id = $db->loadResult();
                                                                $db->setQuery("Select * from #__app_sch_field_options where id = '$option_id'");
                                                                $optionvalue = $db->loadObject();
                                                                ?>
                                                                <?php echo $field->field_label;?>:
                                                                <?php
                                                                $field_data = $optionvalue->field_option;
                                                                if($optionvalue->additional_price > 0){
                                                                    $field_data.= " - ".$optionvalue->additional_price." ".$configClass['currency_format'];
                                                                }
                                                                echo $field_data;
                                                                echo "<BR />";
                                                            }elseif($field->field_type == 2){
                                                                $db->setQuery("Select option_id from #__app_sch_order_field_options where order_item_id = '$item->id' and field_id = '$field->id'");
                                                                $option_ids = $db->loadObjectList();
                                                                $fieldArr = array();
                                                                for($j=0;$j<count($option_ids);$j++){
                                                                    $oid = $option_ids[$j];
                                                                    $db->setQuery("Select * from #__app_sch_field_options where id = '$oid->option_id'");
                                                                    $optionvalue = $db->loadObject();
                                                                    $field_data = $optionvalue->field_option;
                                                                    if($optionvalue->additional_price > 0){
                                                                        $field_data.= " - ".$optionvalue->additional_price." ".$configClass['currency_format'];
                                                                    }
                                                                    $fieldArr[] = $field_data;
                                                                }
                                                                ?>
                                                                <?php echo $field->field_label;?>:
                                                                <?php
                                                                echo implode(", ",$fieldArr);
                                                                echo "<BR />";
                                                            }
                                                        }
                                                    }
                                                }
                                                ?>
                                            </td>
                                            <td width="10%" style="text-align:center;">
                                                <?php
                                                if($item->checked_in == 1){
                                                    ?>
                                                    <img src="<?php echo JURI::base()?>components/com_osservicesbooking/asset/images/publish.png" />
                                                    <?php
                                                }else{
                                                    ?>
                                                    <img src="<?php echo JURI::base()?>components/com_osservicesbooking/asset/images/unpublish.png" />
                                                    <?php
                                                }
                                                ?>
                                            </td>
                                            <td width="10%" style="text-align:center;">
                                                <a href="javascript:removeService(<?php echo $item->id?>,<?php echo $row->id?>);" title="<?php echo JText::_('OS_REMOVE_ORDER_ITEM');?>">
                                                    <img src="<?php echo JURI::base()?>components/com_osservicesbooking/asset/images/unpublish.png" />
                                                </a>
                                            </td>
                                        </tr>
                                    <?php }
                                }
                                ?>
                                </tbody>
                            </table>
                        </fieldset>
                    </div>
                </div>
                <?php
            }else{
                ?>
                <div class="<?php echo $mapClass['row-fluid'];?>">
                    <div class="<?php echo $mapClass['span12'];?> form-horizontal">
                        <fieldset>
                            <legend><?php echo JText::_('OS_SERVICELIST')?></legend>
                            <div class="alert alert-block alert-warning">
                                <h4><?php echo JText::_('OS_NOTICE')?></h4>
                                <?php
                                echo JText::_('OS_YOU_CAN_ONLY_ADD_SERVICES_AFTER_SAVING_ORDER_DETAILS');
                                ?>
                            </div>
                        </fieldset>
                    </div>
                </div>
                <?php
            }
            ?>
            <input type="hidden" name="option" value="<?php echo $option;?>" />
            <input type="hidden" name="task" id="task" value="orders_detail" />
            <input type="hidden" name="id" id="id" value="<?php echo $row->id?>" />
            <input type="hidden" name="old_status" value="<?php echo $row->order_status;?>" />
        </form>
        <script type="text/javascript">
            function removeService(id,order_id){
                var answer = confirm("<?php echo JText::_('OS_DO_YOU_WANT_TO_REMOVE_SERVICE')?>");
                if(answer == 1){
                    location.href = "index.php?option=com_osservicesbooking&task=manage_removeservice&id=" + id + "&order_id=" + order_id;
                }
            }

            var live_site = "<?php echo JUri::root(); ?>";
            function saveOrder(save){
                var answer = confirm("<?php echo JText::_('OS_SAVE_ORDER_QUESTION')?>");
                if(answer == 1){
                    if(save == "1") {
                        jQuery('#task').val('manage_saveorder');
                    }else{
                        jQuery('#task').val('manage_applyorder');
                    }
                    document.adminForm.submit();
                }
            }
            function gotoOrdersList(){
                location.href = "<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_orders";
            }
        </script>
        <?php
    }

    /**
     * Add Order item
     * @param $order_id
     * @param $lists
     * @param $show_date
     * @param $sid
     * @param $vid
     * @param $eid
     * @param $booking_date
     */
    static function addServicesForm($order_id,$lists,$show_date,$sid,$vid,$eid,$booking_date){
        global $mainframe,$configClass,$jinput,$mapClass;
        JHtml::_('behavior.multiselect');
        /*
        JToolBarHelper::title(JText::_('OS_ADD_ORDER_ITEM'),'order.png');
        JToolBarHelper::save('orders_saveservice');
        JToolBarHelper::cancel('orders_gotoorderdetails');
        JToolbarHelper::custom('cpanel_list','featured.png', 'featured_f2.png',JText::_('OS_DASHBOARD'),false);
        */
        $document = JFactory::getDocument();
        $document->setTitle(JText::_('OS_ADD_ORDER_ITEM'));
        ?>
        <div class="<?php echo $mapClass['row-fluid'];?>">
            <div class="<?php echo $mapClass['span6'];?>">
                <div class="page-header">
                    <h1><?php echo JText::_('OS_ADD_ORDER_ITEM');?></h1>
                </div>
            </div>
            <div class="<?php echo $mapClass['span6'];?> pull-right alignright" style="margin-top:15px;">
                <input type="button" class="btn btn-warning" value="<?php echo JText::_('OS_SAVE')?>" title="<?php echo JText::_('OS_SAVE')?>" onclick="javascript:saveOrderItem();"/>
                <input type="button" class="btn btn-danger" value="<?php echo JText::_('OS_GO_TO_ORDER_DETAILS')?>" title="<?php echo JText::_('OS_ADD_ORDER_ITEM')?>" onclick="javascript:gotoOrderDetails();"/>
                <input type="button" class="btn" value="<?php echo JText::_('OS_BACK')?>" title="<?php echo JText::_('OS_GO_BACK')?>" onclick="javascript:history.go(-1);"/>
            </div>
        </div>
        <form method="POST" action="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_addservice" name="adminForm" id="adminForm">
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div class="<?php echo $mapClass['span2'];?> boldtext">
                    <?php echo JText::_('OS_FILTER_EMPLOYEE_FOR_SERVICE');?>
                </div>
                <div class="<?php echo $mapClass['span10'];?>">
                    <?php echo $lists['services'];?>
                </div>
            </div>
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div class="<?php echo $mapClass['span2'];?> boldtext">
                    <?php echo JText::_('OS_SELECT_VENUE');?>
                </div>
                <div class="<?php echo $mapClass['span10'];?>">
                    <?php echo $lists['venues'];?>
                </div>
            </div>
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div class="<?php echo $mapClass['span2'];?> boldtext">
                    <?php echo JText::_('OS_SELECT_EMPLOYEES')?>
                </div>
                <div class="<?php echo $mapClass['span10'];?>">
                    <?php echo $lists['employees'];?>
                </div>
            </div>

            <?php
            if($show_date == 1){
                ?>
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div class="<?php echo $mapClass['span2'];?> boldtext">
                    <?php echo JText::_('OS_SELECT_BOOKING_DATE')?>
                </div>
                <div class="<?php echo $mapClass['span10'];?>">
                    <?php
                    echo JHTML::_('calendar',$jinput->get('booking_date','','string'), 'booking_date', 'booking_date', '%Y-%m-%d', array('class'=>'input-small', 'size'=>'19',  'maxlength'=>'19','style'=>'width:80px;'));
                    ?>
                </div>
            </div>
            <div class="<?php echo $mapClass['row-fluid'];?>">
                <div class="<?php echo $mapClass['span12'];?>" style="text-align:center;padding:20px;">
                    <a href="javascript:document.adminForm.submit();" class="btn btn-danger" style="color:white;"><?php echo JText::_('OS_SHOW_TIME_SLOTS');?></a>
                </div>
            </div>
                <?php
                if(($sid > 0) and ($eid > 0) and ($booking_date != "")){
                    if(OSBHelper::checkAvailableDate($sid,$eid,$booking_date)){
                        ?>
                        <div class="<?php echo $mapClass['row-fluid'];?> bookingformdiv">
                            <div class="<?php echo $mapClass['span12'];?> btn btn-danger boldtext">
                                <?php echo JText::_('OS_OFF_DATE_PLEASE_SELECT_ANOTHER_DATE');?>
                            </div>
                        </div>
                        <?php
                    }elseif(OSBHelper::isEmployeeAvailableInSpecificDate($sid,$eid,$booking_date)){
                        ?>

                        <div class="<?php echo $mapClass['row-fluid'];?> bookingformdiv" style="margin-left:0px;">
                            <div class="<?php echo $mapClass['span12'];?>">
                                <div class="<?php echo $mapClass['row-fluid'];?>">
                                    <div class="<?php echo $mapClass['span12'];?> btn btn-warning boldtext">
                                        <?php echo JText::_('OS_PLEASE_SELECT_TIME_SLOTS_BELLOW');?>
                                    </div>
                                </div>
                                <div class="<?php echo $mapClass['row-fluid'];?>">
                                    <div class="<?php echo $mapClass['span7'];?>">
                                        <BR />
                                        <?php
                                        OSBHelper::loadTimeSlots($sid,$eid,$booking_date);
                                        ?>
                                    </div>
                                    <div class="<?php echo $mapClass['span5'];?>">
                                        <?php echo OsAppscheduleDefault::loadExtraFields($sid,$eid);?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php
                    }else{
                        ?>
                        <div class="<?php echo $mapClass['row-fluid'];?> bookingformdiv">
                            <div class="<?php echo $mapClass['span12'];?> btn btn-danger boldtext">
                                <?php echo JText::_('OS_UNAVAILABLE');?>
                            </div>
                        </div>
                        <?php
                    }
                }
            }
            ?>
            </div>
            <input type="hidden" name="option" value="com_osservicesbooking" />
            <input type="hidden" name="task" id="task" value="manage_addservice" />
            <input type="hidden" name="order_id" value="<?php echo $order_id?>" />
            <input type="hidden" name="boxchecked" value="0" />
            <input type="hidden" name="nslots" id="nslots" value="" />
        </form>
        <script language="javascript">
            function addBackendBooking(id,start_time,end_time){
                var select = document.getElementById('selected_timeslots');
                for ( var i = 0, l = select.options.length, o; i < l; i++ ){
                    o = select.options[i];
                    if ( o.value == start_time + "-" + end_time ){
                        if(o.selected == true){
                            o.selected = false;
                        }else{
                            o.selected = true;
                        }
                    }
                }
            }
            function updateNslots(id){
                var temp = document.getElementById(id);
                if(temp.checked == true){
                    var nslots = document.getElementById('nslots' + id);
                    if(nslots != null){
                        document.getElementById('nslots').value = nslots.value;
                    }
                }
            }
            function saveOrderItem(){
                jQuery("#task").val('manage_saveorderitem');
                document.adminForm.submit();
            }
            function gotoOrderDetails(){
                location.href="<?php echo JUri::root()?>index.php?option=com_osservicesbooking&task=manage_editorder&id=<?php echo $order_id?>";
            }
        </script>
        <?php
    }

    public static function showUserInfo($orders,$user, $balance)
    {
        global $mainframe, $jinput, $mapClass, $configClass;
        $document = JFactory::getDocument();
        $document->setTitle(sprintf(JText::_('OS_USER_INFORMATION'), $user->name));
        jimport('joomla.filesystem.file');
        if(JFile::exists(JPATH_ROOT.'/templates/'.$mainframe->getTemplate().'/html/com_osservicesbooking/orderhistory.php'))
        {
            $tpl = new OSappscheduleTemplate(JPATH_ROOT.'/templates/'.$mainframe->getTemplate().'/html/com_osservicesbooking/');
        }
        else
        {
            $tpl = new OSappscheduleTemplate(JPATH_COMPONENT.'/components/com_osservicesbooking/layouts/');
        }
        $tpl->set('mainframe',$mainframe);
        $tpl->set('rows',$orders);
        $tpl->set('jinput',$jinput);
        $tpl->set('mapClass',$mapClass);
        $tpl->set('configClass',$configClass);
        $tpl->set('user', $user);
        $tpl->set('task','manage_userinfo');
        $tpl->set('balance', $balance);
        $body = $tpl->fetch("orderhistory.php");
        echo $body;
    }
}
?>