<?php
/**
 * @version		1.1.1
 * @package		Joomla
 * @subpackage	OS Services Booking
 * @author      Dang Thuc Dam
 * @copyright	Copyright (C) 2018 Ossolution Team
 * @license		GNU/GPL, see LICENSE.php
 */
// no direct access
defined( '_JEXEC' ) or die ;

class os_paypal extends os_payment
{
    /**
     * Paypal mode
     *
     * @var boolean live mode : true, test mode : false
     */
    var $_mode = 0;
    /**
     * Paypal url
     *
     * @var string
     */
    var $_url = null;
    /**
     * Array of params will be posted to server
     *
     * @var string
     */
    var $_params = array();
    /**
     * Array containing data posted from paypal to our server
     *
     * @var array
     */
    var $_data = array();

    /**
     * Constructor functions, init some parameter
     *
     * @param object $config
     */
    function os_paypal($params)
    {
        parent::setName('os_paypal');
        parent::os_payment();
        parent::setCreditCard(false);
        parent::setCardType(false);
        parent::setCardCvv(false);
        parent::setCardHolderName(false);
        $configClass = OSBHelper::loadConfig();
        $this->ipn_log = false;
        $this->ipn_log_file = '';
        $this->_mode = $params->get('paypal_mode');
        if ($this->_mode)
            $this->_url = 'https://www.paypal.com/cgi-bin/webscr';
        else
            $this->_url = 'https://www.sandbox.paypal.com/cgi-bin/webscr';
        $this->setParam('business', $params->get('paypal_id'));
        $this->setParam('rm', 2);
        $this->setParam('cmd', '_xclick');
        $this->setParam('no_shipping', 1);
        $this->setParam('no_note', 1);
        $this->setParam('lc', 'US');
        $this->setParam('currency_code', $configClass['currency_format']);
        $this->setParam('use_new_paypal_ipn_verification', 1);
        $this->setParam('ipn_log', $params->get('ipn_log'));
    }

    /**
     * Set param value
     *
     * @param string $name
     * @param string $val
     */
    function setParam($name, $val)
    {
        $this->_params[$name] = $val;
    }

    /**
     * Setup payment parameter
     *
     * @param array $params
     */
    function setParams($params)
    {
        foreach ($params as $key => $value) {
            $this->_params[$key] = $value;
        }
    }

    /**
     * Process Payment
     *
     * @param object $row
     * @param array $params
     */
    function processPayment($row, $data)
    {
        require_once JPATH_ADMINISTRATOR.'/components/com_osservicesbooking/helpers/helper.php';
        $db     = JFactory::getDbo();
        $jinput = JFactory::getApplication()->input;
        $Itemid = $jinput->getInt('Itemid', 0);
        $siteUrl = JURI::base();

        if(OSBHelper::orderHasOneService($row->id))
        {
            $service = OSBHelper::getServiceIdOfOrder($row->id);
            if($service->paypal_id != ""){
                $this->setParam('business', $service->paypal_id);
            }
        }

        $this->setParam('item_name', $data['item_name']);
        $this->setParam('amount', $data['amount']);

        $this->setParam('custom', $row->id);
        $this->setParam('return', $siteUrl . "index.php?option=com_osservicesbooking&task=default_paymentreturn&id=$row->id&Itemid=" . $Itemid);
        $this->setParam('cancel_return', $siteUrl . 'index.php?option=com_osservicesbooking&task=default_paymentcancel&id=' . $row->id);
        $this->setParam('notify_url', $siteUrl . 'index.php?option=com_osservicesbooking&task=defaul_paymentconfirm&payment_method=os_paypal');
        $this->setParam('address1', $data['address']);
        $this->setParam('address2', '');
        $this->setParam('city', $data['city']);
        $this->setParam('country', $data['country']);
        $this->setParam('first_name', $data['first_name']);
        $this->setParam('last_name', $data['last_name']);
        $this->setParam('state', $data['state']);
        $this->setParam('zip', $data['zip']);
        $this->setParam('email', $row->order_email);

        $sid    = OSBHelper::checkOrderWithOneService($row->id);
        if($sid > 0)
        {
            $db->setQuery("Select paypal_id from #__app_sch_services where id = '$row->id'");
            $paypal_id = $db->loadResult();
            if($paypal_id != "")
            {
                $this->setParam('business', $paypal_id);
            }
        }

        $this->submitPost();
    }

    /**
     * Submit post to paypal server
     *
     */
    function submitPost()
    {
        ?>
        <div class="contentheading"><?php echo JText::_('OS_WAIT_PAYPAL'); ?></div>
        <form method="post" action="<?php echo $this->_url; ?>" name="osm_form" id="osm_form">
            <?php
            foreach ($this->_params as $key => $val) {
                echo '<input type="hidden" name="' . $key . '" value="' . $val . '" />';
                echo "\n";
            }
            ?>
            <script type="text/javascript">
                function redirect() {
                    document.osm_form.submit();
                }
                setTimeout('redirect()', 7000);
            </script>
        </form>
        <?php
    }

    /**
     * Validate the post data from paypal to our server
     *
     * @return string
     */
    function _validate()
    {
        if (function_exists('curl_init')) {
            return $this->validateIPN();
        }

        $this->_data = $_POST;

        $hostname = $this->_mode ? 'www.paypal.com' : 'www.sandbox.paypal.com';
        $url      = 'ssl://' . $hostname;
        $port     = 443;
        $req      = 'cmd=_notify-validate';

        foreach ($_POST as $key => $value)
        {
            $value = urlencode(stripslashes($value));
            $req .= "&$key=$value";
        }

        $header = '';
        $header .= "POST /cgi-bin/webscr HTTP/1.1\r\n";
        $header .= "Host: $hostname:$port\r\n";
        $header .= "Content-Type: application/x-www-form-urlencoded\r\n";
        $header .= "Content-Length: " . strlen($req) . "\r\n";
        $header .= "User-Agent: OS Services Booking\r\n";
        $header .= "Connection: Close\r\n\r\n";

        $errNum   = '';
        $errStr   = '';
        $response = '';
        $fp       = fsockopen($url, $port, $errNum, $errStr, 30);

        if (!$fp)
        {
            $response = 'Could not open SSL connection to ' . $hostname . ':' . $port;
            $this->logGatewayData($response);

            return false;
        }

        fputs($fp, $header . $req);
        while (!feof($fp))
        {
            $response .= fgets($fp, 1024);
        }
        fclose($fp);

        $this->logGatewayData($response);

        if (!$this->_mode || stristr($response, "VERIFIED"))
        {
            return true;
        }

        return false;
    }

    /**
     * Validate PayPal IPN using PayPal library
     *
     * @return bool
     */
    protected function validateIPN()
    {
        JLoader::register('PaypalIPN', JPATH_ROOT . '/components/com_osservicesbooking/plugins/paypal/PayPalIPN.php');
        $ipn            = new PaypalIPN;
        // Use sandbox URL if test mode is configured
        if (!$this->_mode) {
            $ipn->useSandbox();
        }
        // Disable use custom certs
        $ipn->usePHPCerts();
        $this->_data    = $_POST;
        try {
            $valid      = $ipn->verifyIPN();
            $this->logGatewayData($ipn->getResponse());
            if (!$this->_mode || $valid) {
                return true;
            }
            return false;
        } catch (Exception $e) {
            $this->logGatewayData($e->getMessage());
            return false;
        }
    }

    protected function logGatewayData($extraData = null)
	{
		if (!$this->_params['ipn_log'])
		{
			return;
		}
        $text = '[' . date('m/d/Y g:i A') . '] - ';
        $text .= "Notification Data From : Paypal \n";
        foreach ($this->_data as $key => $value) {
            $text .= "$key=$value, ";
        }
        $text .= $extraData;
        $ipnLogFile = JPATH_COMPONENT . '/ipn_' . $this->getName() . '.txt';
        $fp = fopen($ipnLogFile, 'a');
        fwrite($fp, $text . "\n\n");
        fclose($fp);
    }

	/**
	 * Process payment 
	 *
	 */
	function verifyPayment() {
		$ret = $this->_validate();				
		if ($ret) {
			$configClass = OSBHelper::loadConfig();
			$transactionId = $this->_data['txn_id'];
			$amount        = $this->_data['mc_gross'];
			$currency      = $this->_data['mc_currency'];
			require_once(JPATH_COMPONENT_ADMINISTRATOR."/tables/order.php");
			$row = JTable::getInstance('Order', 'OsAppTable');
			$id = $this->_data['custom'];
			$db = JFactory::getDbo();
			$db->setQuery("Select order_status from #__app_sch_orders where id = '$id'");
			$order_status = $db->loadResult();
			if($order_status != "S"){ //only running when the system already update Order status
	   			if ($amount < 0) {
					return false;
				}
				$row->load($id);

				if ($row->order_status == "S") {
					return false;
				}

				if(($currency == "") || (strtoupper($currency) != strtoupper($configClass['currency_format']))){
					return false;
				}

				if(floatval($amount) < $row->order_upfront){
					return false;
				}

	        	$row->transaction_id = $transactionId;
	        	$row->order_status = "S";
	        	$row->store();	
				OsAppscheduleDefault::paymentComplete($row->id);
	   			return true;
			}
		} else {
			return false;
		}		     
	}	
}