<?php
/**
 *	@package		Sendinblue
 *	@subpackage		subscription.php
 *	@version		1.0.9
 *
 *	@author			Branislav Gligorov <branislav.gligorov@itsbg.eu>	
 *	@copyright		Copyright (C) 2018 Sendinblue, All Rights Reserved
 *	@license		GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html
 */


// No direct access to this file
defined('_JEXEC') or die('Restricted access');

/**
 * Sendinblue Subscription Controller
 */
class SendinblueControllerSubscription extends JControllerForm
{
	/**
	 * Current or most recently performed task.
	 *
	 * @var    string
	 * @since  12.2
	 * @note   Replaces _task.
	 */
	protected $task;

	public function __construct($config = array())
	{
		$this->view_list = ''; // safeguard for setting the return view listing to the default site view.
		parent::__construct($config);
	}

public function subscribe() {
	// Check for request forgeries.
	$this->checkToken();

	$app = \JFactory::getApplication();
	$params	= JComponentHelper::getParams('com_sendinblue');

	$input = \JFactory::getApplication()->input;
	$model = $this->getModel();
	$data  = $input->post->getArray();

	$return = $input->get('return', '', 'RAW');
	//$this->setRedirect(JRoute::_('index.php?option=com_sendinblue&view=attributes' . $this->getRedirectToListAppend(), false));
	$this->setRedirect(base64_decode($return));

	// get formid
	foreach ($data as $key => $value) {
		if (strpos($key, 'sendinblueform') === 0) {  // hardlink to form variable name
			$nameparts = explode('-', $key);
			$moduleid = $nameparts[1];
			$prefix = $nameparts[0] . '-' . $nameparts[1] . '-';
			break;
		}
	}
	if (isset($moduleid)) { $formData = SibJapiHelper::getFormDataByModuleId($moduleid); }

	if ($formData) {	
		$blocks = SibJapiHelper::fromObject(json_decode($formData->blocksubform), false);
		foreach ($blocks as $key => $item) {
			if ($item->blockvisible == '1') {
				if ($item->blocktypeid == 'email' && $item->blockvisible == '1') { $emailkey = $key; }
				if ($item->blocktypeid == 'captcha' && $item->blockvisible == '1') { $captchachk = $key; }
				if ($item->blocktypeid == 'optin' && $item->blockvisible == '1') { $optinkey = $key; }
			}
		}
	} else {
		$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_ERROR_INVALID_FORM_SOURCE_DATA');
		$app->enqueueMessage($msg, 'error');
		return false;
	}
		
	if (trim($formData->siblists) == '') {
		$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_ERROR_INVALID_FORM_SOURCE_DATA');
		$app->enqueueMessage($msg, 'error');
		return false;
	}
	
	// validation checks
	if (isset($emailkey)) {
		$email = strtolower(trim($input->get($prefix . $emailkey, '', 'email')));
		if ($email == '') {
			$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_ERROR_EMAIL_MISSING');
			$app->enqueueMessage($msg, 'error');
			return false;
		} 
	} else {  // double check -> this is already checked on form save but in any case we should not continue with this procedure if there is no email
		$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_ERROR_EMAIL_FIELD_MISSING');
		$app->enqueueMessage($msg, 'error');
		return false;
	}

	if (isset($captchachk)) {
		$config = JFactory::getConfig()->get('captcha');
		$captcha = JCaptcha::getInstance($config);
		try {
			$completed = $captcha->checkAnswer('captcha');
		} catch (exception $e) {
			$app->enqueueMessage($e->getMessage());
			return false;
		}
	}
	
	if (isset($optinkey)) {  // optin must be checked
		$optin = $prefix . $optinkey;
		if ( !(isset($data[$optin])) || (isset($data[$optin]) && $data[$optin] != '1') ) {
// subsformmsgoptinerror
			$formmsg = $formData->subsformmsgoptinerror;
			if (trim($formmsg) != '') {
				$msg = $formmsg;
			} else {
				$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_ERROR_OPTIN_NOTCHECKED');
			}
			$app->enqueueMessage($msg, 'error');
			return false;
		}
	}

	// form is ok 
	$success = 0;	
	if ($email != '') {
		$this->sibjapi = SibJapiHelper::getSibJapi();
		if ($this->sibjapi->accountDetails === null || $this->sibjapi->accountDetails === false) {
			foreach ($this->sibjapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
		} else {
			$doubleOptinAttribName = $params->get('doubleoptinattributename');
			$contactData = $this->sibjapi->getDataAll('contacts/' . urlencode($email), true, true);
			
			// store subscription data for any type of confirmation
			if ( ($token = SibJapiHelper::createSubscriptionData($email, $formData->id, $formData->confirmationtype)) == false ) {
				$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_SUBSCRIPTIONDATA_SAVE_ERROR');
				foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
				$app->enqueueMessage($msg, 'error');
				return false;
			}
			
			if ($formData->confirmationtype == '3') {
				// get templist id (create it if it is missing) 
				$tempListId = SibJapiHelper::getTempListId();
				if ($tempListId == false) {
					$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_GET_TEMPLISTID_ERROR');
					foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
					$app->enqueueMessage($msg, 'error');
					return false;
				}
				// check if there is Double optin field in sendinblue account
				if ( ($doi = SibJapiHelper::checkDoubleOptinAttribute($this->sibjapi, $doubleOptinAttribName)) == false) {
					$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CHECK_DOUBLEOPTIN_ATTRIB_ERROR');
					foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
					$app->enqueueMessage($msg, 'error');
					return false;
				}
				
			}			
			
			$attribs = new stdClass();
			foreach ($blocks as $key => $item) {
				if ($item->blockvisible == '1') {
					switch ($item->blocktypeid) {
						case 'attribnormaltext':
							$attribs->{$item->blockattribnormaltextattribid} = $input->get($prefix . $key, '', 'STRING');
							break;
						case 'attribnormalnumber':
							$attribs->{$item->blockattribnormalnumberattribid} = $input->get($prefix . $key, '', 'INT');
							break;
						case 'attribnormaldate':
							$attribs->{$item->blockattribnormaldateattribid} = $input->get($prefix . $key, '', 'STRING');
							break;
						case 'attribnormalbool':
							$boolset = $input->get($prefix . $key, '', 'BOOLEAN');
							if ($boolset != '') {
								$attribs->{$item->blockattribnormalboolattribid} = true;
							}
							break;
						case 'attribcategorysingle':
							$attribs->{$item->blockattribcategoryattribid} = $input->get($prefix . $key, '', 'STRING');
							break;
						case 'attribcategorymulti': // not implemeted, this should checked if should be implemeted
							$attribs->{$item->blockattribcategoryattribid} = $input->get($prefix . $key, '', 'STRING');
							break;
						default:
							break;
					}
				}
			}
			if ($formData->confirmationtype == '3') {  // special attrib 
				if ( isset($contactData->attributes->{$doubleOptinAttribName}) ) {
					// if alraedy set leave it as is					
				} else {
					$attribs->{$doubleOptinAttribName} = '2'; // set to No
				}
			}
					
			$cdata = new stdClass();
			$cdata->email = strtolower($email); 
			$cdata->attributes = $attribs;
	
			if ($formData->confirmationtype == '3') {
				$lists[] = (int) $tempListId;
			} else {
				if (trim($formData->siblists) == '') {
					$lists = array();
				} else {
					$listsObj = json_decode($formData->siblists);
					$listsArr = SibJapiHelper::fromObject($listsObj);
					foreach ($listsArr as $value) { $lists[] = (int) $value; }
				}
			}
			$cdata->listIds = $lists;

			$cdata->emailBlacklisted = false; // in any case reset to not blacklisted
					
			if ($contactData == false) { // try to add contact

				$response = $this->sibjapi->createContact($cdata);
				if ($response === false) {
// subsformmsgcreateerror					
					$formmsg = $formData->subsformmsgcreateerror;
					if (trim($formmsg) != '') {
						$msg = $formmsg;
					} else {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CREATING_CONTACT_AND_SUBSCRIPTION_ERROR') . $cdata->email;
					}
					foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
					$app->enqueueMessage($msg, 'error');
					$this->sibjapi->errors = array(); // reset in case of loops
				} else {
					$success = 1;
					if ($formData->confirmationtype == '3') {
// subsformmsgcreateformsuccess
						$formmsg = $formData->subsformmsgcreateformsuccess;
						if (trim($formmsg) != '') {
							$msg = $formmsg;
						} else {
							$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CREATING_CONTACT_AND_SUBSCRIPTION_FORM_SUBMITED_SUCCESS') . $cdata->email;
						}
					} else {
// subsformmsgcreatesubscriptionsuccess						
						$formmsg = $formData->subsformmsgcreatesubscriptionsuccess;
						if (trim($formmsg) != '') {
							$msg = $formmsg;
						} else {
							$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CREATING_CONTACT_AND_SUBSCRIPTION_SUCCESS') . $cdata->email;
						}	
					} 
					$app->enqueueMessage($msg);
				}

			} else {  // update
				// if contact was blacklisted removew it from all previous lists
				if ($contactData->emailBlacklisted == true) {
					$listsPrevous = $contactData->listIds;
					$listsDiff = array_diff($listsPrevous, $lists);
					foreach ($listsDiff as $item) { $listsDiffint[] = (int) $item; }
					if (count($listsDiffint)) { $cdata->unlinkListIds = $listsDiffint; }
				}
			
				$response = $this->sibjapi->updateContact($cdata);
				if ($response === false) {
// subsformmsgupdateerror					
					$formmsg = $formData->subsformmsgupdateerror;
					if (trim($formmsg) != '') {
						$msg = $formmsg;
					} else {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_UPDATING_CONTACT_AND_SUBSCRIPTION_ERROR') . $cdata->email;
					}
					foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
					$app->enqueueMessage($msg, 'error');
				} else {
					$success = 1;
					if ($formData->confirmationtype == '3') {
// subsformmsgupdateformsuccess
						$formmsg = $formData->subsformmsgupdateformsuccess;
						if (trim($formmsg) != '') {
							$msg = $formmsg;
						} else {
							$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_UPDATING_CONTACT_AND_SUBSCRIPTION_FORM_SUBMITED_SUCCESS') . $cdata->email;
						}
					} else {
// subsformmsgupdatesubscriptionsuccess
						$formmsg = $formData->subsformmsgupdatesubscriptionsuccess;
						if (trim($formmsg) != '') {
							$msg = $formmsg;
						} else {
							$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_UPDATING_CONTACT_AND_SUBSCRIPTION_SUCCESS') . $cdata->email;
						}	
					} 
					$app->enqueueMessage($msg);
				}
							
				
			}
		
		}
		
	}
	// subscrition successfully set (conf type 1 or 2) or data successfully set (conf type 3 - waiting for confirmation)
	// lets send emails and set redirection
	if ($success == 1) {
		// emails
		$tmplid = 0;
		if ($formData->confirmationtype == '3') {
			$tmplid = $formData->optintmplid;
			$link = JUri::base() . 'index.php?option=com_sendinblue&task=subscription.confirm&e='.urlencode($email).'&t=' . $token;				
		} elseif ($formData->confirmationtype == '2') {
			$tmplid = $formData->followuptmplid;
		} else { /* nothing to send */ }
		
		if ($tmplid != 0) {
			$tmplData = $this->sibjapi->getDataAll('smtp/templates/'. $tmplid, true, true);
			if ($tmplData->isActive == false) {
				// log to 
			} else {
				$mailer = JFactory::getMailer();
				$config = JFactory::getConfig();
				$sender = array( $config->get('mailfrom'), $config->get('fromname') );
				$recipient = $cdata->email;
				$mailer->addRecipient($recipient);
				if ($tmplData->replyTo != '[DEFAULT_REPLY_TO]') {
					$mailer->addReplyTo( array($tmplData->replyTo, $config->get('fromname')) );
				}
				$mailer->setSubject($tmplData->subject);
				
				$body   = $tmplData->htmlContent;
				
				if ($formData->confirmationtype == '3') {
					if ( ($search= trim($params->get('optintemplatelinktag'))) != '') {
						$body = str_replace($search, $link, $body);
					}
				}
				
				$mailer->isHtml(true);
				$mailer->Encoding = 'base64';
				$mailer->setBody($body);
				
				$send = $mailer->Send();
				if ( $send !== true ) {
					if ($formData->confirmationtype == '3') {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_OPTIN_EMAIL_ERROR') . $cdata->email;
					} elseif ($formData->confirmationtype == '2') {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_FOLLOWUP_EMAIL_ERROR') . $cdata->email;
					} else {
						// no email is sent
					}
					$app->enqueueMessage($msg);
				} else {
					if ($formData->confirmationtype == '3') {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_OPTIN_EMAIL_SENT') . $cdata->email;
					} elseif ($formData->confirmationtype == '2') {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_FOLLOWUP_EMAIL_SENT') . $cdata->email;
					} else {
						// no email is sent
					}
					$app->enqueueMessage($msg);
				}

			}
		}

		// redirection (here you can attach to link messages from process if there is a need urlencode($app->messageQueue))
		if ($formData->confirmationtype == '3') {
			if ($formData->formredirectpage == '1' && trim($formData->formredirectpagecustom != '')) {
				$this->setRedirect($formData->formredirectpagecustom);
			}
		} else {
			if ($formData->confirmationpage == '1' && trim($formData->confirmationpagecustom != '')) {
				$this->setRedirect($formData->confirmationpagecustom);
			}
		}
		
	}
	

}
public function confirm() {
	$app = \JFactory::getApplication();
	$params	= JComponentHelper::getParams('com_sendinblue');
	
	$this->setRedirect(JUri::base());
	
	$timediffMin = $params->get('optinlinkvalidityperiod'); 
	$timeDiffSec = (int) $timediffMin * 60;
	$notOlderThen = time() - $timeDiffSec;
	$notOlderThenMySQL = date("Y-m-d H:i:s", $notOlderThen);
	
	$input = \JFactory::getApplication()->input;
	$model = $this->getModel();
	//$data  = $input->get->getArray();
	$email = $input->get('e', '', 'STRING');
	$token = $input->get('t', '', 'STRING');
	
	$db = JFactory::getDbo();
	
	if ($email == '' || $token == '') {
		$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_DATA_ERROR');
		$app->enqueueMessage($msg);
		return false;		
	}
	$query = 'SELECT * FROM #__sendinblue_subscription_data WHERE `email` = "'.$email.'" AND token = "'.$token.'" 
				AND `created` > "'.$notOlderThenMySQL.'" AND `published` = "1"';
	$db->setQuery($query);
	$data = $db->loadObject();

	if ($data) {
		
		$this->sibjapi = SibJapiHelper::getSibJapi();
		if ($this->sibjapi->accountDetails === null || $this->sibjapi->accountDetails === false) {
			foreach ($this->sibjapi->errors as $key => $value) { $app->enqueueMessage($value, 'error'); }
		} else {
		
			// update local
			$query = 'UPDATE #__sendinblue_subscription_data SET published = "2" WHERE id = '.$data->id;
			$db->setQuery($query);
			$db->query();
			
			// update Sendinblue
			$formData = SibJapiHelper::getFormData($data->subscriptionformid);
			$tempListId = SibJapiHelper::getTempListId();
			if ($tempListId == false) {
				$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_GET_TEMPLISTID_ERROR');
				foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
				$app->enqueueMessage($msg, 'error');
				return false;
			}
			

			$cdata = new stdClass();
			$cdata->email = strtolower($email); 
	
			$listsObj = json_decode($formData->siblists);
			$listsArr = SibJapiHelper::fromObject($listsObj);
			foreach ($listsArr as $value) { $lists[] = (int) $value; }
			$cdata->listIds = $lists;

			$listsPrevous = array($tempListId);
			$listsDiff = array_diff($listsPrevous, $lists);
			foreach ($listsDiff as $item) { $listsDiffint[] = (int) $item; }
			if (count($listsDiffint)) { $cdata->unlinkListIds = $listsDiffint; }

			$doubleOptinAttribName = $params->get('doubleoptinattributename');
			$attribs = new stdClass();
			$attribs->{$doubleOptinAttribName} = '1'; // set to Yes
			$cdata->attributes = $attribs;
						
			$response = $this->sibjapi->updateContact($cdata);
			if ($response === false) {
// subsformmsgconfirmsubscriptionerror
				$formmsg = $formData->subsformmsgconfirmsubscriptionerror;
				if (trim($formmsg) != '') {
					$msg = $formmsg;
				} else {
					$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CONFIRM_UPDATING_CONTACT_ERROR') . $cdata->email;
				}
				foreach ($this->sibjapi->errors as $key => $value) { $msg .= ' ' . $value; }
				$app->enqueueMessage($msg, 'error');
			} else {
				$success = 1;
// subsformmsgconfirmsubscriptionsuccess
				$formmsg = $formData->subsformmsgconfirmsubscriptionsuccess;
				if (trim($formmsg) != '') {
					$msg = $formmsg;
				} else {
					$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_CONFIRM_SUCCESS');
				}
				$app->enqueueMessage($msg);
			}
			
			// send mail
			$tmplid = 0;
			if ($formData->finalconfirmation == '1') { $tmplid = $formData->finalfollowuptmplid; }
			if ($tmplid != 0) {
				$tmplData = $this->sibjapi->getDataAll('smtp/templates/'. $tmplid, true, true);
				if ($tmplData->isActive == false) {
					// log to 
				} else {
					$mailer = JFactory::getMailer();
					$config = JFactory::getConfig();
					$sender = array( $config->get('mailfrom'), $config->get('fromname') );
					$recipient = $cdata->email;
					$mailer->addRecipient($recipient);
					if ($tmplData->replyTo != '[DEFAULT_REPLY_TO]') {
						$mailer->addReplyTo( array($tmplData->replyTo, $config->get('fromname')) );
					}
					$mailer->setSubject($tmplData->subject);
					
					$body   = $tmplData->htmlContent;
					
					$mailer->isHtml(true);
					$mailer->Encoding = 'base64';
					$mailer->setBody($body);
					
					$send = $mailer->Send();
					if ( $send !== true ) {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_FINAL_EMAIL_ERROR') . $cdata->email;
						$app->enqueueMessage($msg);
					} else {
						$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_FINAL_EMAIL_SENT') . $cdata->email;
						$app->enqueueMessage($msg);
					}
	
				}
			}

			//redirect
			if ($formData->confirmationpage == '1' && trim($formData->confirmationpagecustom != '')) {
				$this->setRedirect($formData->confirmationpagecustom);
			}
			return true;
		}			
	} else {
// subsformmsgconfirmsubscriptionerrorlink
		$formmsg = $formData->subsformmsgconfirmsubscriptionerrorlink;
		if (trim($formmsg) != '') {
			$msg = $formmsg;
		} else {
			$msg = JText::_('COM_SENDINBLUE_SUBSCRIPTION_DATA_ERROR');
		}
		$app->enqueueMessage($msg);
		return false;		
	}
	
}

	/**
	 * Method to check if you can edit an existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key; default is id.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

        /**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.6
	 */
	protected function allowAdd($data = array())
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Method to check if you can save a new or existing record.
	 *
	 * Extended classes can override this if necessary.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   12.2
	 */
	protected function allowSave($data, $key = 'id')
	{
		// to insure no other tampering
		return false;
	}

	/**
	 * Function that allows child controller access to model data
	 * after the data has been saved.
	 *
	 * @param   JModelLegacy  $model      The data model object.
	 * @param   array         $validData  The validated data.
	 *
	 * @return  void
	 *
	 * @since   12.2
	 */
	protected function postSaveHook(JModelLegacy $model, $validData = array())
	{
	}
}
